/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.effect.RiteEffectCurseCreature;
import net.msrandom.witchery.rite.effect.RiteEffectTeleportEntity;
import org.jetbrains.annotations.Nullable;

public abstract class BlockAreaMarker
extends BlockContainer {
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.15f, 0.0, (double)0.15f, (double)0.85f, 0.5, (double)0.85f);

    public BlockAreaMarker() {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149722_s();
        this.func_149752_b(9999.0f);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    protected abstract TileEntityType<? extends TileEntityAreaMarker> getEntity();

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.getEntity().create();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityAreaMarker) {
                TileEntityAreaMarker marker = (TileEntityAreaMarker)tile;
                marker.setOwnerId(player.func_110124_au());
            }
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        if (!world.field_72995_K & player != null && (tile = world.func_175625_s(pos)) instanceof TileEntityAreaMarker) {
            TileEntityAreaMarker marker = (TileEntityAreaMarker)tile;
            if (player.field_71075_bZ.field_75098_d || player.func_70005_c_().equals(marker.getOwnerId()) && player.func_70093_af()) {
                int dy = pos.func_177956_o();
                while (world.func_180495_p(new BlockPos(x, dy, z)).func_177230_c() == this) {
                    world.func_175698_g(new BlockPos(x, dy, z));
                    world.func_72838_d((Entity)new EntityItem(world, 0.5 + (double)x, 0.5 + (double)dy, 0.5 + (double)z, new ItemStack((Block)this)));
                    ++dy;
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAreaMarker) {
            TileEntityAreaMarker marker = (TileEntityAreaMarker)tile;
            return marker.activateBlock();
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public static abstract class TileEntityAreaMarker
    extends WitcheryTileEntity {
        private static final String OWNER_KEY = "WitcheryPlacer";
        private final Set<UUID> killers = new HashSet<UUID>();
        private UUID owner;

        @Override
        protected void initiate() {
            super.initiate();
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == this.getExpectedBlockType()) {
                AreaMarkerRegistry.instance().add(this);
            }
        }

        public void func_145843_s() {
            super.func_145843_s();
            if (!this.field_145850_b.field_72995_K) {
                AreaMarkerRegistry.instance().remove(this);
            }
        }

        public UUID getOwnerId() {
            return this.owner;
        }

        public void setOwnerId(UUID username) {
            this.owner = username;
        }

        public void addKiller(EntityPlayer player) {
            this.killers.add(player.func_110124_au());
        }

        public boolean checkIsProtected(EntityLivingBase entity, RiteEffect ritual) {
            if (this.isNear(entity)) {
                boolean killer = entity instanceof EntityPlayer && this.killers.contains(entity.func_110124_au());
                return this.isProtected(killer, ritual);
            }
            return false;
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbtTag) {
            super.func_189515_b(nbtTag);
            if (this.getOwnerId() != null) {
                nbtTag.func_186854_a(OWNER_KEY, this.getOwnerId());
            }
            NBTTagList nbtKillers = new NBTTagList();
            for (UUID killer : this.killers) {
                nbtKillers.func_74742_a((NBTBase)new NBTTagString(killer.toString()));
            }
            nbtTag.func_74782_a("Killers", (NBTBase)nbtKillers);
            return nbtTag;
        }

        public void func_145839_a(NBTTagCompound nbtTag) {
            super.func_145839_a(nbtTag);
            if (nbtTag.func_186855_b(OWNER_KEY)) {
                this.owner = nbtTag.func_186857_a(OWNER_KEY);
            }
            NBTTagList nbtKillers = nbtTag.func_150295_c("Killers", 8);
            int count = nbtKillers.func_74745_c();
            for (int i = 0; i < count; ++i) {
                this.killers.add(UUID.fromString(nbtKillers.func_150307_f(i)));
            }
        }

        public abstract boolean activateBlock();

        public abstract boolean isNear(EntityLivingBase var1);

        protected abstract boolean isProtected(boolean var1, RiteEffect var2);

        protected abstract Block getExpectedBlockType();
    }

    public static class AreaMarkerRegistry {
        private static final AreaMarkerRegistry INSTANCE = new AreaMarkerRegistry();
        public final Set<TileEntityAreaMarker> tiles = new HashSet<TileEntityAreaMarker>();

        public static AreaMarkerRegistry instance() {
            return INSTANCE;
        }

        private void add(TileEntityAreaMarker tile) {
            this.update(tile);
            this.tiles.add(tile);
        }

        private void remove(TileEntityAreaMarker tile) {
            this.tiles.remove((Object)tile);
            this.update(tile);
        }

        private void update(TileEntityAreaMarker tile) {
            this.tiles.removeIf(source -> source == null || source.func_145837_r() || source.func_174877_v().equals((Object)tile.func_174877_v()));
        }

        public boolean isProtectionActive(EntityLivingBase entity, RiteEffect ritual) {
            for (TileEntityAreaMarker tile : this.tiles) {
                if (!tile.checkIsProtected(entity, ritual)) continue;
                return true;
            }
            return false;
        }
    }

    public static class TileEntityAreaTeleportPullProtect
    extends TileEntityAreaMarker {
        @Override
        public boolean activateBlock() {
            return false;
        }

        @Override
        protected boolean isProtected(boolean killer, RiteEffect ritual) {
            return !killer && (ritual == null || ritual instanceof RiteEffectTeleportEntity);
        }

        @Override
        public boolean isNear(EntityLivingBase entity) {
            int RADIUS = WitcheryConfigOptions.decurseTeleportPullRadius;
            int RADIUS_SQ = RADIUS * RADIUS;
            boolean inRange = this.func_174877_v().func_177954_c(entity.field_70165_t, (double)this.func_174877_v().func_177956_o(), entity.field_70161_v) <= (double)RADIUS_SQ;
            return inRange && this.field_145850_b.field_73011_w.getDimension() == entity.field_71093_bK;
        }

        @Override
        protected Block getExpectedBlockType() {
            return WitcheryBlocks.DECURSE_TELEPORT;
        }
    }

    public static class DirectedDecurse
    extends BlockAreaMarker {
        @Override
        protected TileEntityType<? extends TileEntityAreaMarker> getEntity() {
            return WitcheryTileEntities.DIRECTED_DECURSE;
        }
    }

    public static class TeleportDecurse
    extends BlockAreaMarker {
        @Override
        protected TileEntityType<? extends TileEntityAreaMarker> getEntity() {
            return WitcheryTileEntities.TELEPORT_DECURSE;
        }
    }

    public static class TileEntityAreaCurseProtect
    extends TileEntityAreaMarker {
        @Override
        public boolean activateBlock() {
            return false;
        }

        @Override
        protected boolean isProtected(boolean killer, RiteEffect ritual) {
            return !killer && (ritual == null || ritual instanceof RiteEffectCurseCreature);
        }

        @Override
        public boolean isNear(EntityLivingBase entity) {
            int r = WitcheryConfigOptions.decurseDirectedRadius;
            int rSq = r * r;
            boolean inRange = this.func_174877_v().func_177954_c(entity.field_70165_t, (double)this.func_174877_v().func_177956_o(), entity.field_70161_v) <= (double)rSq;
            return inRange && this.field_145850_b.field_73011_w.getDimension() == entity.field_71093_bK;
        }

        @Override
        protected Block getExpectedBlockType() {
            return WitcheryBlocks.DECURSE_DIRECTED;
        }
    }
}

