/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityBarrier;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import org.jetbrains.annotations.Nullable;

public class BlockBarrier
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);

    public BlockBarrier() {
        super(Material.field_151592_s);
        this.func_149722_s();
        this.func_149752_b(1000.0f);
        this.func_149713_g(0);
    }

    public static void setBlock(World world, BlockPos pos, int ticksUntilExpiration, boolean blocksPlayers, EntityPlayer owner) {
        BlockBarrier.setBlock(world, pos, ticksUntilExpiration, blocksPlayers, owner, false);
    }

    public static void setBlock(World world, BlockPos pos, int ticksUntilExpiration, boolean blocksPlayers, EntityPlayer owner, boolean skipCreate) {
        TileEntityBarrier entity;
        if (!skipCreate) {
            world.func_180501_a(pos, WitcheryBlocks.BARRIER.func_176223_P(), 3);
        }
        if ((entity = WitcheryTileEntities.BARRIER.getAt((IBlockAccess)world, pos)) != null) {
            entity.setTicksUntilExpiration(ticksUntilExpiration);
            entity.setBlocksPlayers(blocksPlayers);
            entity.setOwner(owner);
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        TileEntityBarrier tileEntity;
        if (world instanceof World && (tileEntity = WitcheryTileEntities.BARRIER.getAt(world, pos)) != null) {
            List players = ((World)world).func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos, pos.func_177963_a(1.0, 0.9, 1.0)));
            for (EntityPlayer player : players) {
                if (player == null || tileEntity.getBlocksPlayers() && (!player.field_71075_bZ.field_75098_d || !player.func_70093_af()) && !tileEntity.isOwner(player)) continue;
                return field_185506_k;
            }
        }
        return AABB;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.BARRIER.create();
    }
}

