/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityBeartrap;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.CreatureUtil;

public class BlockBeartrap
extends BlockContainer {
    public static final PropertyBool CLOSED = PropertyBool.func_177716_a((String)"closed");
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177708_a((String)"axis", EnumFacing.Axis.class, axis -> axis != EnumFacing.Axis.Y);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.19999998807907104, (double)0.01f, 0.19999998807907104, (double)0.8f, (double)0.1f, (double)0.8f);
    private final boolean silvered;

    public BlockBeartrap(boolean silvered) {
        super(Material.field_151573_f);
        this.silvered = silvered;
        this.func_149647_a(WitcheryGeneralItems.TAB);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(false)).func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
    }

    public static boolean checkForHiddenTrap(EntityPlayer player, RayTraceResult mop) {
        TileEntityBeartrap tile;
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && player.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c() == WitcheryBlocks.BEARTRAP && (tile = WitcheryTileEntities.BEARTRAP.getAt((IBlockAccess)player.field_70170_p, mop.func_178782_a())) != null) {
            return tile.invisibleTo(player);
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public TileEntity func_149915_a(World world, int metadata2) {
        return WitcheryTileEntities.BEARTRAP.create().setSilvered(this.silvered);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        if (rot.ordinal() % 2 == 1) {
            return state.func_177226_a(AXIS, (Comparable)(state.func_177229_b(AXIS) == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.Y));
        }
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((meta & 1) == 0 ? EnumFacing.Axis.X : EnumFacing.Axis.Z)).func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf((meta & 2) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (state.func_177229_b(AXIS) == EnumFacing.Axis.X ? 0 : 1) | ((Boolean)state.func_177229_b((IProperty)CLOSED) != false ? 2 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{AXIS, CLOSED}).build();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)placer.func_174811_aO().func_176740_k());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a(AXIS, (Comparable)entity.func_174811_aO().func_176740_k()));
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            TileEntityBeartrap tile = WitcheryTileEntities.BEARTRAP.getAt((IBlockAccess)world, pos);
            if (tile != null) {
                tile.owner = player.func_146103_bH();
                tile.notifyBlockUpdate(false);
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.silvered) {
            return;
        }
        super.getDrops(drops, world, pos, state, fortune);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase) {
            EntityLivingBase living2 = (EntityLivingBase)entity;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            TileEntityBeartrap tile = WitcheryTileEntities.BEARTRAP.getAt((IBlockAccess)world, pos);
            if (!(tile == null || ((Boolean)state.func_177229_b((IProperty)CLOSED)).booleanValue() || world.func_82737_E() <= tile.setTime + 20L || this.silvered && !CreatureUtil.isWerewolf(entity, false) || this.silvered && !tile.tryTrapWolf(living2))) {
                boolean isCreative;
                boolean bl = isCreative = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d;
                if (!isCreative) {
                    living2.func_70690_d(new PotionEffect(WitcheryPotionEffects.PARALYSED, 600, 2, true, true));
                }
                living2.func_70097_a(DamageSource.field_82728_o, 4.0f);
                world.func_184133_a(null, pos, WitcherySounds.BLOCK_BEARTRAP_MANTRAP, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.25f, 0.5f, EnumParticleTypes.REDSTONE), world, pos);
                world.func_175656_a(pos, state.func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(true)));
                tile.setTime = world.func_82737_E();
                tile.notifyBlockUpdate(true);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityBeartrap tile;
        if (!world.field_72995_K && (tile = WitcheryTileEntities.BEARTRAP.getAt((IBlockAccess)world, pos)) != null) {
            world.func_184133_a(null, player.func_180425_c(), WitcherySounds.BLOCK_BEARTRAP_CLICK, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            boolean closed = (Boolean)state.func_177229_b((IProperty)CLOSED) == false;
            world.func_175656_a(pos, state.func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(closed)));
            if (closed) {
                tile.setTime = world.func_82737_E();
            }
        }
        return true;
    }
}

