/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityBloodCrucible;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.transformation.VampireCreatureTrait;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockBloodCrucible
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, (double)0.31f, 0.75);

    public BlockBloodCrucible() {
        super(Material.field_151576_e);
        this.func_149647_a(WitcheryGeneralItems.TAB);
        this.func_149752_b(1000.0f);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            TileEntityBloodCrucible crucible = WitcheryTileEntities.BLOOD_CRUCIBLE.getAt((IBlockAccess)world, pos);
            if (crucible != null && world instanceof WorldServer) {
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                ItemStack stack = player.func_184586_b(hand);
                VampireCreatureTrait transformation = playerEx.getTransformation(WitcheryCreatureTraits.VAMPIRE);
                if (transformation.getLevel() >= 10 && (crucible.isFull() || player.field_71075_bZ.field_75098_d) && !stack.func_190926_b()) {
                    boolean success = false;
                    if (stack.func_77973_b() == WitcheryIngredientItems.ARTICHOKE) {
                        transformation.setUltimatePower(VampireCreatureTrait.Ultimate.STORM);
                        transformation.setCharges(5);
                        playerEx.markChanged();
                        success = true;
                    } else if (stack.func_77973_b() == WitcheryIngredientItems.BAT_WOOL) {
                        transformation.setUltimatePower(VampireCreatureTrait.Ultimate.SWARM);
                        transformation.setCharges(5);
                        playerEx.markChanged();
                        success = true;
                    } else if (stack.func_77973_b() == Items.field_151103_aS) {
                        transformation.setUltimatePower(VampireCreatureTrait.Ultimate.FARM);
                        transformation.setCharges(5);
                        playerEx.markChanged();
                        success = true;
                    }
                    if (success) {
                        crucible.drainAll();
                        stack.func_190918_g(1);
                        world.func_184148_a(null, 0.5 + (double)x, (double)y, 0.5 + (double)z, SoundEvents.field_187646_bt, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, (double)y, 0.5 + (double)z, 0.5f, 0.5f, EnumParticleTypes.REDSTONE), world, 0.5 + (double)x, y, 0.5 + (double)z);
                    } else {
                        world.func_184148_a(null, 0.5 + (double)x, (double)y, 0.5 + (double)z, SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, (double)y, 0.5 + (double)z, 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), world, 0.5 + (double)x, y, 0.5 + (double)z);
                    }
                } else {
                    world.func_184148_a(null, 0.5 + (double)x, (double)y, 0.5 + (double)z, SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, (double)y, 0.5 + (double)z, 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), world, 0.5 + (double)x, y, 0.5 + (double)z);
                }
            }
            return true;
        }
        return true;
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.BLOOD_CRUCIBLE.create();
    }
}

