/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.TuplesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.block.entity.TileEntityGrassper;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.resources.RiteManager;
import net.msrandom.witchery.rite.Rite;
import net.msrandom.witchery.rite.RitualCircle;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockCircle
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.015625, 1.0);

    public BlockCircle() {
        super(Material.field_151582_l);
        this.func_149711_c(3.0f);
        this.func_149752_b(1000.0f);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemstack;
        if (!(world.field_72995_K || (itemstack = player.func_184586_b(player.func_184600_cs())).func_190926_b() || itemstack.func_77973_b() != WitcheryIngredientItems.BROOM && itemstack.func_77973_b() != WitcheryIngredientItems.ENCHANTED_BROOM)) {
            world.func_175655_b(pos, false);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.canPlace(worldIn, pos)) {
            boolean flag = worldIn.func_175640_z(pos);
            TileEntityCircle tileCircle = WitcheryTileEntities.CIRCLE.getAt((IBlockAccess)worldIn, pos);
            if (tileCircle != null && tileCircle.previousRedstoneState != flag) {
                if (flag) {
                    this.activateBlock(worldIn, pos, null, false);
                }
                tileCircle.previousRedstoneState = flag;
            }
        }
    }

    private boolean canPlace(World par1World, BlockPos pos) {
        if (!this.func_176196_c(par1World, pos)) {
            par1World.func_175698_g(pos);
            return false;
        }
        return true;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        IBlockState lower = world.func_180495_p(down);
        Material material = lower.func_185904_a();
        return !WitcheryUtils.isAir(lower, (IBlockAccess)world, down) && material.func_76218_k() && material.func_76220_a();
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCircle && ((TileEntityCircle)tile).active) {
            double d0 = (float)pos.func_177958_n() + 0.4f + rand.nextFloat() * 0.2f;
            double d2 = (float)pos.func_177956_o() + 0.1f + rand.nextFloat() * 0.3f;
            double d3 = (float)pos.func_177952_p() + 0.4f + rand.nextFloat() * 0.2f;
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean summonCoven;
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = summonCoven = stack.func_77973_b() == WitcheryIngredientItems.SEER_STONE;
        if (!stack.func_190926_b() && !summonCoven) {
            return false;
        }
        this.activateBlock(world, pos, player, summonCoven);
        return true;
    }

    private void activateBlock(World world, BlockPos pos, EntityPlayer player, boolean summonCoven) {
        TileEntityCircle tileEntity = WitcheryTileEntities.CIRCLE.getAt((IBlockAccess)world, pos);
        if (tileEntity == null) {
            return;
        }
        if (tileEntity.isRitualActive()) {
            tileEntity.deactivate();
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (PowerSources.instance().isAreaNullified(pos) || WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world)) {
            player.func_145747_a(new TextComponentTranslation("rite.witchery.area_nullified", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            return;
        }
        boolean ritualFound = false;
        int covenSize = summonCoven ? WitcheryUtils.getExtension((EntityPlayer)player).coven.size() : 0;
        HashSet<ItemStack> grassperStacks = new HashSet<ItemStack>();
        int radius = 5;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ItemStack stack;
                TileEntityGrassper grassper;
                BlockPos p = pos.func_177982_a(x, 0, z);
                if (world.func_180495_p(p).func_177230_c() != WitcheryBlocks.GRASSPER || (grassper = WitcheryTileEntities.GRASSPER.getAt((IBlockAccess)world, p)) == null || (stack = grassper.func_70301_a(0)).func_190926_b()) continue;
                grassperStacks.add(stack);
            }
        }
        HashSet<Entity> entities = new HashSet<Entity>();
        HashSet<RitualCircle> circlesFound = new HashSet<RitualCircle>();
        AtomicInteger biggestSearchedSize = new AtomicInteger();
        AtomicReference<AxisAlignedBB> bounds = new AtomicReference<AxisAlignedBB>();
        TreeSet<Rite.PotentialAttemptMatch> potentialMatches = new TreeSet<Rite.PotentialAttemptMatch>();
        for (Rite rite : RiteManager.INSTANCE.getRites()) {
            if (!rite.isMatch(world, pos, circlesFound, biggestSearchedSize, bounds, entities, grassperStacks, potentialMatches)) continue;
            tileEntity.queueRitual(rite, null, bounds.get(), circlesFound, player, covenSize, summonCoven);
            summonCoven = false;
            ritualFound = true;
        }
        if (!ritualFound) {
            if (!potentialMatches.isEmpty()) {
                Rite.PotentialAttemptMatch match2 = (Rite.PotentialAttemptMatch)potentialMatches.first();
                tileEntity.queueRitual(match2.getRite(), TuplesKt.to(match2.getFailure(), match2.getSacrificeIndex()), bounds.get(), circlesFound, player, covenSize, summonCoven);
            } else if (player != null) {
                RiteEffect.error("unknown_rite", player);
                WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.CIRCLE.create();
    }
}

