/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class BlockCircleGlyph
extends Block {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyEnum<Type> GLYPH = PropertyEnum.func_177709_a((String)"glyph", Type.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.015625, 1.0);
    private final TextFormatting textFormatting;
    private final EnumParticleTypes particles;

    public BlockCircleGlyph() {
        this(null, null);
    }

    public BlockCircleGlyph(TextFormatting textFormatting, EnumParticleTypes particles) {
        super(Material.field_151582_l);
        this.textFormatting = textFormatting;
        this.particles = particles;
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a(GLYPH, (Comparable)((Object)Type.KA)));
        this.func_149752_b(1000.0f);
        this.func_149711_c(2.0f);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemstack;
        if (!(world.field_72995_K || (itemstack = player.func_184614_ca()).func_190926_b() || itemstack.func_77973_b() != WitcheryIngredientItems.BROOM && itemstack.func_77973_b() != WitcheryIngredientItems.ENCHANTED_BROOM)) {
            world.func_175655_b(pos, false);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.particles != null && !((Boolean)stateIn.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            double d0 = (float)x + 0.4f + rand.nextFloat() * 0.2f;
            double d2 = (float)y + 0.1f + rand.nextFloat() * 0.3f;
            double d3 = (float)z + 0.4f + rand.nextFloat() * 0.2f;
            world.func_175688_a(this.particles, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            world.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Material material = world.func_180495_p(pos).func_185904_a();
        Material materialBelow = world.func_180495_p(pos.func_177977_b()).func_185904_a();
        return materialBelow.func_76218_k() && materialBelow.func_76220_a() && !material.func_76218_k() && !material.func_76220_a();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(GLYPH, (Comparable)((Object)Type.VALUES[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(GLYPH))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{ACTIVE, GLYPH}).build();
    }

    public TextFormatting getTextFormatting() {
        return this.textFormatting;
    }

    public static enum Type implements IStringSerializable
    {
        KA,
        GO,
        SA,
        ZA,
        TA,
        DO,
        NI,
        HI,
        BO,
        PO,
        MA,
        RI;

        private static final Type[] VALUES;

        public static Type getForPlacement(Random random) {
            return VALUES[random.nextInt(VALUES.length)];
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = Type.values();
        }
    }
}

