/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.msrandom.witchery.block.BlockCoffin$WhenMappings;
import net.msrandom.witchery.block.entity.TileEntityCoffin;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 72\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J \u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016JP\u0010#\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0016H\u0016J(\u0010,\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u0016H\u0016J\u0018\u0010/\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00100\u001a\u00020\"H\u0016J*\u00101\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010$2\u0006\u00102\u001a\u00020 H\u0016J(\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00106\u001a\u00020(H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00068"}, d2={"Lnet/msrandom/witchery/block/BlockCoffin;", "Lnet/minecraft/block/BlockBed;", "color", "Lnet/minecraft/item/EnumDyeColor;", "(Lnet/minecraft/item/EnumDyeColor;)V", "getColor", "()Lnet/minecraft/item/EnumDyeColor;", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "createNewTileEntity", "Lnet/msrandom/witchery/block/entity/TileEntityCoffin;", "worldIn", "Lnet/minecraft/world/World;", "meta", "", "dropBlockAsItemWithChance", "", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "chance", "", "fortune", "getActualState", "world", "Lnet/minecraft/world/IBlockAccess;", "getItem", "Lnet/minecraft/item/ItemStack;", "getMetaFromState", "getStateFromMeta", "isBed", "", "player", "Lnet/minecraft/entity/Entity;", "onBlockActivated", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "hitY", "hitZ", "onFallenUpon", "entity", "fallDistance", "onLanded", "entityIn", "setBedOccupied", "occupied", "shouldSideBeRendered", "blockState", "blockAccess", "side", "Companion", "WitcheryResurrected"})
public final class BlockCoffin
extends BlockBed {
    @NotNull
    private final EnumDyeColor color;
    @JvmField
    @NotNull
    public static final PropertyBool OPEN;
    public static final Companion Companion;

    public boolean isBed(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @Nullable Entity player) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos headPos;
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        Intrinsics.checkParameterIsNotNull(facing, "facing");
        BlockPos footPos = headPos = pos;
        if (world.field_72995_K) {
            return true;
        }
        if ((BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT) {
            BlockPos blockPos = headPos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockBed.field_185512_D));
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "headPos.offset(state.getValue(FACING))");
            headPos = blockPos;
            IBlockState iBlockState = world.func_180495_p(footPos);
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(footPos)");
            if (iBlockState.func_177230_c() != this) {
                return true;
            }
        } else {
            Comparable comparable = state.func_177229_b((IProperty)BlockBed.field_185512_D);
            Intrinsics.checkExpressionValueIsNotNull(comparable, "state.getValue(FACING)");
            BlockPos blockPos = footPos.func_177972_a(((EnumFacing)comparable).func_176734_d());
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "footPos.offset(state.getValue(FACING).opposite)");
            footPos = blockPos;
        }
        IBlockState headState = world.func_180495_p(headPos);
        IBlockState footState = world.func_180495_p(footPos);
        if (player.func_70093_af()) {
            Comparable comparable = footState.func_177229_b((IProperty)OPEN);
            Intrinsics.checkExpressionValueIsNotNull(comparable, "footState.getValue(OPEN)");
            if (((Boolean)comparable).booleanValue()) {
                Comparable comparable2 = headState.func_177229_b((IProperty)BlockBed.field_176471_b);
                Intrinsics.checkExpressionValueIsNotNull(comparable2, "headState.getValue(OCCUPIED)");
                if (((Boolean)comparable2).booleanValue()) {
                    EntityPlayer sleepingPlayer = null;
                    Iterator iterator2 = world.field_73010_i.iterator();
                    while (iterator2.hasNext()) {
                        BlockPos bedLocation;
                        EntityPlayer worldPlayer;
                        EntityPlayer entityPlayer = worldPlayer = (EntityPlayer)iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "worldPlayer");
                        if (!entityPlayer.func_70608_bn() || Intrinsics.areEqual(bedLocation = worldPlayer.field_71081_bT, headPos) ^ true) continue;
                        sleepingPlayer = worldPlayer;
                    }
                    if (sleepingPlayer != null) {
                        return true;
                    }
                }
            }
            if (world.isSideSolid(headPos.func_177984_a(), EnumFacing.DOWN)) return true;
            if (world.isSideSolid(new BlockPos(footPos.func_177958_n(), headPos.func_177956_o() + 1, footPos.func_177952_p()), EnumFacing.DOWN)) {
                return true;
            }
            world.func_175656_a(footPos, footState.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((Boolean)footState.func_177229_b((IProperty)OPEN) == false)));
            return true;
        }
        if (!((Boolean)footState.func_177229_b((IProperty)OPEN)).booleanValue()) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.witchery.coffin.closed", new Object[0]), true);
            return true;
        }
        WorldProvider.WorldSleepResult sleepResult = world.field_73011_w.canSleepAt(player, headPos);
        if (sleepResult == WorldProvider.WorldSleepResult.BED_EXPLODES) {
            world.func_175698_g(headPos);
            EnumFacing k1 = (EnumFacing)footState.func_177229_b((IProperty)BlockBed.field_185512_D);
            BlockPos blockPos = headPos.func_177972_a(k1);
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "headPos.offset(k1)");
            headPos = blockPos;
            IBlockState iBlockState = world.func_180495_p(headPos);
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(headPos)");
            if (iBlockState.func_177230_c() == this) {
                world.func_175698_g(headPos);
            }
        } else {
            if (sleepResult == WorldProvider.WorldSleepResult.DENY) {
                return true;
            }
            Comparable comparable = footState.func_177229_b((IProperty)BlockBed.field_176471_b);
            Intrinsics.checkExpressionValueIsNotNull(comparable, "footState.getValue(OCCUPIED)");
            if (((Boolean)comparable).booleanValue()) {
                EntityPlayer sleepingPlayer = null;
                Iterator iterator3 = world.field_73010_i.iterator();
                while (iterator3.hasNext()) {
                    BlockPos bedLocation;
                    EntityPlayer worldPlayer;
                    EntityPlayer entityPlayer = worldPlayer = (EntityPlayer)iterator3.next();
                    Intrinsics.checkExpressionValueIsNotNull(entityPlayer, "worldPlayer");
                    if (!entityPlayer.func_70608_bn() || Intrinsics.areEqual(bedLocation = worldPlayer.field_71081_bT, headPos) ^ true) continue;
                    sleepingPlayer = worldPlayer;
                }
                if (sleepingPlayer != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]), true);
                    return true;
                }
                this.setBedOccupied((IBlockAccess)world, headPos, player, false);
            }
            EntityPlayer.SleepResult sleepResult2 = player.func_180469_a(headPos);
            if (sleepResult2 == null) return true;
            switch (BlockCoffin$WhenMappings.$EnumSwitchMapping$0[sleepResult2.ordinal()]) {
                case 1: {
                    this.setBedOccupied((IBlockAccess)world, headPos, player, true);
                    return true;
                }
                case 2: {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(WitcheryUtils.getExtension(player).isTransformation(WitcheryCreatureTraits.VAMPIRE) ? "tile.witchery.coffin.night_time" : "tile.bed.noSleep", new Object[0]), true);
                    return true;
                }
                case 3: {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
                    return true;
                }
                case 4: {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.witchery.coffin.tooFarAway", new Object[0]), true);
                    return true;
                }
                default: {
                    return true;
                }
            }
        }
        world.func_72885_a(null, (double)headPos.func_177958_n() + 0.5, (double)headPos.func_177956_o() + 0.5, (double)headPos.func_177952_p() + 0.5, 5.0f, true, true);
        return true;
    }

    public void setBedOccupied(@NotNull IBlockAccess world, @NotNull BlockPos pos, @Nullable EntityPlayer player, boolean occupied) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        if (world instanceof World) {
            TileEntity entity = world.func_175625_s(pos);
            super.setBedOccupied(world, pos, player, occupied);
            ((World)world).func_175690_a(pos, entity);
        }
    }

    public void func_180658_a(@NotNull World world, @NotNull BlockPos pos, @NotNull Entity entity, float fallDistance) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        Comparable comparable = world.func_180495_p(pos).func_177229_b((IProperty)OPEN);
        Intrinsics.checkExpressionValueIsNotNull(comparable, "world.getBlockState(pos).getValue(OPEN)");
        super.func_180658_a(world, pos, entity, (Boolean)comparable != false ? fallDistance : fallDistance * (float)2);
    }

    public void func_176216_a(@NotNull World worldIn, @NotNull Entity entityIn) {
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Intrinsics.checkParameterIsNotNull(entityIn, "entityIn");
        entityIn.field_70181_x = 0.0;
    }

    public void func_180653_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, float chance, int fortune) {
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            NonNullList drops = NonNullList.func_191196_a();
            this.getDrops(drops, (IBlockAccess)worldIn, pos, state, fortune);
            float dropChance = ForgeEventFactory.fireBlockHarvesting((List)((List)drops), (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(worldIn.field_73012_v.nextFloat() <= dropChance)) continue;
                BlockBed.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    @NotNull
    public ItemStack func_185473_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        return new ItemStack((Block)this);
    }

    @Nullable
    public TileEntityCoffin createNewTileEntity(@NotNull World worldIn, int meta) {
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        return WitcheryTileEntities.COFFIN.create();
    }

    @NotNull
    public IBlockState func_176221_a(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        IBlockState actualState = super.func_176221_a(state, world, pos);
        if ((BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD) {
            IBlockState footState;
            Comparable comparable = state.func_177229_b((IProperty)BlockBed.field_185512_D);
            Intrinsics.checkExpressionValueIsNotNull(comparable, "state.getValue(FACING)");
            IBlockState iBlockState = footState = world.func_180495_p(pos.func_177972_a(((EnumFacing)comparable).func_176734_d()));
            Intrinsics.checkExpressionValueIsNotNull(iBlockState, "footState");
            if (iBlockState.func_177230_c() == this) {
                actualState = state.func_177226_a((IProperty)OPEN, footState.func_177229_b((IProperty)OPEN));
            }
        }
        IBlockState iBlockState = actualState;
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "actualState");
        return iBlockState;
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        BlockStateContainer blockStateContainer = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{(IProperty)BlockBed.field_185512_D, (IProperty)BlockBed.field_176472_a, (IProperty)BlockBed.field_176471_b, (IProperty)OPEN}).build();
        Intrinsics.checkExpressionValueIsNotNull(blockStateContainer, "BlockStateContainer.Buil\u2026, OCCUPIED, OPEN).build()");
        return blockStateContainer;
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        IBlockState iBlockState;
        IBlockState state = super.func_176203_a(meta);
        if ((BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT) {
            IBlockState iBlockState2 = state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) != 0));
            iBlockState = iBlockState2;
            Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "state.withProperty(OPEN, meta and 4 != 0)");
        } else {
            IBlockState iBlockState3 = state;
            iBlockState = iBlockState3;
            Intrinsics.checkExpressionValueIsNotNull(iBlockState3, "state");
        }
        return iBlockState;
    }

    public int func_176201_c(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        int i = super.func_176201_c(state);
        if ((BlockBed.EnumPartType)state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT) {
            Comparable comparable = state.func_177229_b((IProperty)OPEN);
            Intrinsics.checkExpressionValueIsNotNull(comparable, "state.getValue(OPEN)");
            if (((Boolean)comparable).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    public boolean func_176225_a(@NotNull IBlockState blockState, @NotNull IBlockAccess blockAccess, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull(blockState, "blockState");
        Intrinsics.checkParameterIsNotNull(blockAccess, "blockAccess");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(side, "side");
        return true;
    }

    @NotNull
    public final EnumDyeColor getColor() {
        return this.color;
    }

    public BlockCoffin(@NotNull EnumDyeColor color2) {
        Intrinsics.checkParameterIsNotNull(color2, "color");
        this.color = color2;
        BlockStateContainer blockStateContainer = this.field_176227_L;
        Intrinsics.checkExpressionValueIsNotNull(blockStateContainer, "blockState");
        this.func_180632_j(blockStateContainer.func_177621_b().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT).func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(1.0f);
        this.func_149649_H();
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    static {
        Companion = new Companion(null);
        PropertyBool propertyBool = PropertyBool.func_177716_a((String)"open");
        Intrinsics.checkExpressionValueIsNotNull(propertyBool, "PropertyBool.create(\"open\")");
        OPEN = propertyBool;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/msrandom/witchery/block/BlockCoffin$Companion;", "", "()V", "OPEN", "Lnet/minecraft/block/properties/PropertyBool;", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

