/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCrystalBall;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.prediction.Prediction;
import org.jetbrains.annotations.Nullable;

public class BlockCrystalBall
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);
    private static final float ALTAR_POWER_PER_READING = 500.0f;

    public BlockCrystalBall() {
        super(Material.field_151574_g);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    public static boolean tryConsumePower(World world, EntityPlayer player, BlockPos pos) {
        IPowerSource powerSource = BlockCrystalBall.findNewPowerSource(world, pos);
        if (powerSource != null && powerSource.consumePower(500.0f)) {
            return true;
        }
        if (!world.field_72995_K) {
            player.func_145747_a(new TextComponentTranslation("prediction.witchery.no_altar_power", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
        return false;
    }

    private static IPowerSource findNewPowerSource(World world, BlockPos pos) {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityCrystalBall ball = WitcheryTileEntities.CRYSTAL_BALL.getAt((IBlockAccess)world, pos);
            if (ball != null) {
                if (ball.canBeUsed()) {
                    int x = pos.func_177958_n();
                    int y = pos.func_177956_o();
                    int z = pos.func_177952_p();
                    if (BlockCrystalBall.tryConsumePower(world, player, pos)) {
                        AxisAlignedBB bounds = new AxisAlignedBB(0.5 + (double)x - 5.0, 0.5 + (double)y - 2.0, 0.5 + (double)z - 5.0, 0.5 + (double)x + 5.0, 0.5 + (double)y + 2.0, 0.5 + (double)z + 5.0);
                        List players = world.func_72872_a(EntityPlayer.class, bounds);
                        EntityPlayer victim = player;
                        double closest = 10000.0;
                        for (EntityPlayer nearbyPlayer : players) {
                            double distSq;
                            if (nearbyPlayer == null || nearbyPlayer == player || !((distSq = player.func_70092_e(0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z)) < closest)) continue;
                            victim = nearbyPlayer;
                            closest = distSq;
                        }
                        Prediction.makePrediction(victim, player, true);
                        ball.onUsed();
                        world.func_184148_a(null, 0.5 + (double)x, 0.2 + (double)y, 0.5 + (double)z, SoundEvents.field_187802_ec, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, 0.2 + (double)y, 0.5 + (double)z, 0.2f, 0.2f, EnumParticleTypes.EXPLOSION_NORMAL), world, 0.5 + (double)x, 0.2 + (double)y, 0.5 + (double)z);
                    }
                } else {
                    player.func_145747_a(new TextComponentTranslation("prediction.witchery.recharging", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
            }
            return true;
        }
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Material material = world.func_180495_p(pos.func_177977_b()).func_185904_a();
        return !world.func_175623_d(pos.func_177977_b()) && material.func_76218_k() && material.func_76220_a();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.CRYSTAL_BALL.create();
    }
}

