/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityDistillery;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryContainers;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class BlockDistillery
extends BlockContainer {
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static boolean keepFurnaceInventory;
    private final boolean isActive;

    public BlockDistillery(boolean burning) {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(WitcheryGeneralItems.TAB);
        this.isActive = burning;
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185852_e);
        if (burning) {
            this.func_149715_a(0.4f);
        }
    }

    public static void updateDistilleryBlockState(boolean burning, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntityDistillery tileentity = WitcheryTileEntities.DISTILLERY.getAt((IBlockAccess)world, pos);
        keepFurnaceInventory = true;
        if (burning) {
            world.func_175656_a(pos, WitcheryBlocks.DISTILLERY_BURNING.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
        } else {
            world.func_175656_a(pos, WitcheryBlocks.DISTILLERY.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
        }
        keepFurnaceInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_175690_a(pos, (TileEntity)tileentity);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)WitcheryBlocks.DISTILLERY);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityDistillery tile = WitcheryTileEntities.DISTILLERY.getAt((IBlockAccess)world, pos);
        if (tile != null) {
            WitcheryUtils.openContainer(WitcheryContainers.getDistillery(), player, pos, tile.func_145748_c_());
        }
        return true;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.isActive) {
            double d0 = (float)pos.func_177958_n() + 0.4f + rand.nextFloat() * 0.2f;
            double d2 = (float)pos.func_177956_o() + 1.0f + rand.nextFloat() * 0.3f;
            double d3 = (float)pos.func_177952_p() + 0.4f + rand.nextFloat() * 0.2f;
            worldIn.func_175688_a(EnumParticleTypes.SPELL_INSTANT, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityDistillery tile;
        if (!keepFurnaceInventory && (tile = WitcheryTileEntities.DISTILLERY.getAt((IBlockAccess)worldIn, pos)) != null) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tile);
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)WitcheryTileEntities.DISTILLERY.getAt((IBlockAccess)world, pos)));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)WitcheryBlocks.DISTILLERY);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.DISTILLERY.create();
    }
}

