/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockBramble;
import net.msrandom.witchery.util.TeleportationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0019"}, d2={"Lnet/msrandom/witchery/block/BlockEnderBramble;", "Lnet/msrandom/witchery/block/BlockBramble;", "()V", "harvestBlock", "", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "te", "Lnet/minecraft/tileentity/TileEntity;", "stack", "Lnet/minecraft/item/ItemStack;", "onEntityCollision", "entity", "Lnet/minecraft/entity/Entity;", "randomDisplayTick", "stateIn", "rand", "Ljava/util/Random;", "spreadToIfEmpty", "WitcheryResurrected"})
public final class BlockEnderBramble
extends BlockBramble {
    private final void spreadToIfEmpty(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockPos y = pos.func_177977_b();
            while (true) {
                BlockPos blockPos = y;
                Intrinsics.checkExpressionValueIsNotNull(blockPos, "y");
                if (blockPos.func_177956_o() > pos.func_177956_o() + 1) break;
                IBlockState iBlockState = world.func_180495_p(y);
                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(y)");
                Block block = iBlockState.func_177230_c();
                if (block == Blocks.field_150433_aE || block == Blocks.field_150329_H || block == Blocks.field_150350_a) {
                    IBlockState iBlockState2 = world.func_180495_p(y.func_177977_b());
                    Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "world.getBlockState(y.down())");
                    Block belowBlock = iBlockState2.func_177230_c();
                    if (belowBlock != Blocks.field_150350_a && world.field_73012_v.nextBoolean()) {
                        world.func_180501_a(y, this.func_176223_P(), 3);
                        if (world.field_73012_v.nextInt(3) != 0) break;
                    }
                }
                y = y.func_177984_a();
            }
        }
    }

    public void func_180657_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull BlockPos pos, @NotNull IBlockState state, @Nullable TileEntity te, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K && (stack.func_190926_b() || stack.func_77973_b() != Items.field_151006_E)) {
            BlockPos blockPos = pos.func_177974_f();
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "pos.east()");
            this.spreadToIfEmpty(world, blockPos);
            BlockPos blockPos2 = pos.func_177968_d();
            Intrinsics.checkExpressionValueIsNotNull(blockPos2, "pos.south()");
            this.spreadToIfEmpty(world, blockPos2);
            BlockPos blockPos3 = pos.func_177976_e();
            Intrinsics.checkExpressionValueIsNotNull(blockPos3, "pos.west()");
            this.spreadToIfEmpty(world, blockPos3);
            BlockPos blockPos4 = pos.func_177978_c();
            Intrinsics.checkExpressionValueIsNotNull(blockPos4, "pos.north()");
            this.spreadToIfEmpty(world, blockPos4);
            BlockPos blockPos5 = pos.func_177982_a(1, 0, 1);
            Intrinsics.checkExpressionValueIsNotNull(blockPos5, "pos.add(1, 0, 1)");
            this.spreadToIfEmpty(world, blockPos5);
            BlockPos blockPos6 = pos.func_177982_a(-1, 0, -1);
            Intrinsics.checkExpressionValueIsNotNull(blockPos6, "pos.add(-1, 0, -1)");
            this.spreadToIfEmpty(world, blockPos6);
            BlockPos blockPos7 = pos.func_177982_a(-1, 0, 1);
            Intrinsics.checkExpressionValueIsNotNull(blockPos7, "pos.add(-1, 0, 1)");
            this.spreadToIfEmpty(world, blockPos7);
            BlockPos blockPos8 = pos.func_177982_a(1, 0, -1);
            Intrinsics.checkExpressionValueIsNotNull(blockPos8, "pos.add(1, 0, -1)");
            this.spreadToIfEmpty(world, blockPos8);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nullable IBlockState stateIn, @NotNull World world, @NotNull BlockPos pos, @NotNull Random rand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(rand, "rand");
        if (rand.nextBoolean()) {
            double d0 = (double)pos.func_177958_n() + (double)rand.nextFloat();
            double d2 = (double)((float)pos.func_177956_o() + 0.15f + rand.nextFloat() * 0.3f) + 0.5;
            double d3 = (double)pos.func_177952_p() + (double)rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.PORTAL, d0, d2, d3, 0.0, -1.2, 0.0, new int[0]);
        }
    }

    @Override
    public void func_180634_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        if (!world.field_72995_K && entity instanceof EntityLivingBase) {
            BlockPos p;
            int distance = 500;
            int doubleDistance = 1000;
            BlockPos blockPos = p = pos.func_177982_a(world.field_73012_v.nextInt(doubleDistance) - distance, 0, world.field_73012_v.nextInt(doubleDistance) - distance);
            Intrinsics.checkExpressionValueIsNotNull(blockPos, "p");
            int maxY = RangesKt.coerceAtMost(blockPos.func_177956_o() + 64, 250);
            while (true) {
                IBlockState iBlockState = world.func_180495_p(p);
                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(p)");
                Material material = iBlockState.func_185904_a();
                Intrinsics.checkExpressionValueIsNotNull(material, "world.getBlockState(p).material");
                if (material.func_76220_a()) break;
                BlockPos blockPos2 = p;
                Intrinsics.checkExpressionValueIsNotNull(blockPos2, "p");
                if (blockPos2.func_177956_o() < 0) break;
                p = p.func_177977_b();
            }
            while (true) {
                IBlockState iBlockState = world.func_180495_p(p);
                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "world.getBlockState(p)");
                Material material = iBlockState.func_185904_a();
                Intrinsics.checkExpressionValueIsNotNull(material, "world.getBlockState(p).material");
                if (material.func_76220_a()) {
                    IBlockState iBlockState2 = world.func_180495_p(p);
                    Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "world.getBlockState(p)");
                    if (iBlockState2.func_177230_c() != Blocks.field_150357_h && world.func_175623_d(p.func_177984_a()) && world.func_175623_d(p.func_177981_b(2)) && world.func_175623_d(p.func_177981_b(3))) break;
                }
                BlockPos blockPos3 = p;
                Intrinsics.checkExpressionValueIsNotNull(blockPos3, "p");
                if (blockPos3.func_177956_o() >= maxY) break;
                p = p.func_177984_a();
            }
            BlockPos blockPos4 = p;
            Intrinsics.checkExpressionValueIsNotNull(blockPos4, "p");
            int n = blockPos4.func_177956_o();
            if (1 <= n && maxY > n) {
                WorldProvider worldProvider = world.field_73011_w;
                Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
                TeleportationUtil.teleportToLocation(p, worldProvider.getDimension(), entity, true);
            }
        }
    }
}

