/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.jvm.functions.Function0;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityFetish;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFetish
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 1.0, (double)0.8f);
    @Nullable
    private final Function0<BlockFetish> spectralVersion;

    public BlockFetish(@Nullable @Nullable Function0<@Nullable BlockFetish> spectralVersion) {
        super(Material.field_151575_d);
        this.spectralVersion = spectralVersion;
        this.func_149647_a(WitcheryGeneralItems.TAB);
        this.func_149752_b(100000.0f);
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public boolean isSpectral() {
        return this.spectralVersion == null;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.isSpectral()) {
            super.func_149666_a(tab, items);
            for (Map.Entry entry2 : InfusedSpiritEffect.REGISTRY) {
                ItemStack stack = new ItemStack((Block)this);
                if (!((InfusedSpiritEffect)entry2.getValue()).bindToItem(stack)) continue;
                items.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag;
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && (tag = WitcheryUtils.getOrCreateTag(stack)).func_74764_b("SpiritEffect")) {
            String[] id = ResourceLocation.func_177516_a((String)tag.func_74779_i("SpiritEffect"));
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)("fetish." + id[0] + "." + id[1]), (Object[])new Object[0]));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        if (this.isSpectral()) {
            return field_185506_k;
        }
        return super.func_180646_a(blockState, world, pos);
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        return this.isSpectral() ? -1.0f : super.func_176195_g(blockState, world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        WorldServer overworld;
        NBTTagCompound tag;
        TileEntityFetish tile;
        if (!stack.func_190926_b() && (tile = WitcheryTileEntities.FETISH.getAt((IBlockAccess)world, pos)) != null && (tag = stack.func_77978_p()) != null) {
            InfusedSpiritEffect effect = (InfusedSpiritEffect)InfusedSpiritEffect.REGISTRY.get(new ResourceLocation(tag.func_74779_i("SpiritEffect")));
            if (tag.func_74764_b("Data")) {
                NBTTagCompound nbtTileData = tag.func_74775_l("Data");
                tile.readSubDataFromNBT(nbtTileData);
            }
            tile.setEffect(effect);
        }
        if (!world.field_72995_K && WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world) && (overworld = player.func_184102_h().func_71218_a(0)).func_175623_d(pos)) {
            BlockFetish spectralBlock;
            BlockFetish blockFetish = spectralBlock = this.spectralVersion == null ? null : this.spectralVersion.invoke();
            if (spectralBlock != null) {
                state = this.getSpectralVersion(state, spectralBlock);
                overworld.func_175656_a(pos, state);
                spectralBlock.func_180633_a((World)overworld, pos, state, player, stack);
            }
        }
    }

    protected IBlockState getSpectralVersion(IBlockState original, @NotNull BlockFetish spectralBlock) {
        return spectralBlock.func_176223_P();
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
        if (!world.field_72995_K && WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world)) {
            WorldServer overworld = player.func_184102_h().func_71218_a(0);
            if (world.func_180495_p(pos).func_177230_c() == this) {
                overworld.func_175698_g(pos);
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityFetish tile = WitcheryTileEntities.FETISH.getAt(world, pos);
        if (tile != null) {
            ItemStack stack = new ItemStack(tile.func_145838_q());
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("BlockColor", (byte)tile.getColor());
            tag.func_74778_a("SpiritEffect", ((ResourceLocation)InfusedSpiritEffect.REGISTRY.getKey(tile.getEffect())).toString());
            NBTTagCompound nbtTileData = new NBTTagCompound();
            tile.writeSubDataToNBT(nbtTileData);
            tag.func_74782_a("Data", (NBTBase)nbtTileData);
            stack.func_77982_d(tag);
            drops.add((Object)stack);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return this.isSpectral() ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    public Item func_180660_a(IBlockState p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        TileEntityFetish tile = WitcheryTileEntities.FETISH.getAt((IBlockAccess)world, pos);
        if (tile != null && player != null && !(stack = player.func_184586_b(hand)).func_190926_b()) {
            if (!this.isSpectral()) {
                if (stack.func_77973_b() == Items.field_151100_aR) {
                    int color2 = EnumDyeColor.func_176766_a((int)stack.func_77952_i()).func_176767_b();
                    tile.setColor(color2);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                        if (stack.func_190926_b()) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        }
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151131_as) {
                    tile.clearBoundEntities(stack, player);
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    return true;
                }
                if (stack.func_77973_b() == WitcheryGeneralItems.BOLINE) {
                    tile.cycleBoundMode(player);
                    return true;
                }
            }
            if (stack.func_77973_b() == WitcheryGeneralItems.BOUND_TAGLOCK_KIT) {
                tile.setBoundEntity(stack, player, this.spectralVersion == null);
                return true;
            }
        }
        return false;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityFetish tile = WitcheryTileEntities.FETISH.getAt(blockAccess, pos);
        if (tile != null) {
            return tile.getPowerLevel();
        }
        return super.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? this.func_180656_a(blockState, blockAccess, pos, side) : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.FETISH.create();
    }
}

