/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.msrandom.witchery.entity.EntityNightmare;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.CreatureUtil;

public class BlockFlowingSpirit
extends BlockFluidClassic {
    protected final boolean nightmareBane;
    protected final boolean igniteSpiritPortals;
    protected final PotionEffect beneficalEffect1;
    protected final PotionEffect harmfulEffect;

    public BlockFlowingSpirit(Fluid fluid, MapColor color2, PotionEffect beneficalEffect1, PotionEffect harmfulEffect, boolean nightmareBane, boolean igniteSpiritPortals) {
        super(fluid, Material.field_151586_h, color2);
        this.quantaPerBlock = 5;
        this.func_149711_c(100.0f);
        this.func_149713_g(3);
        this.beneficalEffect1 = beneficalEffect1;
        this.harmfulEffect = harmfulEffect;
        this.nightmareBane = nightmareBane;
        this.igniteSpiritPortals = igniteSpiritPortals;
    }

    public void func_176213_c(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!(this.igniteSpiritPortals && WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world) && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150433_aE && (Integer)state.func_177229_b((IProperty)LEVEL) == 0 && WitcheryBlocks.SPIRIT_PORTAL.tryToCreatePortal(world, pos))) {
            super.func_176213_c(world, pos, state);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity != null) {
            EntityItem item;
            ItemStack stack;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase livingEntity = (EntityLivingBase)entity;
                if (CreatureUtil.isUndead((Entity)livingEntity) || CreatureUtil.isDemonic((Entity)livingEntity) || this.nightmareBane && livingEntity instanceof EntityNightmare) {
                    if (!livingEntity.func_70644_a(this.harmfulEffect.func_188419_a())) {
                        livingEntity.func_70690_d(new PotionEffect(this.harmfulEffect));
                    }
                } else if (!livingEntity.func_70644_a(this.beneficalEffect1.func_188419_a())) {
                    livingEntity.func_70690_d(new PotionEffect(this.beneficalEffect1));
                }
            } else if (this.nightmareBane && entity instanceof EntityItem && (stack = (item = (EntityItem)entity).func_92059_d()).func_77973_b() == WitcheryIngredientItems.DISTURBED_COTTON) {
                ItemStack newStack = new ItemStack((Block)WitcheryBlocks.WISPY_COTTON, stack.func_190916_E());
                item.func_92058_a(newStack);
            }
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        return !world.func_180495_p(pos).func_185904_a().func_76224_d() && super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_185904_a().func_76224_d() && super.displaceIfPossible(world, pos);
    }
}

