/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockWitchesOven;
import net.msrandom.witchery.block.entity.TileEntityWitchesOven;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryContainers;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class BlockFumeFunnel
extends BlockHorizontal {
    public static final PropertyEnum<Connections> CONNECTIONS = PropertyEnum.func_177709_a((String)"connections", Connections.class);
    public static final PropertyBool ON = PropertyBool.func_177716_a((String)"on");
    private final boolean filtered;

    public BlockFumeFunnel(boolean filtered) {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a(CONNECTIONS, (Comparable)((Object)Connections.NONE)).func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(false)));
        this.filtered = filtered;
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        switch (((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k()) {
            case Z: {
                if (BlockWitchesOven.isOven(world.func_180495_p(pos.func_177974_f()).func_177230_c())) {
                    pos = pos.func_177974_f();
                    break;
                }
                if (BlockWitchesOven.isOven(world.func_180495_p(pos.func_177976_e()).func_177230_c())) {
                    pos = pos.func_177976_e();
                    break;
                }
                if (!BlockWitchesOven.isOven(world.func_180495_p(pos.func_177977_b()).func_177230_c())) break;
                pos = pos.func_177977_b();
                break;
            }
            case X: {
                if (BlockWitchesOven.isOven(world.func_180495_p(pos.func_177968_d()).func_177230_c())) {
                    pos = pos.func_177968_d();
                    break;
                }
                if (BlockWitchesOven.isOven(world.func_180495_p(pos.func_177978_c()).func_177230_c())) {
                    pos = pos.func_177978_c();
                    break;
                }
                if (!BlockWitchesOven.isOven(world.func_180495_p(pos.func_177977_b()).func_177230_c())) break;
                pos = pos.func_177977_b();
            }
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityWitchesOven) {
            WitcheryUtils.openContainer(WitcheryContainers.getWitchesOven(), player, pos, ((TileEntityWitchesOven)te).func_145748_c_());
        }
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{field_185512_D, CONNECTIONS, ON}).build();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)ON)).booleanValue()) {
            double d0 = (float)pos.func_177958_n() + 0.45f;
            double d2 = (float)pos.func_177956_o() + 0.4f;
            double d3 = (float)pos.func_177952_p() + 0.5f;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)(state = super.func_176221_a(state, world, pos)).func_177229_b((IProperty)field_185512_D);
        EnumFacing ovenDirection = facing.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.SOUTH : EnumFacing.EAST;
        IBlockState left = world.func_180495_p(pos.func_177972_a(ovenDirection));
        IBlockState right = world.func_180495_p(pos.func_177972_a(ovenDirection.func_176734_d()));
        IBlockState down = world.func_180495_p(pos.func_177977_b());
        state = state.func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(left.func_177230_c() == WitcheryBlocks.WITCHES_OVEN_BURNING || right.func_177230_c() == WitcheryBlocks.WITCHES_OVEN_BURNING || down.func_177230_c() == WitcheryBlocks.WITCHES_OVEN_BURNING && down.func_177229_b((IProperty)field_185512_D) == facing));
        state = down.func_177230_c() instanceof BlockWitchesOven && down.func_177229_b((IProperty)field_185512_D) == facing ? state.func_177226_a(CONNECTIONS, (Comparable)((Object)Connections.TOP)) : (left.func_177230_c() instanceof BlockWitchesOven && left.func_177229_b((IProperty)field_185512_D) == facing ? (right.func_177230_c() instanceof BlockWitchesOven && right.func_177229_b((IProperty)field_185512_D) == facing ? state.func_177226_a(CONNECTIONS, (Comparable)((Object)Connections.SIDES)) : state.func_177226_a(CONNECTIONS, (Comparable)((Object)Connections.LEFT))) : (right.func_177230_c() instanceof BlockWitchesOven && right.func_177229_b((IProperty)field_185512_D) == facing ? state.func_177226_a(CONNECTIONS, (Comparable)((Object)Connections.RIGHT)) : state.func_177226_a(CONNECTIONS, (Comparable)((Object)Connections.NONE))));
        return state;
    }

    public static enum Connections implements IStringSerializable
    {
        NONE,
        RIGHT,
        LEFT,
        SIDES,
        TOP;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

