/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityVampire;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.rite.effect.RiteEffectProtectionCircleRepulsive;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockGarlicGarland
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB((double)0.1f, (double)0.8f, 1.0, (double)0.85f, 1.0, (double)0.9f);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.10000002384185791, (double)0.8f, 0.0, (double)0.9f, 1.0, (double)0.15f);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB((double)0.85f, (double)0.8f, (double)0.1f, (double)0.9f, 1.0, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, (double)0.8f, (double)0.1f, (double)0.15f, 1.0, (double)0.9f);

    public BlockGarlicGarland() {
        super(Material.field_151594_q);
        this.func_149711_c(0.2f);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return DEFAULT_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityVampire) {
            RiteEffectProtectionCircleRepulsive.push(entity, pos);
        } else if (world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_71075_bZ.field_75098_d && WitcheryUtils.getExtension((EntityPlayer)entity).isTransformation(WitcheryCreatureTraits.VAMPIRE)) {
                RiteEffectProtectionCircleRepulsive.push(entity, pos, false);
            }
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3))), 2);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.INSTANCE.getGARLIC_GARLAND().create();
    }

    public static class TileEntityGarlicGarland
    extends TileEntity {
    }
}

