/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityMovingBrew;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.util.WitcheryUtils;

public class BlockGasBrew
extends BlockContainer {
    public static final Material MATERIAL = new Material(MapColor.field_151660_b){

        public boolean func_76220_a() {
            return false;
        }

        public boolean func_76230_c() {
            return false;
        }
    }.func_76231_i();
    public static final PropertyInteger EXTENT = PropertyInteger.func_177719_a((String)"extent", (int)0, (int)10);

    public BlockGasBrew() {
        super(MATERIAL);
        this.func_149675_a(true);
        this.func_149649_H();
        this.func_149722_s();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean isAir(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176209_a(IBlockState p_149678_1_, boolean p_149678_2_) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState metadata2, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public int func_149738_a(World world) {
        return 5;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(blockState, world, pos, side);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, 5);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.func_176213_c(world, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            int initialMetadata = (Integer)state.func_177229_b((IProperty)EXTENT);
            TileEntityMovingBrew oldTile = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, pos);
            if (oldTile == null) {
                world.func_175698_g(pos);
                return;
            }
            int maxMeta = oldTile.expansion;
            if (oldTile.incRunTicks() > 120) {
                world.func_175698_g(pos);
                return;
            }
            if (initialMetadata >= maxMeta) {
                if (oldTile.duration == 0 || oldTile.duration > 0 && rand.nextInt(oldTile.duration) == 0) {
                    world.func_175698_g(pos);
                    return;
                }
            } else {
                double[] pb = new double[]{0.2, 0.4, 0.8, 0.8, 0.8, 0.8};
                boolean expanded = false;
                for (int i = 0; i < pb.length; ++i) {
                    BlockPos n;
                    Block block;
                    if (!(rand.nextDouble() < pb[i]) || (block = world.func_180495_p(n = pos.func_177972_a(EnumFacing.values()[i])).func_177230_c()) != Blocks.field_150350_a && block != Blocks.field_150431_aC) continue;
                    world.func_180501_a(n, state.func_177226_a((IProperty)EXTENT, (Comparable)Integer.valueOf(Math.min(initialMetadata + 1, maxMeta))), 3);
                    TileEntityMovingBrew newTile = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, n);
                    newTile.actionList = oldTile.actionList;
                    newTile.expansion = oldTile.expansion;
                    newTile.duration = oldTile.duration;
                    newTile.thrower = oldTile.thrower;
                    expanded = true;
                }
                if (expanded) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)EXTENT, (Comparable)Integer.valueOf(Math.min(initialMetadata + 1, maxMeta))), 3);
                }
            }
            world.func_175684_a(pos, (Block)this, 5);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EXTENT, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)EXTENT);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{EXTENT}).build();
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityMovingBrew gas;
        if (entity instanceof EntityLivingBase && !world.field_72995_K && world.field_73012_v.nextInt(10) == 4 && (gas = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, pos)) != null) {
            EntityLivingBase living2 = (EntityLivingBase)entity;
            ModifiersEffect modifiers = new ModifiersEffect(0.25, 0.5, false, new Vec3d((Vec3i)pos), false, 0, WitcheryUtils.getPlayer(world, gas.thrower));
            modifiers.protectedFromNegativePotions = living2.func_70644_a(WitcheryPotionEffects.GAS_MASK);
            gas.actionList.applyToEntity(world, living2, modifiers);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.MOVING_BREW.create();
    }
}

