/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityKettle;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.recipe.KettleRecipe;
import net.msrandom.witchery.util.BlockUtil;
import org.jetbrains.annotations.Nullable;

public class BlockKettle
extends BlockContainer {
    private static final PropertyBool FILLED = PropertyBool.func_177716_a((String)"filled");
    private static final PropertyEnum<Placement> PLACEMENT = PropertyEnum.func_177709_a((String)"placement", Placement.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);

    public BlockKettle() {
        super(Material.field_151574_g);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)).func_177226_a(PLACEMENT, (Comparable)((Object)Placement.HANGING)));
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    @Nonnull
    private static ItemStack consumeItem(ItemStack stack) {
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return stack.func_77973_b().getContainerItem(stack);
        }
        return stack;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (world.func_180495_p(pos.func_177984_a()).func_193401_d((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN) == BlockFaceShape.SOLID) {
            return this.func_176223_P().func_177226_a(PLACEMENT, (Comparable)((Object)Placement.HANGING));
        }
        return this.func_176223_P().func_177226_a(PLACEMENT, (Comparable)((Object)(placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X ? Placement.X_AXIS : Placement.Z_AXIS)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.func_180495_p(pos.func_177984_a()).func_193401_d((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN) == BlockFaceShape.SOLID) {
            world.func_175656_a(pos, state.func_177226_a(PLACEMENT, (Comparable)((Object)Placement.HANGING)));
        }
        world.func_175656_a(pos, state.func_177226_a(PLACEMENT, (Comparable)((Object)(placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X ? Placement.X_AXIS : Placement.Z_AXIS))));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PLACEMENT, (Comparable)((Object)Placement.VALUES[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Placement)((Object)state.func_177229_b(PLACEMENT))).ordinal();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        if (state.func_177229_b(PLACEMENT) != Placement.HANGING && rot.ordinal() % 2 == 1) {
            return state.func_177226_a(PLACEMENT, (Comparable)((Object)(state.func_177229_b(PLACEMENT) == Placement.X_AXIS ? Placement.Z_AXIS : Placement.X_AXIS)));
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FILLED, PLACEMENT}).build();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState newState = world.func_180495_p(pos.func_177984_a()).isSideSolid(world, pos.func_177984_a(), EnumFacing.DOWN) ? state.func_177226_a(PLACEMENT, (Comparable)((Object)Placement.HANGING)) : state;
        TileEntityKettle kettle = WitcheryTileEntities.KETTLE.getAt(world, pos);
        if (kettle != null && kettle.isFilled()) {
            newState = newState.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(true));
        }
        return newState;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        TileEntityKettle tileEntity = WitcheryTileEntities.KETTLE.getAt((IBlockAccess)world, pos);
        if (tileEntity != null) {
            double d0 = (float)pos.func_177958_n() + 0.45f;
            double d2 = (float)pos.func_177956_o() + 0.4f;
            double d3 = (float)pos.func_177952_p() + 0.5f;
            if (tileEntity.isRuined()) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
            } else if (tileEntity.isReady()) {
                world.func_175688_a(EnumParticleTypes.SLIME, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
                if (tileEntity.isPowered) {
                    world.func_175688_a(EnumParticleTypes.SPELL, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
                } else {
                    world.func_175688_a(EnumParticleTypes.SPELL_MOB, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
                }
            } else if (tileEntity.isBrewing()) {
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean tryFillWith(World world, BlockPos pos, FluidStack fluidStack) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityKettle tile = WitcheryTileEntities.KETTLE.getAt((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        if (tile.canFill(fluidStack.getFluid())) {
            int qty = tile.fill(fluidStack, true);
            fluidStack.amount -= qty;
            if (fluidStack.amount < 0) {
                fluidStack.amount = 0;
            }
            if (qty > 0) {
                BlockUtil.notifyBlockUpdate(world, pos);
                world.func_184133_a(null, pos, SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            }
            return qty > 0;
        }
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack current = player.func_184586_b(hand);
        if (!current.func_190926_b()) {
            FluidStack available;
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileEntityKettle)) {
                return false;
            }
            TileEntityKettle tank = (TileEntityKettle)tile;
            if (current.func_77973_b() == Items.field_151069_bo && tank.isReady()) {
                KettleRecipe recipe = tank.getRecipe();
                if (recipe != null && (recipe.getFamiliarPower() == null || Familiars.hasFamiliarPower(player, recipe.getFamiliarPower()))) {
                    tank.setConsumeBottle(false);
                    ItemStack stack = tank.func_70298_a(6, 1);
                    tank.empty();
                    tank.setConsumeBottle(true);
                    double bonusChance = 0.0;
                    double bonusChance2 = 0.0;
                    if (player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == WitcheryEquipmentItems.WITCH_HAT) {
                        bonusChance += 0.35;
                    } else if (player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == WitcheryEquipmentItems.BABAS_HAT) {
                        bonusChance += 0.25;
                        bonusChance2 += 0.25;
                    }
                    if (stack.func_77973_b() != WitcheryBrewItems.RAISING_BREW && WitcheryEquipmentItems.WITCH_ROBES.isRobeWorn(player)) {
                        bonusChance += 0.35;
                    } else if (stack.func_77973_b() == WitcheryBrewItems.RAISING_BREW && WitcheryEquipmentItems.NECROMANCERS_ROBES.isRobeWorn(player)) {
                        bonusChance += 0.35;
                    }
                    if (Familiars.hasFamiliarPower(player, WitcheryFamiliars.BREW_MASTERY)) {
                        bonusChance += 0.05;
                        if (player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == WitcheryEquipmentItems.BABAS_HAT) {
                            bonusChance2 += 0.05;
                        }
                    }
                    if (bonusChance > 0.0 && world.field_73012_v.nextDouble() <= bonusChance) {
                        stack.func_190917_f(recipe.getHatBonus());
                    }
                    if (bonusChance2 > 0.0 && world.field_73012_v.nextDouble() <= bonusChance2) {
                        stack.func_190917_f(recipe.getHatBonus());
                    }
                    if (!world.field_72995_K) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            current.func_190918_g(1);
                        }
                        if (current.func_190926_b()) {
                            player.func_184611_a(hand, stack);
                        } else if (!player.field_71071_by.func_70441_a(stack)) {
                            player.func_71019_a(stack, false);
                        }
                        ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                    }
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                }
                return true;
            }
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)current);
            if (fluidHandler != null) {
                FluidStack liquid = fluidHandler.drain(1000, false);
                if (!tank.isFilled() && liquid != null && tank.canFill(liquid.getFluid())) {
                    int filling = tank.fill(fluidHandler.drain(liquid, !player.field_71075_bZ.field_75098_d), true);
                    tank.reset(false);
                    if (filling != 0 && !player.field_71075_bZ.field_75098_d) {
                        player.func_184611_a(hand, BlockKettle.consumeItem(current));
                        if (!world.field_72995_K) {
                            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                        }
                    }
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    return true;
                }
            }
            if ((available = tank.getTankProperties()[0].getContents()) != null) {
                int quantity;
                if (current.func_77973_b() == Items.field_151133_ar) {
                    ItemStack filled = FluidUtil.getFilledBucket((FluidStack)available);
                    FluidStack liquid = FluidUtil.getFluidContained((ItemStack)filled);
                    if (liquid != null) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            if (current.func_190916_E() > 1) {
                                if (!player.field_71071_by.func_70441_a(filled)) {
                                    return false;
                                }
                                current.func_190918_g(1);
                            } else {
                                player.func_184611_a(hand, filled);
                            }
                            if (!world.field_72995_K) {
                                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                            }
                        }
                        tank.drain(liquid.amount, true);
                        tank.reset(false);
                        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        return true;
                    }
                } else if (fluidHandler != null && (quantity = fluidHandler.fill(available, false)) > 0) {
                    fluidHandler.fill(tank.drain(quantity, true), true);
                }
            }
        }
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityKettle tileEntity;
        if (!world.field_72995_K && entity instanceof EntityItem && (tileEntity = (TileEntityKettle)world.func_175625_s(pos)) != null) {
            EntityItem itemEntity = (EntityItem)entity;
            if (itemEntity.func_92059_d().func_77973_b() == Items.field_151069_bo) {
                ItemStack stack = tileEntity.func_70301_a(7);
                if (stack.func_190926_b()) {
                    tileEntity.func_70299_a(7, itemEntity.func_92059_d());
                    itemEntity.func_70106_y();
                } else if (stack.func_190916_E() + itemEntity.func_92059_d().func_190916_E() <= tileEntity.func_70297_j_()) {
                    stack.func_190917_f(itemEntity.func_92059_d().func_190916_E());
                    tileEntity.func_70299_a(7, stack);
                    itemEntity.func_70106_y();
                }
            } else if (tileEntity.isFilled()) {
                boolean spaceFound = false;
                for (int i = 0; i < tileEntity.func_70302_i_() - 2; ++i) {
                    if (!tileEntity.func_70301_a(i).func_190926_b()) continue;
                    tileEntity.func_70299_a(i, itemEntity.func_92059_d());
                    spaceFound = true;
                    break;
                }
                if (!spaceFound && !tileEntity.isRuined()) {
                    tileEntity.setRuined();
                }
                itemEntity.func_70106_y();
                world.func_184133_a(null, pos, SoundEvents.field_187806_ee, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5, 0.5f, 0.5f, EnumParticleTypes.WATER_SPLASH), world, pos, 5.0);
            }
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.KETTLE.create();
    }

    private static enum Placement implements IStringSerializable
    {
        X_AXIS("x"),
        Z_AXIS("z"),
        HANGING("hanging");

        private static final Placement[] VALUES;
        private final String name;

        private Placement(String name2) {
            this.name = name2;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            VALUES = Placement.values();
        }
    }
}

