/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BloodTrap;
import net.msrandom.witchery.block.entity.TileEntityLeechChest;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import org.jetbrains.annotations.Nullable;

public class BlockLeechChest
extends BlockContainer
implements BloodTrap {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.875, 0.9375);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 0.875, 0.9375);

    public BlockLeechChest() {
        super(Material.field_151576_e);
        this.func_149647_a(WitcheryGeneralItems.TAB);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(25.0f);
        this.func_149752_b(1000.0f);
    }

    public static boolean isOcelotBlockingChest(World world, BlockPos pos) {
        for (EntityOcelot entityocelot : world.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            if (!entityocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (source.func_180495_p(pos.func_177978_c()).func_177230_c() == this) {
            return NORTH_AABB;
        }
        if (source.func_180495_p(pos.func_177968_d()).func_177230_c() == this) {
            return SOUTH_AABB;
        }
        if (source.func_180495_p(pos.func_177976_e()).func_177230_c() == this) {
            return WEST_AABB;
        }
        if (source.func_180495_p(pos.func_177974_f()).func_177230_c() == this) {
            return EAST_AABB;
        }
        return DEFAULT_AABB;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockPos north = pos.func_177978_c();
        BlockPos south = pos.func_177968_d();
        BlockPos west = pos.func_177976_e();
        BlockPos east = pos.func_177974_f();
        Block northBlock = world.func_180495_p(north).func_177230_c();
        Block southBlock = world.func_180495_p(south).func_177230_c();
        Block westBlock = world.func_180495_p(west).func_177230_c();
        Block eastBlock = world.func_180495_p(east).func_177230_c();
        IBlockState currentState = state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
        if (northBlock != this && southBlock != this && westBlock != this && eastBlock != this) {
            world.func_180501_a(pos, state, 3);
        } else {
            if (!(northBlock != this && southBlock != this || currentState.func_177229_b((IProperty)FACING) != EnumFacing.WEST && currentState.func_177229_b((IProperty)FACING) != EnumFacing.EAST)) {
                if (northBlock == this) {
                    world.func_180501_a(north, currentState, 3);
                } else {
                    world.func_180501_a(south, currentState, 3);
                }
                world.func_180501_a(pos, currentState, 3);
            }
            if (!(westBlock != this && eastBlock != this || currentState.func_177229_b((IProperty)FACING) != EnumFacing.NORTH && currentState.func_177229_b((IProperty)FACING) != EnumFacing.SOUTH)) {
                if (westBlock == this) {
                    world.func_180501_a(north, currentState, 3);
                } else {
                    world.func_180501_a(south, currentState, 3);
                }
                world.func_180501_a(pos, currentState, 3);
            }
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLeechChest) {
            TileEntityLeechChest chest = (TileEntityLeechChest)tile;
            if (stack.func_82837_s()) {
                chest.setChestGuiName(stack.func_82833_r());
            }
            if (!world.field_72995_K && stack.func_77942_o()) {
                chest.readPlayers(stack.func_77978_p());
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityLeechChest) {
            TileEntityLeechChest tileentitychest = (TileEntityLeechChest)tile;
            tileentitychest.func_145836_u();
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityLeechChest chest = WitcheryTileEntities.LEECH_CHEST.getAt((IBlockAccess)worldIn, pos);
        if (chest != null) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)chest);
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemStack stack = new ItemStack((Block)this);
            TileEntityLeechChest chest = WitcheryTileEntities.LEECH_CHEST.getAt((IBlockAccess)world, pos);
            if (chest != null) {
                NBTTagCompound tag = new NBTTagCompound();
                chest.writePlayers(tag);
                stack.func_77982_d(tag);
            }
            BlockLeechChest.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        IInventory iinventory = this.getInventory(world, pos);
        if (iinventory != null && !this.handleItem(world, WitcheryTileEntities.LEECH_CHEST.getAt((IBlockAccess)world, pos), player, hand)) {
            player.func_71007_a(iinventory);
        }
        return true;
    }

    public IInventory getInventory(World world, BlockPos pos) {
        TileEntity object = world.func_175625_s(pos);
        if (object == null) {
            return null;
        }
        if (world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
            return null;
        }
        if (BlockLeechChest.isOcelotBlockingChest(world, pos)) {
            return null;
        }
        if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == this && (world.isSideSolid(pos.func_177982_a(-1, 1, 0), EnumFacing.DOWN) || BlockLeechChest.isOcelotBlockingChest(world, pos.func_177976_e()))) {
            return null;
        }
        if (world.func_180495_p(pos.func_177974_f()).func_177230_c() == this && (world.isSideSolid(pos.func_177982_a(1, 1, 0), EnumFacing.DOWN) || BlockLeechChest.isOcelotBlockingChest(world, pos.func_177974_f()))) {
            return null;
        }
        if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == this && (world.isSideSolid(pos.func_177982_a(0, 1, -1), EnumFacing.DOWN) || BlockLeechChest.isOcelotBlockingChest(world, pos.func_177978_c()))) {
            return null;
        }
        if (world.func_180495_p(pos.func_177968_d()).func_177230_c() == this && (world.isSideSolid(pos.func_177982_a(0, 1, 1), EnumFacing.DOWN) || BlockLeechChest.isOcelotBlockingChest(world, pos.func_177968_d()))) {
            return null;
        }
        return (IInventory)object;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.func_149744_f(blockState)) {
            return 0;
        }
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile instanceof TileEntityLeechChest) {
            int i1 = ((TileEntityLeechChest)tile).numPlayersUsing;
            return MathHelper.func_76125_a((int)i1, (int)0, (int)15);
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? this.func_180656_a(blockState, blockAccess, pos, side) : 0;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)this.getInventory(world, pos));
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.LEECH_CHEST.create();
    }
}

