/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.msrandom.witchery.block.entity.TileEntityMovingBrew;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.init.WitcheryFluids;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.util.WitcheryUtils;

public class BlockLiquidBrew
extends BlockFluidClassic
implements ITileEntityProvider {
    public BlockLiquidBrew() {
        super(WitcheryFluids.BREW_LIQUID, Material.field_151586_h);
        this.field_149758_A = true;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta, TileEntityMovingBrew sourceFluid) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(meta)), 3);
            TileEntityMovingBrew targetFluid = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, pos);
            if (targetFluid != null && sourceFluid != null) {
                targetFluid.actionList = sourceFluid.actionList;
                targetFluid.expansion = sourceFluid.expansion;
                targetFluid.duration = sourceFluid.duration;
                targetFluid.thrower = sourceFluid.thrower;
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        boolean evaporated = false;
        TileEntityMovingBrew fluid = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, pos);
        if (fluid != null && this.isSourceBlock((IBlockAccess)world, pos)) {
            if (++fluid.updateCount > 3 && (fluid.duration == 0 || rand.nextInt(fluid.duration) == 0)) {
                world.func_175698_g(pos);
                evaporated = true;
            } else {
                world.func_175684_a(pos, (Block)this, this.tickRate);
            }
        }
        if (!evaporated) {
            int quantaRemaining = this.quantaPerBlock - (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockLiquid.field_176367_b);
            if (quantaRemaining < this.quantaPerBlock) {
                int expQuanta;
                BlockPos y2 = pos.func_177981_b(this.densityDir);
                if (world.func_180495_p(y2).func_177230_c() == this || world.func_180495_p(y2.func_177976_e()).func_177230_c() == this || world.func_180495_p(y2.func_177974_f()).func_177230_c() == this || world.func_180495_p(y2.func_177978_c()).func_177230_c() == this || world.func_180495_p(y2.func_177968_d()).func_177230_c() == this) {
                    expQuanta = this.quantaPerBlock - 1;
                } else {
                    int maxQuanta = -100;
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177976_e(), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177974_f(), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177978_c(), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.func_177968_d(), maxQuanta);
                    expQuanta = maxQuanta - 1;
                }
                if (expQuanta != quantaRemaining) {
                    quantaRemaining = expQuanta;
                    if (quantaRemaining <= 0) {
                        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    } else {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 3);
                        world.func_175684_a(pos, (Block)this, this.tickRate);
                        world.func_175722_b(pos, (Block)this, true);
                    }
                }
            } else {
                world.func_180501_a(pos, this.func_176223_P(), 2);
            }
            if (this.canDisplace((IBlockAccess)world, pos.func_177981_b(this.densityDir))) {
                this.flowIntoBlock(world, pos.func_177981_b(this.densityDir), 1, fluid);
                return;
            }
            int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
            if (flowMeta >= this.quantaPerBlock) {
                return;
            }
            if (this.isSourceBlock((IBlockAccess)world, pos) || !this.isFlowingVertically((IBlockAccess)world, pos)) {
                boolean[] flowTo;
                if (world.func_180495_p(pos.func_177979_c(this.densityDir)).func_177230_c() == this) {
                    flowMeta = 1;
                }
                if ((flowTo = this.getOptimalFlowDirections(world, pos))[0]) {
                    this.flowIntoBlock(world, pos.func_177976_e(), flowMeta, fluid);
                }
                if (flowTo[1]) {
                    this.flowIntoBlock(world, pos.func_177974_f(), flowMeta, fluid);
                }
                if (flowTo[2]) {
                    this.flowIntoBlock(world, pos.func_177978_c(), flowMeta, fluid);
                }
                if (flowTo[3]) {
                    this.flowIntoBlock(world, pos.func_177968_d(), flowMeta, fluid);
                }
            }
            if (fluid != null) {
                for (EnumFacing direction : EnumFacing.values()) {
                    ModifiersEffect modifiersEffect;
                    BlockPos p2 = pos.func_177972_a(direction);
                    Block block = world.func_180495_p(p2).func_177230_c();
                    if (!(world.field_73012_v.nextDouble() < 0.01) || block == Blocks.field_150350_a && !world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a() || block == this) continue;
                    EntityPlayer player = WitcheryUtils.getPlayer(world, fluid.thrower);
                    if (player == null) {
                        player = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile(fluid.thrower, null));
                    }
                    ModifiersEffect modifiers = modifiersEffect = new ModifiersEffect(1.0, 1.0, false, new Vec3d((Vec3i)pos), false, 0, player);
                    ++modifiersEffect.strengthPenalty;
                    fluid.actionList.applyToBlock(world, p2, direction.func_176734_d(), 1, modifiers);
                }
                world.func_175684_a(pos, (Block)this, this.tickRate);
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityMovingBrew liquid;
        if (entity instanceof EntityLivingBase && !world.field_72995_K && world.field_73012_v.nextInt(10) == 4 && (liquid = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, pos)) != null) {
            EntityLivingBase living2 = (EntityLivingBase)entity;
            EntityPlayer player = WitcheryUtils.getPlayer(world, liquid.thrower);
            if (player == null) {
                player = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile(liquid.thrower, null));
            }
            liquid.actionList.applyToEntity(world, living2, new ModifiersEffect(0.25, 0.5, false, new Vec3d((Vec3i)pos), false, 0, player));
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.MOVING_BREW.create();
    }
}

