/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.block.entity.TileEntityMirror;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.entity.EntityMirrorFace;
import net.msrandom.witchery.entity.EntityReflection;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.TeleportationUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockMirror
extends BlockContainer {
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, (double)0.85f, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.15f);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB((double)0.85f, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.15f, 1.0, 1.0);
    private static String sendMeHome;
    private static String iGiveUp;
    private final boolean unbreakable;

    public BlockMirror(boolean unbreakable) {
        super(Material.field_151592_s);
        this.unbreakable = unbreakable;
        this.func_149715_a(0.7f);
        this.func_149649_H();
        this.func_149672_a(SoundType.field_185853_f);
        if (unbreakable) {
            this.func_149722_s();
        } else {
            this.func_149711_c(1.0f);
            this.func_149647_a(WitcheryGeneralItems.TAB);
        }
        this.func_149752_b(9999.0f);
    }

    public static EnumFacing getDirection(IBlockState meta) {
        return (EnumFacing)meta.func_177229_b((IProperty)FACING);
    }

    public static boolean isBlockTopOfMirror(IBlockState meta) {
        return (Boolean)meta.func_177229_b((IProperty)TOP);
    }

    public static void mirrorGoHome(EntityPlayer player) {
        if (WitcheryDimensions.MIRROR.isInDimension((Entity)player)) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            if (playerEx.hasMirrorEscapeCooldown(1)) {
                player.func_145747_a(new TextComponentTranslation(WitcheryBlocks.MIRROR.func_149739_a() + ".failed_chant", new Object[]{Long.valueOf(playerEx.getCooldownSecs(1)).toString()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return;
            }
            BlockPos entryPoint = playerEx.getMirrorWorldEntryPoint();
            if (entryPoint != null) {
                playerEx.escapedMirrorWorld(1);
                player.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, 270.0f, player.field_70125_A);
                TeleportationUtil.teleportToLocation(entryPoint, player.field_71093_bK, (Entity)player, true, EnumParticleTypes.WATER_SPLASH, WitcherySounds.BLOCK_MIRROR_SPLASH);
                return;
            }
        }
        player.func_145747_a(new TextComponentTranslation("chant.witchery.unknown_chant", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
    }

    public static void mirrorGiveUp(EntityPlayer player) {
        if (WitcheryDimensions.MIRROR.isInDimension((Entity)player)) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            if (playerEx.hasMirrorEscapeCooldown(2)) {
                player.func_145747_a(new TextComponentTranslation(WitcheryBlocks.MIRROR.func_149739_a() + ".failed_chant", new Object[]{Long.valueOf(playerEx.getCooldownSecs(2)).toString()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return;
            }
            BlockPos bedLocation = player.getBedLocation(player.field_71093_bK);
            if (bedLocation != null && (bedLocation = Blocks.field_150324_C.getBedSpawnPosition(player.field_70170_p.func_180495_p(bedLocation), (IBlockAccess)player.field_70170_p, bedLocation, null)) != null) {
                playerEx.escapedMirrorWorld(2);
                TeleportationUtil.teleportToLocation(bedLocation.func_177984_a(), player.field_71093_bK, (Entity)player, true);
                return;
            }
        }
        player.func_145747_a(new TextComponentTranslation("chant.witchery.unknown_chant", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
    }

    public void func_190948_a(ItemStack stack, @javax.annotation.Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        NBTTagCompound nbtRoot = stack.func_77978_p();
        if (nbtRoot == null || !nbtRoot.func_74767_n("DemonSlain")) {
            tooltip.add(I18n.func_135052_a((String)(this.func_149739_a() + ".tip.inhabited"), (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)(this.func_149739_a() + ".tip.bridge"), (Object[])new Object[0]));
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity.field_70173_aa % 5 == 1 && this.isTransportableEntity(entity)) {
            TileEntityMirror tile;
            AxisAlignedBB box;
            double f2;
            double f;
            AxisAlignedBB entityBox;
            int hitZoneyShift = 0;
            if (!BlockMirror.isBlockTopOfMirror(state)) {
                pos = pos.func_177984_a();
                if (entity.field_70131_O <= 1.0f) {
                    hitZoneyShift = -1;
                }
                if (world.func_180495_p(pos).func_177230_c() != this) {
                    return;
                }
            }
            if ((entityBox = new AxisAlignedBB(entity.field_70165_t - (f = (double)entity.field_70130_N * 0.5), entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v - f, entity.field_70165_t + f, entity.field_70163_u + (double)entity.field_70131_O + (f2 = (double)entity.field_70131_O), entity.field_70161_v + f)).func_72326_a(box = this.getServerSelectedBoundingBoxFromPool(world, pos.func_177981_b(hitZoneyShift))) && (tile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)world, pos)) != null) {
                EnumFacing side = BlockMirror.getDirection(world.func_180495_p(pos));
                int facing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                int dx = 0;
                int dz = 0;
                float shift = 0.7f;
                float xShift = 0.0f;
                float zShift = 0.0f;
                int scale = 1;
                EnumFacing requiredSide = side.func_176734_d();
                boolean isLiving = entity instanceof EntityLivingBase;
                if (side == EnumFacing.NORTH) {
                    dz = scale;
                    zShift = -shift;
                    if (isLiving && facing != 0) {
                        return;
                    }
                } else if (side == EnumFacing.SOUTH) {
                    dz = -scale;
                    zShift = shift;
                    if (isLiving && facing != 2) {
                        return;
                    }
                } else if (side == EnumFacing.WEST) {
                    dx = scale;
                    xShift = -shift;
                    if (isLiving && facing != 3) {
                        return;
                    }
                } else if (side == EnumFacing.EAST) {
                    dx = -scale;
                    xShift = shift;
                    if (isLiving && facing != 1) {
                        return;
                    }
                }
                boolean inMirrorWorld = WitcheryDimensions.MIRROR.isInDimension(entity);
                if (!this.unbreakable) {
                    BlockPos np;
                    int j;
                    if (inMirrorWorld || tile.demonKilled) {
                        for (j = 1; j < 32; ++j) {
                            int nz;
                            int ny;
                            np = pos.func_177982_a(dx * j, 0, dz * j);
                            int nx = np.func_177958_n();
                            IBlockState ns = world.func_180495_p(new BlockPos(nx, ny = np.func_177956_o(), nz = np.func_177952_p()));
                            Block block = ns.func_177230_c();
                            if (block != this || BlockMirror.getDirection(ns) != requiredSide) continue;
                            TeleportationUtil.teleportToLocation(0.5 + (double)nx - (double)xShift, (double)(ny - 1) + 0.01, 0.5 + (double)nz - (double)zShift, world.field_73011_w.getDimension(), entity, true, EnumParticleTypes.WATER_SPLASH, WitcherySounds.BLOCK_MIRROR_SPLASH);
                            return;
                        }
                    }
                    if (inMirrorWorld) {
                        for (j = 1; j < 10; ++j) {
                            IPowerSource power;
                            int nz;
                            int cz;
                            int ny;
                            int cy;
                            int nx;
                            int cx;
                            boolean isEntryCell;
                            np = pos.func_177982_a(dx * j, 0, dz * j);
                            if (!world.func_175623_d(pos) || !world.func_175623_d(pos.func_177977_b())) continue;
                            boolean isPlayerEntryCell = false;
                            if (entity instanceof EntityPlayer) {
                                EntityPlayer player = (EntityPlayer)entity;
                                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                                isPlayerEntryCell = playerEx.isMirrorWorldEntryPoint(np);
                            }
                            boolean bl = isEntryCell = world.func_180495_p(new BlockPos(cx = ((nx = np.func_177958_n()) >> 4 << 4) + 4, cy = ((ny = np.func_177956_o()) >> 4 << 4) + 8, cz = ((nz = np.func_177952_p()) >> 4 << 4) + 8)).func_177230_c() == WitcheryBlocks.UNBREAKABLE_MIRROR;
                            if ((!isEntryCell || isPlayerEntryCell) && (power = PowerSources.findClosestPowerSource(world, pos)) != null && power.consumePower(3000.0f)) {
                                TeleportationUtil.teleportToLocation(0.5 + (double)nx - (double)xShift, (double)ny + 0.01, 0.5 + (double)nz - (double)zShift, world.field_73011_w.getDimension(), entity, true, EnumParticleTypes.WATER_SPLASH, WitcherySounds.BLOCK_MIRROR_SPLASH);
                            }
                            return;
                        }
                    } else if (tile.demonKilled) {
                        int dy;
                        for (dy = 2; dy < 16; ++dy) {
                            np = pos.func_177982_a(0, dy, 0);
                            IBlockState meta = world.func_180495_p(np);
                            Block block = meta.func_177230_c();
                            if (block != this || BlockMirror.getDirection(meta) != side) continue;
                            if (BlockMirror.isBlockTopOfMirror(meta)) {
                                np = np.func_177977_b();
                            }
                            int nx = np.func_177958_n();
                            int ny = np.func_177956_o();
                            int nz = np.func_177952_p();
                            TeleportationUtil.teleportToLocation(0.5 + (double)nx + (double)xShift, (double)ny + 0.01, 0.5 + (double)nz + (double)zShift, world.field_73011_w.getDimension(), entity, true, EnumParticleTypes.WATER_SPLASH, WitcherySounds.BLOCK_MIRROR_SPLASH);
                            if (entity instanceof EntityPlayerMP) {
                                EntityPlayerMP player2 = (EntityPlayerMP)entity;
                                double yaw = player2.field_70177_z + 180.0f;
                                float rev = (float)yaw % 360.0f;
                                SPacketPlayerPosLook packet2 = new SPacketPlayerPosLook(player2.field_70165_t, player2.field_70163_u, player2.field_70161_v, rev, player2.field_70125_A, EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class), player2.field_71135_a.field_184363_z);
                                player2.field_71135_a.func_147359_a((Packet)packet2);
                            }
                            return;
                        }
                        for (dy = 2; dy < 16; ++dy) {
                            np = pos.func_177982_a(0, -dy, 0);
                            IBlockState meta = world.func_180495_p(np);
                            Block block = meta.func_177230_c();
                            if (block != this || BlockMirror.getDirection(meta) != side) continue;
                            if (BlockMirror.isBlockTopOfMirror(meta)) {
                                np = np.func_177977_b();
                            }
                            TeleportationUtil.teleportToLocation(0.5 + (double)np.func_177958_n() + (double)xShift, (double)np.func_177956_o() + 0.01, 0.5 + (double)np.func_177952_p() + (double)zShift, world.field_73011_w.getDimension(), entity, true, EnumParticleTypes.WATER_SPLASH, WitcherySounds.BLOCK_MIRROR_SPLASH);
                            if (entity instanceof EntityPlayerMP) {
                                EntityPlayerMP player2 = (EntityPlayerMP)entity;
                                double yaw = player2.field_70177_z + 180.0f;
                                float rev = (float)yaw % 360.0f;
                                SPacketPlayerPosLook packet3 = new SPacketPlayerPosLook(player2.field_70165_t, player2.field_70163_u, player2.field_70161_v, rev, player2.field_70125_A, EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class), player2.field_71135_a.field_184363_z);
                                player2.field_71135_a.func_147359_a((Packet)packet3);
                            }
                            return;
                        }
                    }
                }
                if (entity instanceof EntityPlayer) {
                    BlockPos dimCoords;
                    EntityPlayer player3 = (EntityPlayer)entity;
                    PlayerExtendedData playerEx2 = WitcheryUtils.getExtension(player3);
                    if ((!inMirrorWorld || playerEx2.isMirrorWorldEntryPoint(pos)) && (dimCoords = tile.getDimCoords()) != null) {
                        float dimX = (float)dimCoords.func_177958_n() + 0.5f;
                        float dimY = (float)dimCoords.func_177956_o() + 0.01f;
                        float dimZ = (float)dimCoords.func_177952_p() + 0.5f;
                        int targetDimension = inMirrorWorld ? tile.dim : WitcheryDimensions.MIRROR.getType().func_186068_a();
                        WorldServer otherWorld = player3.func_184102_h().func_71218_a(targetDimension);
                        float face = 0.0f;
                        IBlockState state2 = otherWorld.func_180495_p(dimCoords);
                        Block block2 = state2.func_177230_c();
                        if (block2 instanceof BlockMirror) {
                            EnumFacing mside = BlockMirror.getDirection(state2);
                            float distance = 1.0f;
                            face = mside.func_185119_l();
                            if (mside == EnumFacing.NORTH) {
                                dimZ -= distance;
                            } else if (mside == EnumFacing.SOUTH) {
                                dimZ += distance;
                            } else if (mside == EnumFacing.WEST) {
                                dimX -= distance;
                            } else if (mside == EnumFacing.EAST) {
                                dimX += distance;
                            }
                            player3.field_70177_z = face;
                            TileEntityMirror otherTile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)world, pos);
                            if (otherTile != null) {
                                if (otherTile.onCooldown()) {
                                    return;
                                }
                                otherTile.addCooldown(60);
                            }
                        }
                        entity.func_184185_a(WitcherySounds.BLOCK_MIRROR_SPLASH, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.WATER_SPLASH), entity);
                        if (!WitcheryDimensions.MIRROR.isInDimension(entity)) {
                            if (!tile.demonKilled) {
                                float cellMidZ;
                                float cellMidY;
                                double R = 7.0;
                                double RY = 6.0;
                                float cellMidX = dimCoords.func_177958_n() + 4;
                                AxisAlignedBB bounds = new AxisAlignedBB((double)cellMidX - R, (double)(cellMidY = (float)dimCoords.func_177956_o()) - RY, (double)(cellMidZ = (float)dimCoords.func_177952_p()) - R, (double)cellMidX + R, (double)cellMidY + RY, (double)cellMidZ + R);
                                List EntityReflection2 = otherWorld.func_72872_a(EntityReflection.class, bounds);
                                if (EntityReflection2.isEmpty()) {
                                    EntityReflection reflection = new EntityReflection((World)otherWorld);
                                    reflection.func_70080_a(0.5 + (double)cellMidX, 1.1 + (double)cellMidY, 0.5 + (double)cellMidZ, 0.0f, 0.0f);
                                    reflection.func_110163_bv();
                                    reflection.field_70170_p.func_72838_d((Entity)reflection);
                                }
                            }
                            playerEx2.setMirrorWorldEntryPoint(dimCoords);
                            player3.func_70080_a((double)dimX, (double)(dimY - 1.0f), (double)dimZ, face, player3.field_70125_A);
                            TeleportationUtil.travelToDimension(player3, WitcheryDimensions.MIRROR.getType().func_186068_a());
                            player3.func_70634_a((double)dimX, (double)(dimY - 1.0f), (double)dimZ);
                        } else if (tile.isConnected) {
                            player3.func_70080_a((double)dimX, (double)(dimY - 1.0f), (double)dimZ, face, player3.field_70125_A);
                            TeleportationUtil.travelToDimension(player3, tile.dim);
                            player3.func_70634_a((double)dimX, (double)(dimY - 1.0f), (double)dimZ);
                        } else {
                            double targetX = dimX;
                            double targetY = dimY - 1.0f;
                            double targetZ = dimZ;
                            int targetDim = tile.dim;
                            MinecraftServer server = world.func_73046_m();
                            for (WorldServer worldServer : server.field_71305_c) {
                                block5: for (EntityPlayer otherPlayer : worldServer.field_73010_i) {
                                    for (ItemStack stack : otherPlayer.field_71071_by.field_70462_a) {
                                        boolean isMirror;
                                        if (Block.func_149634_a((Item)stack.func_77973_b()) != this || !(isMirror = tile.isTargetedBy(stack))) continue;
                                        if (WitcheryDimensions.MIRROR.isInDimension((Entity)otherPlayer)) continue block5;
                                        targetX = otherPlayer.field_70165_t;
                                        targetY = otherPlayer.field_70163_u;
                                        targetZ = otherPlayer.field_70161_v;
                                        targetDim = otherPlayer.field_71093_bK;
                                        continue block5;
                                    }
                                }
                            }
                            player3.func_70080_a(targetX, targetY, targetZ, face, player3.field_70125_A);
                            TeleportationUtil.travelToDimension(player3, targetDim);
                            player3.func_70634_a(targetX, targetY, targetZ);
                        }
                        entity.func_184185_a(WitcherySounds.BLOCK_MIRROR_SPLASH, 0.5f, 0.4f / (entity.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.WATER_SPLASH), entity);
                    }
                }
            }
        }
    }

    public void demonSlain(World world, double posX, double posY, double posZ) {
        if (!world.field_72995_K) {
            int z;
            double R = 7.0;
            double RY = 6.0;
            int x = (MathHelper.func_76128_c((double)posX) >> 4 << 4) + 4;
            int xmid = x + 4;
            int y = (MathHelper.func_76128_c((double)posY) >> 4 << 4) + 8;
            BlockPos pos = new BlockPos(x, y, z = (MathHelper.func_76128_c((double)posZ) >> 4 << 4) + 8);
            if (world.func_180495_p(pos).func_177230_c() == WitcheryBlocks.UNBREAKABLE_MIRROR) {
                TileEntityMirror tile;
                AxisAlignedBB bounds = new AxisAlignedBB((double)xmid - R, (double)y - RY, (double)z - R, (double)xmid + R, (double)y + RY, (double)z + R);
                List reflections = world.func_72872_a(EntityReflection.class, bounds);
                int livingDemons = 0;
                for (EntityReflection entity : reflections) {
                    if (entity == null || !entity.func_70089_S()) continue;
                    ++livingDemons;
                }
                if (livingDemons == 0 && (tile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)world, pos)) != null) {
                    BlockPos dimCoords = tile.getDimCoords();
                    int dim = tile.dim;
                    WorldServer otherWorld = world.func_73046_m().func_71218_a(dim);
                    TileEntityMirror otherTile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)otherWorld, dimCoords);
                    if (otherTile != null) {
                        otherTile.demonKilled = true;
                    }
                }
            }
        }
    }

    private boolean isTransportableEntity(Entity entity) {
        return !(entity instanceof EntityMirrorFace) && (entity instanceof EntityLivingBase || entity instanceof EntityItem);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!this.unbreakable) {
            IBlockState i1 = world.func_180495_p(pos);
            if (!BlockMirror.isBlockTopOfMirror(i1) && world.func_180495_p(pos = pos.func_177984_a()).func_177230_c() != this) {
                return true;
            }
            TileEntityMirror tile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)world, pos);
            if (tile == null) {
                return true;
            }
            tile.depolyDemon(player, hand);
        }
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public AxisAlignedBB getServerSelectedBoundingBoxFromPool(World world, BlockPos pos) {
        EnumFacing side = BlockMirror.getDirection(world.func_180495_p(pos));
        float w = 0.32f;
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        switch (side) {
            case NORTH: {
                minZ = 0.68f;
                break;
            }
            case SOUTH: 
            case EAST: {
                maxZ = w;
                break;
            }
            case WEST: {
                minX = 0.68f;
            }
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return new AxisAlignedBB((double)((float)x + minX), (double)((float)y + minY), (double)((float)z + minZ), (double)((float)x + maxX), (double)((float)y + maxY), (double)((float)z + maxZ));
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (BlockMirror.isBlockTopOfMirror(state) && te instanceof TileEntityMirror) {
            BlockMirror.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.getDrop(worldIn, (TileEntityMirror)te));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.func_180495_p(fromPos).func_177230_c() != this) {
            if (BlockMirror.isBlockTopOfMirror(state)) {
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
                    if (!world.field_72995_K) {
                        this.func_176226_b(world, pos, state, 0);
                    }
                    world.func_175698_g(pos);
                }
            } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                world.func_175698_g(pos);
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound nbtRoot;
        TileEntityMirror tile;
        super.func_180633_a(world, pos, state, placer, stack);
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        BlockPos top = pos.func_177984_a();
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)), 2);
        world.func_180501_a(top, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)), 2);
        if (!world.field_72995_K && (tile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)world, top)) != null && (nbtRoot = stack.func_77978_p()) != null) {
            tile.readItemDataFromNBT(nbtRoot);
            if (!WitcheryDimensions.MIRROR.isCurrentDimension(world) && tile.isDimLinked()) {
                TileEntityMirror otherTile;
                BlockPos dimCoords = tile.getDimCoords();
                WorldServer otherWorld = placer.func_184102_h().func_71218_a(WitcheryDimensions.MIRROR.getType().func_186068_a());
                if (otherWorld.func_180495_p(dimCoords).func_177230_c() == WitcheryBlocks.UNBREAKABLE_MIRROR && (otherTile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)otherWorld, dimCoords)) != null) {
                    otherTile.isConnected = true;
                    otherTile.dimCoords = top;
                    otherTile.notifyBlockUpdate(false);
                }
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess access, BlockPos pos, IBlockState state, int fortune) {
        TileEntityMirror tile;
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && (tile = WitcheryTileEntities.MIRROR.getAt(access, pos)) != null) {
            drops.add((Object)this.getDrop(access instanceof World ? (World)access : null, tile));
        }
    }

    private ItemStack getDrop(World world, TileEntityMirror tile) {
        ItemStack stack = new ItemStack((Block)this);
        NBTTagCompound nbtRoot = new NBTTagCompound();
        tile.writeItemDataToNBT(nbtRoot);
        stack.func_77982_d(nbtRoot);
        if (world != null && !WitcheryDimensions.MIRROR.isCurrentDimension(world) && tile.isDimLinked()) {
            TileEntityMirror otherTile;
            BlockPos dimCoords = tile.getDimCoords();
            WorldServer otherWorld = world.func_73046_m().func_71218_a(WitcheryDimensions.MIRROR.getType().func_186068_a());
            if (otherWorld.func_180495_p(dimCoords).func_177230_c() == WitcheryBlocks.MIRROR && (otherTile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)otherWorld, dimCoords)) != null) {
                otherTile.isConnected = false;
                otherTile.notifyBlockUpdate(false);
            }
        }
        return stack;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            meta |= 4;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING, TOP}).build();
    }

    @javax.annotation.Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.MIRROR.create();
    }
}

