/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityPlacedItem;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;

public class BlockPlacedItem
extends BlockContainer {
    public static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.05f, (double)0.8f);
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockPlacedItem() {
        super(Material.field_151578_c);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public static void placeInWorld(EnumHand hand, EntityPlayer player, World world, BlockPos pos) {
        if (world.func_175656_a(pos, WitcheryBlocks.PLACED_ITEM.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)player.func_174811_aO().func_176734_d()))) {
            TileEntityPlacedItem entity;
            ItemStack stack = player.func_184586_b(hand);
            ItemStack item = stack.func_77946_l();
            item.func_190920_e(1);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if ((entity = WitcheryTileEntities.PLACED_ITEM.getAt((IBlockAccess)world, pos)) != null) {
                entity.initialize(item);
            }
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71020_j(0.005f);
        if (te instanceof TileEntityPlacedItem) {
            BlockPlacedItem.func_180635_a((World)world, (BlockPos)pos, (ItemStack)((TileEntityPlacedItem)te).getStack());
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(worldIn, pos) && !worldIn.field_72995_K) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntityPlacedItem item = WitcheryTileEntities.PLACED_ITEM.getAt((IBlockAccess)world, pos);
        return item == null ? ItemStack.field_190927_a : new ItemStack(item.stack.func_77973_b(), 1, item.stack.func_77952_i());
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        Material material = world.func_180495_p(down).func_185904_a();
        return !world.func_175623_d(down) && material.func_76218_k() && material.func_76220_a();
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return WitcheryTileEntities.PLACED_ITEM.create();
    }
}

