/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.brews.ItemInkBrew;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class BlockPlantMine
extends BlockBush {
    private final MineEffect effect;

    public BlockPlantMine(MineEffect effect) {
        super(Material.field_151585_k);
        this.func_149711_c(6.0f);
        this.func_149752_b(1000.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(WitcheryGeneralItems.TAB);
        this.effect = effect;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
            world.func_184148_a(null, 0.5 + (double)pos.func_177958_n(), 0.05 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), SoundEvents.field_187539_bB, entity.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)pos.func_177958_n(), 0.05 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), 0.5f, 1.0f, EnumParticleTypes.CRIT_MAGIC), world, pos);
            this.effect.apply(world, pos, entity);
        }
    }

    public Item func_180660_a(IBlockState par1, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public static enum Variant {
        ROSE,
        DANDELION,
        DEAD_BUSH;

        public static final Variant[] VALUES;

        static {
            VALUES = Variant.values();
        }
    }

    @FunctionalInterface
    public static interface MineEffect {
        public static final MineEffect WEBS = (world, pos, entity) -> EntityWitchProjectile.explodeWeb(world, pos, EnumFacing.UP, false);
        public static final MineEffect INK = (world, pos, entity) -> ItemInkBrew.Companion.impactInk(world, pos, entity, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)), false);
        public static final MineEffect THORNS = (world, pos, entity) -> EntityWitchProjectile.plantCactus(world, pos, 4);
        public static final MineEffect SPROUTING = (world, pos, entity) -> EntityWitchProjectile.growBranch(pos, world, EnumFacing.UP, 10, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));

        public void apply(World var1, BlockPos var2, Entity var3);
    }
}

