/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.msrandom.witchery.block.WitcheryBlockDoor;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JP\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010!\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u0005H\u0002\u00a8\u0006#"}, d2={"Lnet/msrandom/witchery/block/BlockRowanDoor;", "Lnet/msrandom/witchery/block/WitcheryBlockDoor;", "()V", "getDrops", "", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "fortune", "", "hasKeyForDoor", "", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onBlockActivated", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "onBlockHarvested", "", "testDoor", "door", "Lnet/minecraft/nbt/NBTTagCompound;", "testKey", "stack", "WitcheryResurrected"})
public final class BlockRowanDoor
extends WitcheryBlockDoor {
    public boolean func_180639_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(hand, "hand");
        Intrinsics.checkParameterIsNotNull(facing, "facing");
        return this.hasKeyForDoor(world, pos, state, player) && super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_176208_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(player, "player");
        if (!player.field_71075_bZ.field_75098_d) {
            ItemStack stack = this.hasKeyForDoor(world, pos, state, player) ? this.func_185473_a(world, pos, state) : new ItemStack(Items.field_151055_y, 8);
            double f = 0.7;
            double d = 0.15002830246369595;
            double x = world.field_73012_v.nextDouble() * f + d;
            double y = world.field_73012_v.nextDouble() * f + d;
            double z = world.field_73012_v.nextDouble() * f + d;
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + z, stack);
            item.func_174869_p();
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)item);
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        return CollectionsKt.emptyList();
    }

    private final boolean hasKeyForDoor(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        ItemStack itemStack = player.func_184586_b(EnumHand.OFF_HAND);
        boolean bl = false;
        int n = 0;
        ItemStack it = itemStack;
        boolean bl2 = false;
        ItemStack itemStack2 = it;
        Intrinsics.checkExpressionValueIsNotNull(itemStack2, "it");
        if (this.testKey(world, state, pos, itemStack2)) {
            return true;
        }
        itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        bl = false;
        n = 0;
        it = itemStack;
        boolean bl3 = false;
        ItemStack itemStack3 = it;
        Intrinsics.checkExpressionValueIsNotNull(itemStack3, "it");
        if (this.testKey(world, state, pos, itemStack3)) {
            return true;
        }
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        Intrinsics.checkExpressionValueIsNotNull(inventoryPlayer, "player.inventory");
        IInventory $this$forEach$iv = (IInventory)inventoryPlayer;
        boolean $i$f$forEach = false;
        n = $this$forEach$iv.func_70302_i_();
        boolean bl4 = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            ItemStack it2;
            int it$iv = n2;
            boolean bl5 = false;
            Intrinsics.checkExpressionValueIsNotNull($this$forEach$iv.func_70301_a(it$iv), "getStackInSlot(it)");
            boolean bl6 = false;
            if (it2.func_190926_b() || !this.testKey(world, state, pos, it2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean testKey(World world, IBlockState state, BlockPos pos, ItemStack stack) {
        NBTTagCompound data2;
        if (stack.func_77973_b() == WitcheryIngredientItems.DOOR_KEY) {
            return this.testDoor(world, state, pos, WitcheryUtils.getOrCreateTag(stack));
        }
        if (stack.func_77973_b() == WitcheryIngredientItems.DOOR_KEYRING && (data2 = WitcheryUtils.getOrCreateTag(stack)).func_74764_b("Keys")) {
            NBTTagList keyList = data2.func_150295_c("Keys", 10);
            int n = 0;
            int n2 = keyList.func_74745_c();
            while (n < n2) {
                void j;
                NBTTagCompound nBTTagCompound = keyList.func_150305_b((int)j);
                Intrinsics.checkExpressionValueIsNotNull(nBTTagCompound, "keyList.getCompoundTagAt(j)");
                if (this.testDoor(world, state, pos, nBTTagCompound)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean testDoor(World world, IBlockState state, BlockPos pos, NBTTagCompound door) {
        if (!door.func_74764_b("Dimension")) return false;
        if (door.func_74762_e("X") != pos.func_177958_n()) return false;
        if (door.func_74762_e("Y") + ((BlockDoor.EnumDoorHalf)state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? 1 : 0) != pos.func_177956_o()) return false;
        if (door.func_74762_e("Z") != pos.func_177952_p()) return false;
        int n = door.func_74762_e("Dimension");
        WorldProvider worldProvider = world.field_73011_w;
        Intrinsics.checkExpressionValueIsNotNull(worldProvider, "world.provider");
        if (n != worldProvider.getDimension()) return false;
        return true;
    }

    public BlockRowanDoor() {
        Material material = Material.field_151575_d;
        Intrinsics.checkExpressionValueIsNotNull(material, "Material.WOOD");
        super(material);
        this.func_149711_c(5.0f);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }
}

