/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntitySilverVat;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import org.jetbrains.annotations.Nullable;

public class BlockSilverVat
extends BlockContainer {
    public static final ItemStack GOLD_INGOT = new ItemStack(Items.field_151043_k);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.64f, 1.0);

    public BlockSilverVat() {
        super(Material.field_151573_f);
        this.func_149647_a(WitcheryGeneralItems.TAB);
        this.func_149711_c(8.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)tile));
        }
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack stack;
            TileEntitySilverVat tile = WitcheryTileEntities.SILVER_VAT.getAt((IBlockAccess)world, pos);
            if (tile != null && !(stack = tile.func_70301_a(0)).func_190926_b()) {
                double motion;
                EntityItem entity = new EntityItem(world, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, stack);
                entity.field_70179_y = motion = 0.0;
                entity.field_70181_x = motion;
                entity.field_70159_w = motion;
                world.func_72838_d((Entity)entity);
                tile.func_70299_a(0, ItemStack.field_190927_a);
                tile.notifyBlockUpdate(true);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        block9: {
            TileEntitySilverVat vat;
            if (!(pos.func_177956_o() != neighbor.func_177956_o() || pos.func_177958_n() != neighbor.func_177958_n() && pos.func_177952_p() != neighbor.func_177952_p() || (vat = WitcheryTileEntities.SILVER_VAT.getAt(world, pos)) == null || vat.reenterLock)) {
                vat.reenterLock = true;
                try {
                    TileEntity tile = world.func_175625_s(neighbor);
                    if (!(tile instanceof ISidedInventory)) break block9;
                    ISidedInventory inv = (ISidedInventory)tile;
                    int offsetX = pos.func_177958_n() - neighbor.func_177952_p();
                    int offsetZ = pos.func_177952_p() - neighbor.func_177952_p();
                    EnumFacing side = offsetX == 0 ? (offsetZ > 0 ? EnumFacing.SOUTH : EnumFacing.NORTH) : (offsetX > 0 ? EnumFacing.EAST : EnumFacing.WEST);
                    for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                        ItemStack stack;
                        if (!inv.func_180461_b(slot, GOLD_INGOT, side) || inv.func_180462_a(slot, GOLD_INGOT, side) || (stack = inv.func_70301_a(slot)).func_190926_b() || stack.func_77973_b() != Items.field_151043_k) continue;
                        if (stack.func_190916_E() > vat.getLastStackSizeForSide(side) && vat.func_145831_w().field_73012_v.nextInt(5) == 0) {
                            ItemStack silver = vat.func_70301_a(0);
                            if (silver.func_190926_b()) {
                                silver = new ItemStack(WitcheryIngredientItems.SILVER_DUST);
                                vat.func_70299_a(0, silver);
                                vat.notifyBlockUpdate(true);
                            } else if (silver.func_190916_E() < silver.func_77976_d()) {
                                silver.func_190917_f(1);
                                vat.notifyBlockUpdate(true);
                            }
                        }
                        vat.setLastStackSizeForSide(side, stack.func_190916_E());
                        break;
                    }
                }
                finally {
                    vat.reenterLock = false;
                }
            }
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.SILVER_VAT.create();
    }
}

