/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.WorldProviderSpiritWorld;

public class BlockSpiritPortal
extends BlockBreakable {
    private static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private final Block portalFrameBlock;

    public BlockSpiritPortal(Block portalFrameBlock) {
        super(Material.field_151567_E, false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
        this.func_149675_a(true);
        this.portalFrameBlock = portalFrameBlock;
        this.func_149711_c(-1.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{AXIS}).build();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a(AXIS, (Comparable)(world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(AXIS) == EnumFacing.Axis.X ? X_AABB : Z_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World par1World, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int b0 = 0;
        int b2 = 1;
        if (par1World.func_180495_p(pos.func_177976_e()).func_177230_c() == this || par1World.func_180495_p(pos.func_177974_f()).func_177230_c() == this) {
            b0 = 1;
            b2 = 0;
        }
        BlockPos i1 = pos;
        while (par1World.func_180495_p(i1.func_177977_b()).func_177230_c() == this) {
            i1 = i1.func_177977_b();
        }
        if (par1World.func_180495_p(i1.func_177977_b()).func_177230_c() != this.portalFrameBlock) {
            par1World.func_175698_g(pos);
        } else {
            int j1;
            for (j1 = 1; j1 < 3 && par1World.func_180495_p(i1.func_177981_b(j1)).func_177230_c() == this; ++j1) {
            }
            if (j1 == 2 && par1World.func_180495_p(i1.func_177981_b(j1)).func_177230_c() == this.portalFrameBlock) {
                boolean flag2;
                boolean flag = par1World.func_180495_p(pos.func_177976_e()).func_177230_c() == this || par1World.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
                boolean bl = flag2 = par1World.func_180495_p(pos.func_177978_c()).func_177230_c() == this || par1World.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
                if (flag && flag2) {
                    par1World.func_175698_g(pos);
                } else if (par1World.func_180495_p(pos.func_177982_a(b0, 0, b2)).func_177230_c() != this.portalFrameBlock && par1World.func_180495_p(pos.func_177982_a(-b0, 0, -b2)).func_177230_c() != this.portalFrameBlock) {
                    par1World.func_175698_g(pos);
                }
            } else {
                par1World.func_175698_g(pos);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess par1IBlockAccess, BlockPos pos, EnumFacing par5) {
        if (par1IBlockAccess.func_180495_p(pos).func_177230_c() == this) {
            return false;
        }
        boolean flag = par1IBlockAccess.func_180495_p(pos.func_177976_e()).func_177230_c() == this && par1IBlockAccess.func_180495_p(pos.func_177985_f(2)).func_177230_c() != this;
        boolean flag2 = par1IBlockAccess.func_180495_p(pos.func_177974_f()).func_177230_c() == this && par1IBlockAccess.func_180495_p(pos.func_177965_g(2)).func_177230_c() != this;
        boolean flag3 = par1IBlockAccess.func_180495_p(pos.func_177978_c()).func_177230_c() == this && par1IBlockAccess.func_180495_p(pos.func_177964_d(2)).func_177230_c() != this;
        boolean flag4 = par1IBlockAccess.func_180495_p(pos.func_177968_d()).func_177230_c() == this && par1IBlockAccess.func_180495_p(pos.func_177970_e(2)).func_177230_c() != this;
        boolean flag5 = flag || flag2;
        boolean flag6 = flag3 || flag4;
        return flag5 && par5 == EnumFacing.WEST || flag5 && par5 == EnumFacing.EAST || flag6 && par5 == EnumFacing.NORTH || flag6 && par5 == EnumFacing.SOUTH;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer && WitcheryDimensions.SPIRIT_WORLD.isInDimension(entity) && entity.func_184187_bx() == null && entity.func_184188_bt().isEmpty() && WitcheryUtils.getExtension((EntityPlayer)entity).getSpiritData().getManifestationDuration() >= 5) {
            WorldProviderSpiritWorld.manifestPlayerInOverworldAsGhost((EntityPlayer)entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World par1World, BlockPos pos, Random par5Random) {
        for (int l = 0; l < 2; ++l) {
            double d0 = (float)pos.func_177958_n() + par5Random.nextFloat();
            double d2 = (float)pos.func_177956_o() + par5Random.nextFloat();
            double d3 = (float)pos.func_177952_p() + par5Random.nextFloat();
            int i1 = par5Random.nextInt(2) * 2 - 1;
            double d4 = ((double)par5Random.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)par5Random.nextFloat() - 0.5) * 0.5;
            double d6 = ((double)par5Random.nextFloat() - 0.5) * 0.5;
            if (par1World.func_180495_p(pos.func_177976_e()).func_177230_c() != this && par1World.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)i1;
                d4 = par5Random.nextFloat() * 2.0f * (float)i1;
            } else {
                d3 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)i1;
                d6 = par5Random.nextFloat() * 2.0f * (float)i1;
            }
            par1World.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d2, d3, d4, d5, d6, new int[0]);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public boolean tryToCreatePortal(World par1World, BlockPos pos) {
        int i1;
        int l;
        int b0 = 0;
        int b2 = 0;
        if (par1World.func_180495_p(pos.func_177976_e()).func_177230_c() == this.portalFrameBlock || par1World.func_180495_p(pos.func_177974_f()).func_177230_c() == this.portalFrameBlock) {
            b0 = 1;
        }
        if (par1World.func_180495_p(pos.func_177978_c()).func_177230_c() == this.portalFrameBlock || par1World.func_180495_p(pos.func_177968_d()).func_177230_c() == this.portalFrameBlock) {
            b2 = 1;
        }
        if (b0 == b2) {
            return false;
        }
        if (par1World.func_175623_d(pos.func_177982_a(-b0, 0, -b2))) {
            pos = pos.func_177982_a(-b0, 0, -b2);
        }
        int WIDTH = 2;
        int HEIGHT = 2;
        for (l = -1; l <= 2; ++l) {
            for (i1 = -1; i1 <= HEIGHT; ++i1) {
                boolean flag;
                boolean bl = flag = l == -1 || l == WIDTH || i1 == -1 || i1 == WIDTH;
                if ((l == -1 || l == HEIGHT) && (i1 == -1 || i1 == HEIGHT)) continue;
                BlockPos p = pos.func_177982_a(b0 * l, i1, b2 * l);
                Block j1 = par1World.func_180495_p(p).func_177230_c();
                boolean isAirBlock = par1World.func_175623_d(p);
                if (!(flag ? j1 != this.portalFrameBlock : !isAirBlock && j1 != WitcheryBlocks.FLOWING_SPIRIT)) continue;
                return false;
            }
        }
        for (l = 0; l < 2; ++l) {
            for (i1 = 0; i1 < 2; ++i1) {
                par1World.func_180501_a(pos.func_177982_a(b0 * l, i1, b2 * l), this.func_176223_P(), 2);
            }
        }
        return true;
    }
}

