/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityWorshipStatue;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ItemQuartzGrenade;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import org.jetbrains.annotations.Nullable;

public class BlockStatueOfWorship
extends BlockContainer {
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockStatueOfWorship() {
        super(Material.field_151576_e);
        this.func_149647_a(WitcheryGeneralItems.TAB);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(3.5f);
        this.func_149752_b(20.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    private static UUID getBoundPlayer(ItemStack stack) {
        NBTTagCompound nbtRoot = stack.func_77978_p();
        if (nbtRoot != null) {
            return nbtRoot.func_186857_a("BoundPlayer");
        }
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        UUID playerName;
        NBTTagCompound nbtRoot;
        TileEntityWorshipStatue tile;
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d()));
        if (!stack.func_190926_b() && placer instanceof EntityPlayer && (tile = WitcheryTileEntities.WORSHIP_STATUE.getAt((IBlockAccess)worldIn, pos)) != null && (nbtRoot = stack.func_77978_p()) != null && nbtRoot.func_186855_b("BoundPlayer") && (playerName = nbtRoot.func_186857_a("BoundPlayer")) != null) {
            tile.setOwnerId(playerName);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityWorshipStatue tile = WitcheryTileEntities.WORSHIP_STATUE.getAt(world, pos);
        if (tile != null) {
            ItemStack stack = new ItemStack((Block)this);
            NBTTagCompound nbtRoot = new NBTTagCompound();
            stack.func_77982_d(nbtRoot);
            if (tile.getOwnerId() != null) {
                nbtRoot.func_186854_a("BoundPlayer", tile.getOwnerId());
            }
            drops.add((Object)stack);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int worshippers;
            TileEntityWorshipStatue tile;
            ItemStack item = player.func_184586_b(hand);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (item.func_77973_b() == Items.field_151156_bN && (tile = WitcheryTileEntities.WORSHIP_STATUE.getAt((IBlockAccess)world, pos)) != null && tile.getOwnerId() != null && tile.getOwnerId().equals(player.func_110124_au()) && (worshippers = tile.updateWorshippersAndGetLevel()) >= 5 && tile.summonGoblinGods(player, 16.0, 8)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    item.func_190918_g(1);
                    double R = 8.0;
                    AxisAlignedBB bb = new AxisAlignedBB((double)x + 0.5 - R, (double)y + 0.5 - R, (double)z + 0.5 - R, (double)x + 0.5 + R, (double)y + 0.5 + R, (double)z + 0.5 + R);
                    List entities = world.func_72872_a(EntityGoblin.class, bb);
                    int iMax = Math.min(entities.size(), 5);
                    for (int i = 0; i < iMax; ++i) {
                        EntityGoblin goblin = (EntityGoblin)entities.get(i);
                        goblin.func_70097_a(DamageSource.field_76376_m, goblin.func_110138_aP());
                    }
                }
                world.func_184148_a(null, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, SoundEvents.field_187525_aO, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 0.5f, 0.5f, EnumParticleTypes.FLAME), world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z);
                return true;
            }
            world.func_184148_a(null, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, SoundEvents.field_187688_dI, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z);
        }
        return false;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.WORSHIP_STATUE.create();
    }

    public static class ClassItemBlock
    extends ItemBlock {
        public ClassItemBlock(Block block) {
            super(block);
        }

        public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
            super.func_77624_a(stack, world, tooltip, flag);
            UUID boundPlayer = BlockStatueOfWorship.getBoundPlayer(stack);
            if (world != null && boundPlayer != null) {
                EntityPlayer player;
                String name2 = ItemQuartzGrenade.NAME_CACHE.get(boundPlayer);
                if (name2 == null && (player = world.func_152378_a(boundPlayer)) != null) {
                    name2 = player.func_70005_c_();
                    ItemQuartzGrenade.NAME_CACHE.put(boundPlayer, name2);
                }
                if (name2 != null) {
                    tooltip.add(TextFormatting.LIGHT_PURPLE + name2);
                }
            }
        }
    }
}

