/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class BlockSunCollector
extends Block {
    private static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.8f, (double)0.8f);
    private static final EnumFacing[] HORIZONTAL = EnumFacing.field_176754_o;

    public BlockSunCollector() {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int meta;
        if (!world.field_72995_K && (meta = ((Integer)state.func_177229_b((IProperty)POWER)).intValue()) > 0 && meta < 15) {
            for (EnumFacing direction : HORIZONTAL) {
                BlockPos other = pos.func_177972_a(direction);
                IBlockState otherState = world.func_180495_p(other);
                Block otherBlock = otherState.func_177230_c();
                if (!(otherBlock instanceof BlockDaylightDetector)) continue;
                int power = otherState.func_185911_a((IBlockAccess)world, other, direction);
                if (power != meta + 1) break;
                world.func_180501_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta + 1)), 3);
                break;
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int meta = (Integer)state.func_177229_b((IProperty)POWER);
            if (meta == 0) {
                ItemStack stack = player.func_184586_b(hand);
                if (stack.func_77973_b() == WitcheryIngredientItems.QUARTZ_SPHERE) {
                    stack.func_190918_g(1);
                    world.func_180501_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(1)), 3);
                }
            } else if (meta < 15) {
                player.func_71019_a(new ItemStack(WitcheryIngredientItems.QUARTZ_SPHERE), false);
                world.func_180501_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)), 3);
            } else if (meta == 15) {
                player.func_71019_a(new ItemStack((Item)WitcheryGeneralItems.SUN_GRENADE), false);
                world.func_180501_a(pos, state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)), 3);
            }
            return true;
        }
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{POWER}).build();
    }
}

