/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.world.dimension.torment.TormentWorldData;
import net.msrandom.witchery.world.dimension.torment.WorldProviderTorment;

public class BlockTormentPortal
extends BlockBreakable {
    private static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private static final double MORE_TORMENT_CHANCE = 0.05;

    public BlockTormentPortal() {
        super(Material.field_151567_E, false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
        this.func_149675_a(true);
        this.func_149722_s();
        this.func_149752_b(9999.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.75f);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{AXIS}).build();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a(AXIS, (Comparable)(world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150350_a && world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150350_a ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            default: {
                return X_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        worldIn.func_175656_a(pos, this.func_176221_a(state, (IBlockAccess)worldIn, pos));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (world.func_180495_p(pos).func_177230_c() == this) {
            return false;
        }
        boolean west = world.func_180495_p(pos.func_177976_e()).func_177230_c() == this && world.func_180495_p(pos.func_177985_f(2)).func_177230_c() != this;
        boolean east = world.func_180495_p(pos.func_177974_f()).func_177230_c() == this && world.func_180495_p(pos.func_177965_g(2)).func_177230_c() != this;
        boolean north = world.func_180495_p(pos.func_177978_c()).func_177230_c() == this && world.func_180495_p(pos.func_177964_d(2)).func_177230_c() != this;
        boolean south = world.func_180495_p(pos.func_177968_d()).func_177230_c() == this && world.func_180495_p(pos.func_177970_e(2)).func_177230_c() != this;
        boolean xAxis = west || east;
        boolean zAxis = north || south;
        return xAxis && side.func_176740_k() == EnumFacing.Axis.X || zAxis && side.func_176740_k() == EnumFacing.Axis.Z;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer && entity.func_184187_bx() == null && entity.func_184188_bt().isEmpty()) {
            if (!WitcheryDimensions.TORMENT.isInDimension(entity) || world.field_73012_v.nextDouble() < 0.05) {
                WorldProviderTorment.setPlayerMustTorment((EntityPlayer)entity, TormentWorldData.TormentType.BEGIN, 1);
            } else {
                WorldProviderTorment.setPlayerMustTorment((EntityPlayer)entity, TormentWorldData.TormentType.END, 0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        if (random.nextInt(100) == 0) {
            world.func_184133_a(null, pos, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f);
        }
        for (int l = 0; l < 2; ++l) {
            double d0 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            world.func_175688_a(EnumParticleTypes.FLAME, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }
}

