/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityVoidBramble;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.TeleportationUtil;

public class BlockVoidBramble
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.050000011920928955, 0.0, 0.050000011920928955, (double)0.95f, 1.0, (double)0.95f);

    public BlockVoidBramble() {
        super(Material.field_151585_k);
        this.func_149722_s();
        this.func_149752_b(1000.0f);
        this.func_149715_a(0.125f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    public static void teleportRandomly(World world, BlockPos pos, Entity entity, int distance) {
        int doubleDistance = distance * 2;
        pos = pos.func_177982_a(world.field_73012_v.nextInt(doubleDistance) - distance, 0, world.field_73012_v.nextInt(doubleDistance) - distance);
        int maxY = Math.min(pos.func_177956_o() + 64, 250);
        while (!world.func_180495_p(pos).func_185904_a().func_76220_a() && pos.func_177956_o() >= 0) {
            pos = pos.func_177977_b();
        }
        while (!(world.func_180495_p(pos).func_185904_a().func_76220_a() && world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(pos.func_177981_b(2)) && world.func_175623_d(pos.func_177981_b(3)) || pos.func_177956_o() >= maxY)) {
            pos = pos.func_177984_a();
        }
        if (pos.func_177956_o() > 0 && pos.func_177956_o() < maxY) {
            TeleportationUtil.teleportToLocation(pos.func_177984_a(), world.field_73011_w.getDimension(), entity, true);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase) {
            BlockVoidBramble.teleportRandomly(world, pos, entity, 500);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (rand.nextBoolean()) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d2 = (double)((float)pos.func_177956_o() + 0.15f + rand.nextFloat() * 0.3f) + 0.5;
            double d3 = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.PORTAL, d0, d2, d3, 0.0, -1.2, 0.0, new int[0]);
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntityVoidBramble tile;
        if (!world.field_72995_K && (tile = WitcheryTileEntities.VOID_BRAMBLE.getAt((IBlockAccess)world, pos)) != null && (player.field_71075_bZ.field_75098_d || player.func_70005_c_().equals(tile.getOwner()))) {
            BlockPos dy = pos;
            while (world.func_180495_p(dy).func_177230_c() == this) {
                world.func_175698_g(dy);
                world.func_72838_d((Entity)new EntityItem(world, 0.5 + (double)dy.func_177958_n(), 0.5 + (double)dy.func_177956_o(), 0.5 + (double)dy.func_177952_p(), new ItemStack((Block)this)));
                dy = dy.func_177984_a();
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            TileEntityVoidBramble tile = WitcheryTileEntities.VOID_BRAMBLE.getAt((IBlockAccess)world, pos);
            if (tile != null) {
                tile.setOwner(player.func_70005_c_());
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata2) {
        return WitcheryTileEntities.VOID_BRAMBLE.create();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

