/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Random;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityCauldron;
import net.msrandom.witchery.brewing.EffectLevelCounter;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.ModifierYield;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.client.particle.ParticleCauldronBubble;
import net.msrandom.witchery.client.particle.ParticleNaturePower;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryFluids;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemBrewBottle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.resources.BrewActionManager;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.util.damage.BoilDamageSource;
import org.jetbrains.annotations.Nullable;

public class BlockWitchCauldron
extends BlockContainer {
    private static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)3);
    private static final AxisAlignedBB NORMAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.85f, 1.0);
    private static final AxisAlignedBB BOTTOM = WitcheryUtils.getBlockShape(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final AxisAlignedBB NORTH = WitcheryUtils.getBlockShape(1.0, 0.0, 1.0, 15.0, 14.0, 2.0);
    private static final AxisAlignedBB SOUTH = WitcheryUtils.getBlockShape(1.0, 0.0, 14.0, 15.0, 14.0, 15.0);
    private static final AxisAlignedBB EAST = WitcheryUtils.getBlockShape(14.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final AxisAlignedBB WEST = WitcheryUtils.getBlockShape(1.0, 0.0, 1.0, 2.0, 14.0, 15.0);
    private static final AxisAlignedBB[] INSIDE_AABB = new AxisAlignedBB[]{WitcheryUtils.getBlockShape(2.0, 1.0, 2.0, 14.0, 5.0, 14.0), WitcheryUtils.getBlockShape(2.0, 1.0, 2.0, 14.0, 9.0, 14.0), WitcheryUtils.getBlockShape(2.0, 1.0, 2.0, 14.0, 13.0, 14.0)};

    public BlockWitchCauldron() {
        super(Material.field_151573_f);
        this.func_149647_a(WitcheryGeneralItems.TAB);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    private static ItemStack consumeItem(ItemStack stack) {
        if (stack.func_190916_E() != 1) {
            return stack.func_77979_a(1);
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return stack.func_77973_b().getContainerItem(stack);
        }
        return ItemStack.field_190927_a;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return NORMAL_AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @javax.annotation.Nullable Entity entityIn, boolean isActualState) {
        BlockWitchCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOTTOM);
        BlockWitchCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST);
        BlockWitchCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH);
        BlockWitchCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST);
        BlockWitchCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos position) {
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt(world, position);
        if (cauldron != null) {
            int level = MathKt.roundToInt(cauldron.getPercentFilled() * 3.0);
            if (cauldron.getLiquidQuantity() != 0 && level == 0) {
                level = 1;
            }
            if (cauldron.getLiquidQuantity() != 3000 && level == 3) {
                level = 2;
            }
            state = state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(level));
        }
        return super.func_176221_a(state, world, position);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
        if (cauldron != null && cauldron.isBoiling()) {
            double zPos;
            double xPos;
            double width;
            int i;
            double yPos = cauldron.getPercentFilled() * 0.5 + 0.2;
            int color2 = cauldron.getColor();
            if (color2 == -1) {
                color2 = 3694022;
            } else if (rand.nextInt(5) == 0) {
                world.func_184133_a(null, pos, WitcherySounds.BLOCK_CAULDRON_BLOP, SoundCategory.BLOCKS, 0.8f + rand.nextFloat() * 0.2f, 0.8f + rand.nextFloat() * 0.2f);
            }
            float red = (float)(color2 >>> 16 & 0xFF) / 256.0f;
            float green = (float)(color2 >>> 8 & 0xFF) / 256.0f;
            float blue = (float)(color2 & 0xFF) / 256.0f;
            for (i = 0; i < 2; ++i) {
                width = 0.6;
                xPos = 0.2 + rand.nextDouble() * width;
                zPos = 0.2 + rand.nextDouble() * width;
                ParticleCauldronBubble sparkle = new ParticleCauldronBubble(world, (double)pos.func_177958_n() + xPos, (double)pos.func_177956_o() + yPos, (double)pos.func_177952_p() + zPos);
                sparkle.setScale(0.4f);
                if (rand.nextInt(4) == 0) {
                    sparkle.setGravity(-0.02f);
                    sparkle.setCanMove(true);
                    sparkle.func_187114_a(15 + rand.nextInt(10));
                } else {
                    sparkle.setGravity(0.0f);
                    sparkle.setCanMove(false);
                    sparkle.func_187114_a(10 + rand.nextInt(10));
                }
                sparkle.func_70538_b(red, green, blue);
                sparkle.func_82338_g(0.2f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)sparkle);
            }
            if (cauldron.isPowered()) {
                for (i = 0; i < 1 + Math.min(cauldron.getRitualSeconds(), 5); ++i) {
                    width = 0.4;
                    xPos = 0.3 + rand.nextDouble() * width;
                    zPos = 0.3 + rand.nextDouble() * width;
                    double d0 = (double)pos.func_177958_n() + xPos;
                    double d2 = (double)pos.func_177956_o() + yPos;
                    double d3 = (double)pos.func_177952_p() + zPos;
                    double maxSpeed = 0.04;
                    double doubleSpeed = 0.08;
                    ParticleNaturePower sparkle2 = new ParticleNaturePower(world, d0, d2, d3, rand.nextDouble() * doubleSpeed - maxSpeed, rand.nextDouble() * 0.05 + 0.08, rand.nextDouble() * doubleSpeed - maxSpeed);
                    sparkle2.setCircling(cauldron.isRitualInProgress());
                    sparkle2.setScale(0.6f);
                    sparkle2.setGravity(0.25f);
                    sparkle2.setCanMove(true);
                    sparkle2.func_187114_a(25 + rand.nextInt(10));
                    float maxColorShift = 0.2f;
                    float doubleColorShift = maxColorShift * 2.0f;
                    float colorshiftR = rand.nextFloat() * doubleColorShift - maxColorShift;
                    float colorshiftG = rand.nextFloat() * doubleColorShift - maxColorShift;
                    float colorshiftB = rand.nextFloat() * doubleColorShift - maxColorShift;
                    sparkle2.func_70538_b(red + colorshiftR, green + colorshiftG, blue + colorshiftB);
                    sparkle2.func_82338_g(0.1f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)sparkle2);
                }
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityCauldron cauldron;
        if (!world.field_72995_K && (cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos)) != null) {
            if (entity instanceof EntityItem) {
                EntityItem itemEntity = (EntityItem)entity;
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                if (cauldron.isFilled()) {
                    BrewAction brewAction;
                    if (itemEntity.func_92059_d().func_77973_b() == WitcheryIngredientItems.GYPSUM) {
                        entity.func_70106_y();
                        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 2.0f);
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.6, (double)pos.func_177952_p() + 0.5, 0.5f, 1.0f, EnumParticleTypes.SMOKE_NORMAL), world, pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, pos.func_177952_p());
                        cauldron.drain(cauldron.getLiquidQuantity(), true);
                        cauldron.notifyBlockUpdate(true);
                    } else if (itemEntity.func_92059_d().func_77973_b() == WitcheryIngredientItems.QUICKLIME) {
                        EntityPlayer nearestPlayer = (EntityPlayer)world.func_72857_a(EntityPlayer.class, entity.func_174813_aQ().func_72321_a(5.0, 5.0, 5.0), entity);
                        if (nearestPlayer != null && cauldron.explodeBrew(nearestPlayer)) {
                            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.6, (double)pos.func_177952_p() + 0.5, 0.5f, 1.0f, EnumParticleTypes.SMOKE_NORMAL), world, pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, pos.func_177952_p());
                            cauldron.drain(cauldron.getLiquidQuantity(), true);
                            entity.func_70106_y();
                            cauldron.notifyBlockUpdate(true);
                        }
                    } else if (cauldron.isBoiling() && ((brewAction = BrewActionManager.INSTANCE.getAction(ItemKey.fromStack(itemEntity.func_92059_d()))) != null || cauldron.func_94041_b(-1, itemEntity.func_92059_d())) && cauldron.addItem(brewAction, itemEntity.func_92059_d())) {
                        Item containerItem = itemEntity.func_92059_d().func_77973_b().func_77668_q();
                        if (containerItem != null) {
                            world.func_72838_d((Entity)new EntityItem(world, 0.5 + (double)x, 1.0 + (double)y, 0.5 + (double)z, new ItemStack(containerItem)));
                        }
                        entity.func_70106_y();
                        world.func_184133_a(null, pos, SoundEvents.field_187806_ee, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.6, (double)pos.func_177952_p() + 0.5, 0.5f, 1.0f, EnumParticleTypes.SMOKE_NORMAL), world, pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, pos.func_177952_p());
                    }
                }
            } else if (entity instanceof EntityPlayer && cauldron.isBoiling() && entity.func_174813_aQ().func_72326_a(INSIDE_AABB[(Integer)state.func_177229_b((IProperty)LEVEL)].func_186670_a(pos))) {
                entity.func_70097_a((DamageSource)new BoilDamageSource(cauldron.getActions()), 1.0f);
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
        int signal = 0;
        if (cauldron != null) {
            return cauldron.getRedstoneSignalStrength();
        }
        return signal;
    }

    public boolean tryFillWith(World world, BlockPos pos, FluidStack fluidStack) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
        if (cauldron != null && cauldron.canFill(fluidStack.getFluid())) {
            int quantity = cauldron.fill(fluidStack, true);
            fluidStack.amount -= quantity;
            if (fluidStack.amount < 0) {
                fluidStack.amount = 0;
            }
            if (quantity > 0) {
                world.func_184133_a(null, pos, SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                cauldron.notifyBlockUpdate(true);
            }
            return quantity > 0;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
        ItemStack heldStack = player.func_184586_b(hand);
        if (cauldron == null || heldStack.func_190926_b()) return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        FluidStack fluidStackToFill = FluidUtil.getFluidContained((ItemStack)heldStack);
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldStack);
        if (fluidStackToFill != null) {
            int quantityFilled;
            if (world.field_72995_K) {
                return true;
            }
            if (!cauldron.canFill(fluidStackToFill.getFluid())) return true;
            if (heldStack.func_77942_o()) {
                fluidStackToFill.tag = heldStack.func_77978_p().func_74737_b();
            }
            if ((quantityFilled = cauldron.fill(fluidStackToFill, true)) == 0) return true;
            player.func_71029_a(StatList.field_188078_L);
            boolean drained = player.field_71075_bZ.field_75098_d;
            if (!drained) {
                ItemStack container = heldStack.func_77973_b().getContainerItem(heldStack);
                boolean bl = drained = handler != null && handler.drain(quantityFilled, true) != null;
                if (!container.func_190926_b()) {
                    heldStack.func_190918_g(1);
                    if (heldStack.func_190926_b()) {
                        player.func_184611_a(hand, container);
                    } else if (!player.field_71071_by.func_70441_a(container)) {
                        player.func_71019_a(container, false);
                    }
                }
            }
            if (!player.field_71075_bZ.field_75098_d && !drained) return true;
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            cauldron.notifyBlockUpdate(true);
            return true;
        }
        if (heldStack.func_77973_b() == Items.field_151068_bn && PotionUtils.func_185191_c((ItemStack)heldStack) == PotionTypes.field_185230_b) {
            if (world.field_72995_K) {
                return true;
            }
            if (cauldron.getLiquidQuantity() >= 3000 || !cauldron.getActions().actions.isEmpty()) return true;
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack stack = new ItemStack(Items.field_151069_bo);
                player.func_71029_a(StatList.field_188078_L);
                player.func_184611_a(hand, stack);
            }
            world.func_184133_a(null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
            cauldron.fill(new FluidStack(FluidRegistry.WATER, 334), true);
            return true;
        }
        FluidStack fluidStackInCauldron = cauldron.getTankProperties()[0].getContents();
        if (handler != null && handler.getTankProperties()[0].getContents() == null) {
            if (fluidStackInCauldron == null) return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            if (world.field_72995_K) {
                return true;
            }
            NBTTagCompound nbtFluid = cauldron.writeFluid(new NBTTagCompound());
            FluidStack drain = cauldron.drain(1000, !player.field_71075_bZ.field_75098_d);
            if (!player.field_71075_bZ.field_75098_d) {
                handler.fill(drain, true);
                if (heldStack.func_77973_b() == Items.field_151133_ar) {
                    if (fluidStackInCauldron.getFluid() == WitcheryFluids.BREW) {
                        if (WitcheryGeneralItems.BREW_BUCKET.getRegistryName() == null) return true;
                        ItemStack filledBucketStack = new ItemStack((Item)WitcheryGeneralItems.BREW_BUCKET);
                        player.func_71029_a(StatList.field_188078_L);
                        filledBucketStack.func_77982_d(nbtFluid.func_74737_b());
                        if (heldStack.func_190916_E() > 1) {
                            if (!player.field_71071_by.func_70441_a(filledBucketStack)) {
                                return false;
                            }
                            player.func_184611_a(hand, BlockWitchCauldron.consumeItem(heldStack));
                        } else {
                            player.func_184611_a(hand, filledBucketStack);
                        }
                    } else {
                        ItemStack filledBucketStack = FluidUtil.getFilledBucket((FluidStack)fluidStackInCauldron);
                        player.func_71029_a(StatList.field_188078_L);
                        if (heldStack.func_190916_E() > 1) {
                            if (!player.field_71071_by.func_70441_a(filledBucketStack)) {
                                return false;
                            }
                            player.func_184611_a(hand, BlockWitchCauldron.consumeItem(heldStack));
                        } else {
                            player.func_184611_a(hand, filledBucketStack);
                        }
                    }
                } else {
                    heldStack.func_77982_d(nbtFluid.func_74737_b());
                }
            }
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            cauldron.notifyBlockUpdate(true);
            return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        } else {
            ItemStack brewStack;
            boolean enoughLiquid;
            int drainAmount;
            if (heldStack.func_77973_b() != Items.field_151069_bo) return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            if (world.field_72995_K) {
                return true;
            }
            int n = drainAmount = cauldron.getActions().actions.isEmpty() ? RangesKt.coerceAtMost(cauldron.getLiquidQuantity(), 333) : this.getDrainAmount(player, cauldron.getActions());
            if (drainAmount <= 0 || !cauldron.isPowered() || !cauldron.isBoiling() || cauldron.isRitualTriggered()) return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            boolean bl = enoughLiquid = drainAmount <= cauldron.getLiquidQuantity();
            if (!enoughLiquid) return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            IPowerSource source = PowerSources.findClosestPowerSource(cauldron);
            int power = cauldron.getPower();
            if (power != 0 && (source == null || !source.consumePower(cauldron.getPower()))) return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            Item result2 = this.getItem(cauldron);
            player.func_71029_a(StatList.field_188078_L);
            NBTTagCompound tag = cauldron.writeFluid(new NBTTagCompound());
            cauldron.drain(Math.min(drainAmount, cauldron.getLiquidQuantity()), true);
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            cauldron.notifyBlockUpdate(true);
            if (result2 instanceof ItemBrewBottle) {
                this.processSkillChanges(player, cauldron.getActions());
                brewStack = new ItemStack(result2);
                brewStack.func_77982_d(tag);
            } else {
                brewStack = new ItemStack((Item)Items.field_151068_bn);
                PotionUtils.func_185188_a((ItemStack)brewStack, (PotionType)PotionTypes.field_185230_b);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            if (heldStack.func_190926_b()) {
                player.func_184611_a(hand, brewStack);
                return true;
            } else {
                if (player.field_71071_by.func_70441_a(brewStack)) return true;
                player.func_71019_a(brewStack, false);
            }
            return true;
        }
    }

    public ItemStack fillBottleFromCauldron(World world, BlockPos pos) {
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
        if (cauldron != null) {
            int drainAmount = cauldron.getActions().actions.isEmpty() ? RangesKt.coerceAtMost(cauldron.getLiquidQuantity(), 333) : 3000;
            if (cauldron.getLiquidQuantity() > 0 && cauldron.isPowered() && cauldron.isBoiling() && !cauldron.isRitualTriggered()) {
                NBTTagCompound nbtFluid = cauldron.writeFluid(new NBTTagCompound());
                boolean enoughLiquid = drainAmount <= cauldron.getLiquidQuantity();
                Item item = this.getItem(cauldron);
                cauldron.drain(Math.min(drainAmount, cauldron.getLiquidQuantity()), true);
                world.func_184133_a(null, pos, SoundEvents.field_187808_ef, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                cauldron.notifyBlockUpdate(true);
                if (enoughLiquid) {
                    ItemStack brewStack = new ItemStack(item);
                    if (item instanceof ItemBrewBottle) {
                        brewStack.func_77982_d(nbtFluid);
                    }
                    return brewStack;
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    private Item getItem(TileEntityCauldron cauldron) {
        if (cauldron.getActions().actions.isEmpty()) {
            return Items.field_151068_bn;
        }
        if (cauldron.isLingering()) {
            return WitcheryGeneralItems.LINGERING_BREW_BOTTLE;
        }
        return cauldron.isSplash() ? WitcheryGeneralItems.SPLASH_BREW_BOTTLE : WitcheryGeneralItems.BREW_BOTTLE;
    }

    private void processSkillChanges(EntityPlayer player, BrewActionList actionList) {
        int currentLevel;
        PlayerExtendedData props = WitcheryUtils.getExtension(player);
        EffectLevelCounter levels = WitcheryBrewEffects.getBrewLevel(actionList);
        if (levels.canIncreasePlayerSkill(currentLevel = props.getBottlingSkill())) {
            props.increaseBottlingSkill();
        }
    }

    private int getDrainAmount(EntityPlayer player, BrewActionList actionList) {
        ModifierYield yieldModifier = WitcheryBrewEffects.getYieldModifier(actionList);
        int[][] yieldLevels = new int[][]{{1, 3000}, {2, 1500}, {3, 1000}, {4, 750}, {5, 600}, {6, 500}, {8, 375}, {10, 300}, {15, 200}, {30, 100}};
        int yield = 0;
        PlayerExtendedData props = WitcheryUtils.getExtension(player);
        if (props != null) {
            boolean familiarLevel;
            int levelSkill = props.getBottlingSkill() / 30;
            PotionEffect potionEffect = player.func_70660_b(WitcheryPotionEffects.BREWING_EXPERT);
            int levelPotion = potionEffect != null ? potionEffect.func_76458_c() + 1 : 0;
            int gearLevel = 0;
            if (WitcheryEquipmentItems.WITCH_HAT.isHatWorn(player)) {
                ++gearLevel;
            }
            if (WitcheryEquipmentItems.BABAS_HAT.isHatWorn(player)) {
                gearLevel += 2;
            }
            if (WitcheryEquipmentItems.WITCH_ROBES.isRobeWorn(player)) {
                ++gearLevel;
            }
            if (WitcheryEquipmentItems.NECROMANCERS_ROBES.isRobeWorn(player)) {
                ++gearLevel;
            }
            boolean bl = familiarLevel = Familiars.hasFamiliarPower(player, WitcheryFamiliars.BREW_MASTERY);
            if (levelSkill == 1) {
                yield = gearLevel >= 1 || levelPotion >= 1 ? 2 : 1;
            } else if (levelSkill >= 2) {
                yield = gearLevel >= 3 && levelPotion >= 3 && familiarLevel >= true ? 9 : (gearLevel >= 2 && levelPotion >= 3 && familiarLevel >= true ? 8 : (gearLevel >= 2 && levelPotion >= 3 ? 7 : (gearLevel >= 2 && levelPotion >= 2 ? 6 : (gearLevel >= 2 && levelPotion >= 1 ? 5 : (gearLevel >= 2 || levelPotion >= 1 ? 4 : (gearLevel >= 1 ? 3 : 2))))));
            }
        }
        return yieldLevels[Math.max(yield - yieldModifier.getYieldModification(), 0)][1];
    }

    public void func_176224_k(World world, BlockPos position) {
        if (world.field_73012_v.nextInt(20) == 1) {
            TileEntityCauldron cauldron;
            float temperature = world.func_180494_b(position).func_180626_a(position);
            if (world.func_72959_q().func_76939_a(temperature, position.func_177956_o()) >= 0.15f && (cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, position)) != null) {
                cauldron.fill(new FluidStack(FluidRegistry.WATER, 334), true);
                BlockUtil.notifyBlockUpdate(world, position);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{LEVEL}).build();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.CAULDRON.create();
    }
}

