/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Random;
import kotlin.jvm.functions.Function0;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockWitchCrop
extends BlockCrops {
    protected static final PropertyInteger AGE5 = PropertyInteger.func_177719_a((String)"age", (int)0, (int)5);
    public static final PropertyInteger AGE4 = PropertyInteger.func_177719_a((String)"age", (int)0, (int)4);
    private final int growthStages;
    private final boolean canFertilize;
    private final Function0<Item> crop;
    private String translationKey;

    public BlockWitchCrop(Function0<Item> crop) {
        this(crop, 4, true);
    }

    public BlockWitchCrop(Function0<Item> crop, int growthStages, boolean canFertilize) {
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(0)));
        this.func_149647_a(WitcheryGeneralItems.TAB);
        this.growthStages = growthStages;
        this.canFertilize = canFertilize;
        this.crop = crop;
    }

    protected PropertyInteger func_185524_e() {
        return AGE4;
    }

    protected Item func_149866_i() {
        return Item.func_150898_a((Block)this);
    }

    public Item func_149865_P() {
        return this.crop == null ? this.func_149866_i() : this.crop.invoke();
    }

    public int func_185526_g() {
        return this.growthStages;
    }

    protected boolean func_185514_i(IBlockState state) {
        return super.func_185514_i(state) || state.func_177230_c() == this;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i;
        this.func_176475_e(worldIn, pos, state);
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (i = this.func_185527_x(state)) < this.func_185526_g()) {
            float f = this.augmentGrowthChance(BlockWitchCrop.func_180672_a((Block)this, (World)worldIn, (BlockPos)pos));
            if (WitcheryBlocks.MANDRAKE_SEEDS == this) {
                f /= 1.5f;
            }
            if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                worldIn.func_180501_a(pos, this.func_185528_e(i + 1), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
    }

    protected float augmentGrowthChance(float original) {
        return original;
    }

    public void func_176487_g(World world, BlockPos pos, IBlockState state) {
        int l;
        if (world.field_72995_K) {
            return;
        }
        int stages = this.func_185526_g();
        int current = this.func_185527_x(state);
        if (current == stages) {
            return;
        }
        int n = l = this.canFertilize ? current + MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)stages) : current + 1;
        if (l > stages) {
            l = stages;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(l)), 2);
    }

    public void getDrops(NonNullList<ItemStack> ret, IBlockAccess access, BlockPos pos, IBlockState state, int fortune) {
        Random random;
        Random random2 = random = access instanceof World ? ((World)access).field_73012_v : RANDOM;
        if (this.func_185525_y(state)) {
            for (int n = 0; n < 3 + fortune; ++n) {
                if (random.nextInt(15) > 7) continue;
                ret.add((Object)new ItemStack((Block)this));
            }
            for (int i = 0; i < this.func_149745_a(random); ++i) {
                ret.add((Object)new ItemStack(this.func_149865_P()));
            }
        } else {
            super.getDrops(ret, access, pos, state, fortune);
        }
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots && world.func_82736_K().func_82766_b("doTileDrops")) {
            NonNullList drops = NonNullList.func_191196_a();
            this.getDrops((NonNullList<ItemStack>)drops, (IBlockAccess)world, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                if (((Boolean)captureDrops.get()).booleanValue()) {
                    ((NonNullList)capturedDrops.get()).add((Object)drop);
                    return;
                }
                double f = 0.5;
                double d0 = world.field_73012_v.nextDouble() * f + 0.25;
                double d1 = world.field_73012_v.nextDouble() * f + 0.25;
                double d2 = world.field_73012_v.nextDouble() * f + 0.25;
                EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, drop);
                item.func_174869_p();
                this.modifyDrop(item);
                world.func_72838_d((Entity)item);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.func_185524_e()}).build();
    }

    protected void modifyDrop(EntityItem item) {
    }

    public Block func_149663_c(String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    public String func_149739_a() {
        return "item." + this.translationKey;
    }
}

