/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLever;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCursedBlock;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.init.WitcheryTileEntities;

public class WitcheryBlockLever
extends BlockContainer {
    public WitcheryBlockLever() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.NORTH).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    protected static boolean canAttachTo(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        if (direction == EnumFacing.UP) {
            return iblockstate.func_185896_q() || !WitcheryBlockLever.func_193384_b((Block)block) && flag;
        }
        return !WitcheryBlockLever.func_193382_c((Block)block) && flag;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public Item func_180660_a(IBlockState p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.func_150898_a((Block)Blocks.field_150442_at);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Blocks.field_150442_at);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void replaceButton(World world, BlockPos pos, ModifiersImpact impactModifiers, BrewActionList actionList) {
        IBlockState meta = world.func_180495_p(pos);
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)BlockLever.field_176359_b, meta.func_177229_b((IProperty)BlockLever.field_176359_b)).func_177226_a((IProperty)BlockLever.field_176360_a, meta.func_177229_b((IProperty)BlockLever.field_176360_a)), 3);
        TileEntityCursedBlock tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, pos);
        if (tile != null) {
            tile.initialize(impactModifiers, actionList);
        }
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing dir) {
        return WitcheryBlockLever.canAttachTo(world, pos, dir);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!WitcheryBlockLever.canAttachTo(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(false));
        if (WitcheryBlockLever.canAttachTo(worldIn, pos, facing)) {
            return iblockstate.func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.func_176856_a((EnumFacing)facing, (EnumFacing)placer.func_174811_aO()));
        }
        for (EnumFacing enumfacing : EnumFacing.field_176754_o) {
            if (enumfacing == facing || !WitcheryBlockLever.canAttachTo(worldIn, pos, enumfacing)) continue;
            return iblockstate.func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.func_176856_a((EnumFacing)enumfacing, (EnumFacing)placer.func_174811_aO()));
        }
        if (worldIn.func_180495_p(pos.func_177977_b()).func_185896_q()) {
            return iblockstate.func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.func_176856_a((EnumFacing)EnumFacing.UP, (EnumFacing)placer.func_174811_aO()));
        }
        return iblockstate;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkCanSurvive(worldIn, pos, state) && !WitcheryBlockLever.canAttachTo(worldIn, pos, ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkCanSurvive(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return Blocks.field_150442_at.func_185496_a(state, source, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityCursedBlock tile;
        if (!worldIn.field_72995_K && (tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)worldIn, pos)) != null && tile.applyToEntityAndDestroy((Entity)playerIn)) {
            state = state.func_177231_a((IProperty)BlockLever.field_176359_b);
            worldIn.func_180501_a(pos, state, 3);
            float f = (Boolean)state.func_177229_b((IProperty)BlockLever.field_176359_b) != false ? 0.6f : 0.5f;
            worldIn.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
            worldIn.func_175685_c(pos, (Block)this, false);
            EnumFacing enumfacing = ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c();
            worldIn.func_175685_c(pos.func_177972_a(enumfacing.func_176734_d()), (Block)this, false);
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)BlockLever.field_176359_b)).booleanValue()) {
            worldIn.func_175685_c(pos, (Block)this, false);
            EnumFacing enumfacing = ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c();
            worldIn.func_175685_c(pos.func_177972_a(enumfacing.func_176734_d()), (Block)this, false);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)BlockLever.field_176359_b) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.func_177229_b((IProperty)BlockLever.field_176359_b)).booleanValue()) {
            return 0;
        }
        return ((BlockLever.EnumOrientation)blockState.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c() == side ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.func_176853_a((int)(meta & 7))).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176855_a();
        if (((Boolean)state.func_177229_b((IProperty)BlockLever.field_176359_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return Blocks.field_150442_at.func_185499_a(state, rot);
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a(((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{BlockLever.field_176360_a, BlockLever.field_176359_b}).build();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.CURSED_BLOCK.create();
    }
}

