/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCursedBlock;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.init.WitcheryTileEntities;

public class WitcheryBlockPressurePlate
extends BlockContainer {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private static final AxisAlignedBB PRESSED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.03125, 0.9375);
    private static final AxisAlignedBB UNPRESSED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);
    private static final AxisAlignedBB PRESSURE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);
    private final BlockPressurePlate.Sensitivity sensitivity;
    private final Block original;

    public WitcheryBlockPressurePlate(Block original, BlockPressurePlate.Sensitivity sensitivity) {
        super(original.func_176223_P().func_185904_a());
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.sensitivity = sensitivity;
        this.original = original;
        this.func_149711_c(0.5f);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean flag = this.getRedstoneStrength(state) > 0;
        return flag ? PRESSED_AABB : UNPRESSED_AABB;
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canBePlacedOn(worldIn, pos.func_177977_b());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBePlacedOn(worldIn, pos.func_177977_b())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canBePlacedOn(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_185896_q() || worldIn.func_180495_p(pos).func_177230_c() instanceof BlockFence;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i;
        if (!worldIn.field_72995_K && (i = this.getRedstoneStrength(state)) > 0) {
            this.updateState(worldIn, pos, state, i, null);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        int i;
        if (!worldIn.field_72995_K && (i = this.getRedstoneStrength(state)) == 0) {
            this.updateState(worldIn, pos, state, i, entityIn);
        }
    }

    private void updateState(World worldIn, BlockPos pos, IBlockState state, int oldRedstoneStrength, Entity entity) {
        TileEntityCursedBlock tile;
        boolean flag1;
        int i = this.computeRedstoneStrength(worldIn, pos);
        boolean flag = oldRedstoneStrength > 0;
        boolean bl = flag1 = i > 0;
        if (oldRedstoneStrength != i && !worldIn.field_72995_K && (tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)worldIn, pos)) != null && entity != null && tile.applyToEntityAndDestroy(entity)) {
            state = this.setRedstoneStrength(state, i);
            worldIn.func_180501_a(pos, state, 2);
            this.updateNeighbors(worldIn, pos);
            worldIn.func_175704_b(pos, pos);
        }
        if (!flag1 && flag) {
            this.playClickOffSound(worldIn, pos);
        } else if (flag1 && !flag) {
            this.playClickOnSound(worldIn, pos);
        }
        if (flag1) {
            worldIn.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (this.getRedstoneStrength(state) > 0) {
            this.updateNeighbors(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private void updateNeighbors(World worldIn, BlockPos pos) {
        worldIn.func_175685_c(pos, (Block)this, false);
        worldIn.func_175685_c(pos.func_177977_b(), (Block)this, false);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getRedstoneStrength(blockState);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? this.getRedstoneStrength(blockState) : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void replaceButton(World world, BlockPos pos, ModifiersImpact impactModifiers, BrewActionList actionList) {
        IBlockState state = world.func_180495_p(pos);
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)POWERED, state.func_177229_b((IProperty)POWERED)), 3);
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        TileEntityCursedBlock tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, pos);
        if (tile != null) {
            tile.initialize(impactModifiers, actionList);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.original);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.original);
    }

    private int getRedstoneStrength(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    private IBlockState setRedstoneStrength(IBlockState state, int strength) {
        return state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    private void playClickOnSound(World worldIn, BlockPos color2) {
        if (this.field_149764_J == Material.field_151575_d) {
            worldIn.func_184133_a(null, color2, SoundEvents.field_187895_gX, SoundCategory.BLOCKS, 0.3f, 0.8f);
        } else {
            worldIn.func_184133_a(null, color2, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    private void playClickOffSound(World worldIn, BlockPos pos) {
        if (this.field_149764_J == Material.field_151575_d) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187893_gW, SoundCategory.BLOCKS, 0.3f, 0.7f);
        } else {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    private int computeRedstoneStrength(World worldIn, BlockPos pos) {
        List list2;
        AxisAlignedBB axisalignedbb = PRESSURE_AABB.func_186670_a(pos);
        switch (this.sensitivity) {
            case EVERYTHING: {
                list2 = worldIn.func_72839_b(null, axisalignedbb);
                break;
            }
            case MOBS: {
                list2 = worldIn.func_72872_a(EntityLivingBase.class, axisalignedbb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list2.isEmpty()) {
            for (Entity entity : list2) {
                if (entity.func_145773_az()) continue;
                return 15;
            }
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{POWERED}).build();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.CURSED_BLOCK.create();
    }
}

