/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J(\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001eH\u0016J(\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lnet/msrandom/witchery/block/WitcheryBlockSapling;", "Lnet/minecraft/block/BlockBush;", "Lnet/minecraft/block/IGrowable;", "tree", "Lnet/minecraft/world/gen/feature/WorldGenAbstractTree;", "(Lnet/minecraft/world/gen/feature/WorldGenAbstractTree;)V", "getTree", "()Lnet/minecraft/world/gen/feature/WorldGenAbstractTree;", "canGrow", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "isClient", "canUseBonemeal", "rand", "Ljava/util/Random;", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "generateTree", "", "world", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "source", "Lnet/minecraft/world/IBlockAccess;", "getMetaFromState", "", "getStateFromMeta", "meta", "grow", "updateTick", "Companion", "WitcheryResurrected"})
public final class WitcheryBlockSapling
extends BlockBush
implements IGrowable {
    @NotNull
    private final WorldGenAbstractTree tree;
    @JvmField
    @NotNull
    public static final PropertyBool READY;
    private static final AxisAlignedBB AABB;
    public static final Companion Companion;

    public void func_180650_b(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random rand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(rand, "rand");
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (world.func_175699_k(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(world, pos, state, rand);
            }
        }
    }

    public final void grow(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random rand) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(rand, "rand");
        Comparable comparable = state.func_177229_b((IProperty)READY);
        Intrinsics.checkExpressionValueIsNotNull(comparable, "state.getValue(READY)");
        if (((Boolean)comparable).booleanValue()) {
            this.generateTree(world, pos, state, rand);
        } else {
            world.func_180501_a(pos, state.func_177226_a((IProperty)READY, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)READY) == false)), 4);
        }
    }

    private final void generateTree(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        Block block = Blocks.field_150350_a;
        Intrinsics.checkExpressionValueIsNotNull(block, "Blocks.AIR");
        world.func_180501_a(pos, block.func_176223_P(), 4);
        if (!this.tree.func_180709_b(world, rand, pos)) {
            world.func_180501_a(pos, state, 4);
        }
    }

    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        return AABB;
    }

    public boolean func_180670_a(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Intrinsics.checkParameterIsNotNull(rand, "rand");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        return (double)rand.nextFloat() < 0.75;
    }

    public void func_176474_b(@NotNull World world, @NotNull Random rand, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(rand, "rand");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        this.grow(world, pos, state, rand);
    }

    public boolean func_176473_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, boolean isClient) {
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(state, "state");
        return true;
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        IBlockState iBlockState = this.func_176223_P().func_177226_a((IProperty)READY, (Comparable)Boolean.valueOf(meta == 1));
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "this.defaultState.withProperty(READY, meta == 1)");
        return iBlockState;
    }

    public int func_176201_c(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull(state, "state");
        Comparable comparable = state.func_177229_b((IProperty)READY);
        Intrinsics.checkExpressionValueIsNotNull(comparable, "state.getValue(READY)");
        return (Boolean)comparable != false ? 1 : 0;
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{(IProperty)READY});
    }

    @NotNull
    public final WorldGenAbstractTree getTree() {
        return this.tree;
    }

    public WitcheryBlockSapling(@NotNull WorldGenAbstractTree tree) {
        Intrinsics.checkParameterIsNotNull(tree, "tree");
        this.tree = tree;
        BlockStateContainer blockStateContainer = this.func_176194_O();
        Intrinsics.checkExpressionValueIsNotNull(blockStateContainer, "getBlockState()");
        this.func_180632_j(blockStateContainer.func_177621_b().func_177226_a((IProperty)READY, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    static {
        Companion = new Companion(null);
        PropertyBool propertyBool = PropertyBool.func_177716_a((String)"ready");
        Intrinsics.checkExpressionValueIsNotNull(propertyBool, "PropertyBool.create(\"ready\")");
        READY = propertyBool;
        AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/msrandom/witchery/block/WitcheryBlockSapling$Companion;", "", "()V", "AABB", "Lnet/minecraft/util/math/AxisAlignedBB;", "READY", "Lnet/minecraft/block/properties/PropertyBool;", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

