/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.msrandom.witchery.block.BlockChalice;
import net.msrandom.witchery.block.BlockPlacedItem;
import net.msrandom.witchery.block.entity.TileEntityPlacedItem;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntityAltar
extends WitcheryTileEntity
implements IPowerSource {
    private static final int SCAN_DISTANCE = 14;
    private long lastPowerUpdate;
    private boolean core;
    private float power;
    private float maxPower;
    private int powerScale;
    private int rechargeScale;
    private int enhancementLevel;
    private int rangeScale = 1;
    private Set<Block> extraNatureIDs;

    @Override
    public boolean isPowerInvalid() {
        return this.func_145837_r();
    }

    @Override
    protected void initiate() {
        super.initiate();
        if (!this.field_145850_b.field_72995_K && this.core && this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() == WitcheryBlocks.ALTAR) {
            PowerSources.instance().registerPowerSource(this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.setInvalid();
        }
    }

    public void setInvalid() {
        if (this.core) {
            PowerSources.instance().removePowerSource(this);
            this.core = false;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            float maxPowerScaled = this.maxPower * (float)this.powerScale;
            if (this.core) {
                if (this.power < maxPowerScaled) {
                    float basePowerPerUpdate = 10.0f;
                    if (this.ticks % 20L == 0L) {
                        this.power = (int)Math.min(this.power + basePowerPerUpdate * (float)this.rechargeScale, maxPowerScaled);
                        BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
                    }
                } else if (this.power > maxPowerScaled && this.ticks % 20L == 0L) {
                    this.power = maxPowerScaled;
                    BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
                }
            }
        }
    }

    @Override
    public float getRange() {
        return (float)this.rangeScale * 16.0f;
    }

    public void updatePower() {
        if (!this.core) {
            PowerSources.instance().registerPowerSource(this);
        }
        this.core = true;
        this.updateArtifacts();
        this.updatePower(true);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTag) {
        if (this.core) {
            nbtTag.func_74757_a("Core", true);
            nbtTag.func_74776_a("Power", this.power);
            nbtTag.func_74776_a("MaxPower", this.maxPower);
            nbtTag.func_74768_a("PowerScale", this.powerScale);
            nbtTag.func_74768_a("RechargeScale", this.rechargeScale);
            nbtTag.func_74768_a("RangeScale", this.rangeScale);
            nbtTag.func_74768_a("EnhancementLevel", this.enhancementLevel);
        }
        return super.func_189515_b(nbtTag);
    }

    public void func_145839_a(NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("Core")) {
            this.power = nbtTag.func_74760_g("Power");
            this.maxPower = nbtTag.func_74760_g("MaxPower");
            this.powerScale = nbtTag.func_74762_e("PowerScale");
            this.rechargeScale = nbtTag.func_74762_e("RechargeScale");
            this.rangeScale = nbtTag.func_74762_e("RangeScale");
            this.enhancementLevel = nbtTag.func_74762_e("EnhancementLevel");
        }
        super.func_145839_a(nbtTag);
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.func_148857_g());
    }

    @Override
    public boolean consumePower(float power) {
        if (!this.field_145850_b.field_72995_K && this.power >= power) {
            this.power -= power;
            return true;
        }
        return false;
    }

    @Override
    public float getCurrentPower() {
        return this.power;
    }

    public float getMaxPower() {
        return this.maxPower * (float)this.powerScale;
    }

    public int getRechargeScale() {
        return this.rechargeScale;
    }

    public boolean isValid() {
        return this.core;
    }

    @Override
    public World getCurrentWorld() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos getLocation() {
        return this.func_174877_v();
    }

    @Override
    public boolean isLocationEqual(BlockPos position) {
        return position == null || !position.equals((Object)this.func_174877_v());
    }

    private void updatePower(boolean throttle) {
        if (!(this.field_145850_b.field_72995_K || throttle && this.ticks - this.lastPowerUpdate > 0L && this.ticks - this.lastPowerUpdate <= 100L)) {
            Block block;
            this.lastPowerUpdate = this.ticks;
            HashMap<Block, PowerSource> powerObjectTable = new HashMap<Block, PowerSource>();
            for (ItemStack blockItem : OreDictionary.getOres((String)"treeSapling")) {
                block = Block.func_149634_a((Item)blockItem.func_77973_b());
                this.createInMap(powerObjectTable, block, 4, 20);
            }
            for (ItemStack blockItem : OreDictionary.getOres((String)"logWood")) {
                block = Block.func_149634_a((Item)blockItem.func_77973_b());
                this.createInMap(powerObjectTable, block, 2, 50);
            }
            for (ItemStack blockItem : OreDictionary.getOres((String)"treeLeaves")) {
                block = Block.func_149634_a((Item)blockItem.func_77973_b());
                this.createInMap(powerObjectTable, block, 3, 100);
            }
            this.createInMap(powerObjectTable, (Block)Blocks.field_150349_c, 2, 80);
            this.createInMap(powerObjectTable, Blocks.field_150346_d, 1, 80);
            this.createInMap(powerObjectTable, Blocks.field_150458_ak, 1, 100);
            this.createInMap(powerObjectTable, (Block)Blocks.field_150329_H, 3, 50);
            this.createInMap(powerObjectTable, (Block)Blocks.field_150327_N, 4, 30);
            this.createInMap(powerObjectTable, (Block)Blocks.field_150328_O, 4, 30);
            this.createInMap(powerObjectTable, Blocks.field_150464_aj, 4, 20);
            this.createInMap(powerObjectTable, (Block)Blocks.field_150355_j, 1, 50);
            this.createInMap(powerObjectTable, (Block)Blocks.field_150337_Q, 3, 20);
            this.createInMap(powerObjectTable, (Block)Blocks.field_150338_P, 3, 20);
            this.createInMap(powerObjectTable, (Block)Blocks.field_150434_aF, 3, 50);
            this.createInMap(powerObjectTable, (Block)Blocks.field_150436_aH, 3, 50);
            this.createInMap(powerObjectTable, Blocks.field_150423_aK, 4, 20);
            this.createInMap(powerObjectTable, Blocks.field_150393_bb, 3, 20);
            this.createInMap(powerObjectTable, Blocks.field_150420_aW, 3, 20);
            this.createInMap(powerObjectTable, Blocks.field_150419_aX, 3, 20);
            this.createInMap(powerObjectTable, Blocks.field_150440_ba, 4, 20);
            this.createInMap(powerObjectTable, Blocks.field_150394_bc, 3, 20);
            this.createInMap(powerObjectTable, Blocks.field_150395_bd, 2, 50);
            this.createInMap(powerObjectTable, (Block)Blocks.field_150391_bh, 1, 80);
            this.createInMap(powerObjectTable, Blocks.field_150380_bt, 250, 1);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.DEMON_HEART, 40, 2);
            this.createInMap(powerObjectTable, Blocks.field_150375_by, 3, 20);
            this.createInMap(powerObjectTable, Blocks.field_150459_bM, 4, 20);
            this.createInMap(powerObjectTable, Blocks.field_150469_bN, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.BELLADONNA_SEEDS, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.MANDRAKE_SEEDS, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.ARTICHOKE_SEEDS, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.SNOWBELL_SEEDS, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.EMBER_MOSS, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryWoodTypes.ROWAN.getLeaves(), 4, 50);
            this.createInMap(powerObjectTable, (Block)WitcheryWoodTypes.ALDER.getLeaves(), 4, 50);
            this.createInMap(powerObjectTable, (Block)WitcheryWoodTypes.HAWTHORN.getLeaves(), 4, 50);
            this.createInMap(powerObjectTable, WitcheryWoodTypes.ROWAN.getLog(), 3, 100);
            this.createInMap(powerObjectTable, WitcheryWoodTypes.ALDER.getLog(), 3, 100);
            this.createInMap(powerObjectTable, WitcheryWoodTypes.HAWTHORN.getLog(), 3, 100);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.SPANISH_MOSS, 3, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.GLINT_WEED, 2, 20);
            this.createInMap(powerObjectTable, WitcheryBlocks.EMPTY_CRITTER_SNARE, 2, 10);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.BLOOD_POPPY, 2, 10);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.GRASSPER, 2, 10);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.WISPY_COTTON, 3, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.INFINITY_EGG, 1000, 1);
            if (this.extraNatureIDs == null) {
                this.extraNatureIDs = new HashSet<Block>();
                for (Block block2 : ForgeRegistries.BLOCKS) {
                    if (!(block2 instanceof BlockFlower) && !(block2 instanceof BlockCrops) || powerObjectTable.containsKey(block2)) continue;
                    this.extraNatureIDs.add(block2);
                }
            }
            for (Block block2 : this.extraNatureIDs) {
                this.createInMap(powerObjectTable, block2, 2, 4);
            }
            for (int y = this.func_174877_v().func_177956_o() - 14; y <= this.func_174877_v().func_177956_o() + 14; ++y) {
                for (int z = this.func_174877_v().func_177952_p() + 14; z >= this.func_174877_v().func_177952_p() - 14; --z) {
                    for (int x = this.func_174877_v().func_177958_n() - 14; x <= this.func_174877_v().func_177958_n() + 14; ++x) {
                        Block block3 = this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                        PowerSource source = (PowerSource)powerObjectTable.get(block3);
                        if (source == null) continue;
                        ++source.count;
                    }
                }
            }
            float newMax = 0.0f;
            for (PowerSource source2 : powerObjectTable.values()) {
                newMax += (float)source2.getPower();
            }
            if (newMax != this.maxPower) {
                this.maxPower = newMax;
                BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    public void updateArtifacts() {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayList<BlockPos> toVisit = new ArrayList<BlockPos>();
        toVisit.add(this.func_174877_v());
        boolean headfound = false;
        boolean candlefound = false;
        boolean cupfound = false;
        boolean knifeFound = false;
        boolean wandFound = false;
        boolean pentacleFound = false;
        boolean infinityFound = false;
        int newPowerScale = 1;
        int newRechargeScale = 1;
        int newRangeScale = 1;
        int newEnhancementLevel = 0;
        while (toVisit.size() > 0) {
            BlockPos coord = (BlockPos)toVisit.get(0);
            toVisit.remove(0);
            for (BlockPos newCoord : new BlockPos[]{coord.func_177978_c(), coord.func_177968_d(), coord.func_177974_f(), coord.func_177976_e()}) {
                if (this.field_145850_b.func_180495_p(newCoord).func_177230_c() != WitcheryBlocks.ALTAR || visited.contains(newCoord) || toVisit.contains(newCoord)) continue;
                toVisit.add(newCoord);
            }
            visited.add(coord);
            BlockPos offset = coord.func_177984_a();
            Block block = this.field_145850_b.func_180495_p(offset).func_177230_c();
            if (!headfound && block == Blocks.field_150465_bP) {
                TileEntity tile = this.field_145850_b.func_175625_s(offset);
                if (!(tile instanceof TileEntitySkull)) continue;
                TileEntitySkull skullTileEntity = (TileEntitySkull)tile;
                switch (skullTileEntity.func_145904_a()) {
                    case 0: {
                        ++newRechargeScale;
                        ++newPowerScale;
                        headfound = true;
                        break;
                    }
                    case 1: {
                        newRechargeScale += 2;
                        newPowerScale += 2;
                        headfound = true;
                        break;
                    }
                    case 3: {
                        newRechargeScale += 3;
                        newPowerScale += 3;
                        headfound = true;
                    }
                }
                continue;
            }
            if (!candlefound && block == WitcheryBlocks.CANDELABRA) {
                candlefound = true;
                newRechargeScale += 2;
                continue;
            }
            if (!candlefound && block == Blocks.field_150478_aa) {
                candlefound = true;
                ++newRechargeScale;
                continue;
            }
            if (block instanceof BlockPlacedItem) {
                TileEntityPlacedItem item = WitcheryTileEntities.PLACED_ITEM.getAt((IBlockAccess)this.field_145850_b, offset);
                if (item == null) continue;
                ItemStack placedStack = item.getStack();
                if (!knifeFound && placedStack.func_77973_b() == WitcheryGeneralItems.getArthana()) {
                    knifeFound = true;
                    ++newRangeScale;
                    continue;
                }
                if (!wandFound && placedStack.func_77973_b() == WitcheryGeneralItems.MYSTIC_BRANCH) {
                    wandFound = true;
                    ++newEnhancementLevel;
                    continue;
                }
                if (pentacleFound || placedStack.func_77973_b() != WitcheryIngredientItems.KOBOLDITE_PENTACLE) continue;
                pentacleFound = true;
                continue;
            }
            if (!cupfound && block instanceof BlockChalice) {
                cupfound = true;
                newPowerScale += ((BlockChalice)block).isFull ? 2 : 1;
                continue;
            }
            if (infinityFound || block != WitcheryBlocks.INFINITY_EGG) continue;
            infinityFound = true;
        }
        if (pentacleFound) {
            newRechargeScale *= 2;
        }
        if (infinityFound) {
            newRechargeScale *= 10;
            newPowerScale *= 10;
        }
        if (newRechargeScale != this.rechargeScale || newPowerScale != this.powerScale || newRangeScale != this.rangeScale || newEnhancementLevel != this.enhancementLevel) {
            this.rechargeScale = newRechargeScale;
            this.powerScale = newPowerScale;
            this.rangeScale = newRangeScale;
            this.enhancementLevel = newEnhancementLevel;
            if (!this.field_145850_b.field_72995_K) {
                BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    private void createInMap(Map<Block, PowerSource> map2, Block block, int factor, int limit) {
        PowerSource source = new PowerSource(factor, (int)(RangesKt.coerceAtLeast((double)this.enhancementLevel * 1.18, 1.0) * (double)limit));
        map2.put(block, source);
    }

    static class PowerSource {
        private final int factor;
        private final int limit;
        private int count;

        public PowerSource(int factor, int limit) {
            this.factor = factor;
            this.limit = limit;
            this.count = 0;
        }

        public int getPower() {
            return Math.min(this.count, this.limit) * this.factor;
        }
    }
}

