/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntityBloodCrucible
extends TileEntity {
    private static final int MAX_BLOOD_LEVEL = 20;
    private int bloodLevel;

    public boolean isFull() {
        return this.bloodLevel == 20;
    }

    public void drainAll() {
        this.bloodLevel = 0;
        this.notifyBlockUpdate(false);
    }

    public int getBloodLevel() {
        return this.bloodLevel;
    }

    public void increaseBloodLevel() {
        if (this.bloodLevel < 20) {
            this.bloodLevel = Math.min(5 + this.bloodLevel, 20);
            this.notifyBlockUpdate(false);
        }
    }

    public float getPercentFilled() {
        return (float)this.bloodLevel / 20.0f;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtRoot) {
        super.func_189515_b(nbtRoot);
        nbtRoot.func_74768_a("BloodLevel", this.bloodLevel);
        return nbtRoot;
    }

    public void func_145839_a(NBTTagCompound nbtRoot) {
        super.func_145839_a(nbtRoot);
        this.bloodLevel = nbtRoot.func_74762_e("BloodLevel");
    }

    public void notifyBlockUpdate(boolean notifyNeighbours) {
        BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
        if (notifyNeighbours && this.field_145850_b != null) {
            this.field_145850_b.func_175722_b(this.func_174877_v(), this.func_145838_q(), true);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.func_145839_a(packet2.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }
}

