/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.msrandom.witchery.block.entity.TileEntityAltar;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.recipe.brazier.BrazierRecipe;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityBrazier
extends WitcheryTileEntity
implements ISidedInventory {
    private static final float POWER_PER_TICK = 1.0f;
    private static final int SLOT_1 = 0;
    private static final int SLOT_2 = 1;
    private static final int SLOT_3 = 2;
    private static final int SLOT_RESULT = 3;
    private static final int[] slots_top = new int[]{0, 1, 2};
    private static final int[] slots_bottom = new int[]{0, 1, 2};
    private static final int[] slots_sides = new int[]{0, 1, 2};
    private final Set<EntityPlayer> players = new HashSet<EntityPlayer>();
    public boolean previousRedstoneState;
    public int powerLevel;
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private int furnaceCookTime = 0;
    private BlockPos powerSourceCoord;
    private long storage;
    private BrazierRecipe recipe;

    public int func_70302_i_() {
        return this.slots.size();
    }

    public void begin() {
        this.func_70299_a(3, new ItemStack(WitcheryIngredientItems.WOOD_ASH));
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.slots.get(slot);
    }

    public boolean isBurning() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        return ItemStackHelper.func_188382_a(this.slots, (int)slot, (int)quantity);
    }

    public boolean func_191420_l() {
        for (int slot = 0; slot < 3; ++slot) {
            if (this.func_70301_a(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.func_174888_l();
        if (this.recipe != null) {
            this.players.forEach(this.recipe::removePlayer);
            this.players.clear();
        }
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.slots, (int)slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
        WitcheryUtils.getRecipeManager(this.field_145850_b).getRecipe(WitcheryRecipeTypes.BRAZIER, this, this.field_145850_b).ifPresent(it -> {
            this.recipe = it;
        });
    }

    public String func_70005_c_() {
        return this.func_145838_q().func_149732_F();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_145839_a(NBTTagCompound nbtRoot) {
        super.func_145839_a(nbtRoot);
        NBTTagList nbtSlotList = nbtRoot.func_150295_c("Items", 10);
        this.slots = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbtSlotList.func_74745_c(); ++i) {
            NBTTagCompound nbtSlot = nbtSlotList.func_150305_b(i);
            byte b0 = nbtSlot.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.slots.size()) continue;
            this.slots.set((int)b0, (Object)new ItemStack(nbtSlot));
        }
        this.furnaceCookTime = nbtRoot.func_74765_d("CookTime");
        this.powerLevel = nbtRoot.func_74765_d("PowerLevel");
        this.storage = nbtRoot.func_74763_f("PowerStorage");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtRoot) {
        super.func_189515_b(nbtRoot);
        nbtRoot.func_74777_a("CookTime", (short)this.furnaceCookTime);
        nbtRoot.func_74777_a("PowerLevel", (short)this.powerLevel);
        nbtRoot.func_74772_a("PowerStorage", this.storage);
        NBTTagList nbtSlotList = new NBTTagList();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (((ItemStack)this.slots.get(i)).func_190926_b()) continue;
            NBTTagCompound nbtSlot = new NBTTagCompound();
            nbtSlot.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.slots.get(i)).func_77955_b(nbtSlot);
            nbtSlotList.func_74742_a((NBTBase)nbtSlot);
        }
        nbtRoot.func_74782_a("Items", (NBTBase)nbtSlotList);
        return nbtRoot;
    }

    public int func_70297_j_() {
        return 64;
    }

    private IPowerSource getPowerSource() {
        if (this.powerSourceCoord == null || this.ticks % 100L == 0L) {
            return this.findNewPowerSource();
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.powerSourceCoord);
        if (!(tileEntity instanceof TileEntityAltar)) {
            return this.findNewPowerSource();
        }
        TileEntityAltar altarTileEntity = (TileEntityAltar)tileEntity;
        if (!altarTileEntity.isValid()) {
            return this.findNewPowerSource();
        }
        return altarTileEntity;
    }

    private IPowerSource findNewPowerSource() {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(this.field_145850_b, this.field_174879_c);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean update = false;
        if (!this.field_145850_b.field_72995_K) {
            boolean powered;
            boolean bl = powered = this.powerLevel > 0;
            if (this.recipe != null && !this.func_70301_a(3).func_190926_b()) {
                IPowerSource powerSource = this.getPowerSource();
                this.powerSourceCoord = powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord) ? powerSource.getLocation() : null;
                boolean needsPower = this.recipe.getNeedsPower();
                int n = this.powerLevel = !needsPower || powerSource != null ? 1 : 0;
                if (!this.recipe.getNeedsPower() || powerSource != null && powerSource.consumePower(1.0f)) {
                    update = this.furnaceCookTime == 0;
                    ++this.furnaceCookTime;
                    if ((long)this.furnaceCookTime == (long)this.recipe.getBurnTime() + this.storage * 400L) {
                        this.furnaceCookTime = 0;
                        this.recipe.onBurnt(this.field_145850_b, this.func_174877_v());
                        this.func_70299_a(0, ItemStack.field_190927_a);
                        this.func_70299_a(1, ItemStack.field_190927_a);
                        this.func_70299_a(2, ItemStack.field_190927_a);
                        this.players.forEach(this.recipe::removePlayer);
                        this.players.clear();
                        update = true;
                    } else {
                        HashSet currentPlayers = new HashSet(this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 70), (double)(this.field_174879_c.func_177956_o() - 68), (double)(this.field_174879_c.func_177952_p() - 70), (double)(this.field_174879_c.func_177958_n() + 70), (double)(this.field_174879_c.func_177956_o() + 68), (double)(this.field_174879_c.func_177952_p() + 70))));
                        Iterator<EntityPlayer> iterator2 = this.players.iterator();
                        while (iterator2.hasNext()) {
                            EntityPlayer player = iterator2.next();
                            if (currentPlayers.contains(player)) {
                                currentPlayers.remove(player);
                                continue;
                            }
                            iterator2.remove();
                            this.recipe.removePlayer(player);
                        }
                        for (EntityPlayer player : currentPlayers) {
                            this.players.add(player);
                            this.recipe.addPlayer(player, this);
                        }
                        this.storage += (long)this.recipe.onBurning(this.field_145850_b, this.func_174877_v(), this.ticks);
                        if (this.storage == Long.MAX_VALUE) {
                            this.storage = 0L;
                        }
                    }
                    if (powered != this.powerLevel > 0) {
                        update = true;
                    }
                } else {
                    this.powerLevel = 0;
                    if (powered) {
                        update = true;
                    }
                }
            } else {
                if (!this.func_70301_a(3).func_190926_b()) {
                    this.reset();
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 0.5, 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), this.field_145850_b, this.field_174879_c, 8.0);
                }
                if (this.ticks % 40L == 0L) {
                    IPowerSource powerSource = this.getPowerSource();
                    if (powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord)) {
                        this.powerSourceCoord = powerSource.getLocation();
                    }
                    int n = this.powerLevel = powerSource != null ? 1 : 0;
                }
                update = this.furnaceCookTime > 0 || powered != this.powerLevel > 0;
                this.furnaceCookTime = 0;
            }
        }
        if (update) {
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.func_145839_a(packet2.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot != 3 && !itemstack.func_190926_b() && itemstack.func_190916_E() == 1 && slot >= 0 && slot < this.slots.size() && ((ItemStack)this.slots.get(slot)).func_190926_b();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.slots.clear();
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slots_bottom : (side == EnumFacing.UP ? slots_top : slots_sides);
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing par3) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }
}

