/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.msrandom.witchery.block.entity.WaterContainer;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.brewing.CauldronBrewData;
import net.msrandom.witchery.brewing.EffectLevelCounter;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.entity.EntityLeonard;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryFluids;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.recipe.CauldronRecipe;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityCauldron
extends WitcheryTileEntity
implements WaterContainer,
IInventory {
    private static final int TICKS_TO_BOIL = 100;
    private final List<ItemStack> addedStacks = new ArrayList<ItemStack>();
    private CauldronBrewData brewData = new CauldronBrewData();
    private int ticksHeated;
    private boolean powered;
    private int ritualTicks;
    private int fluid;
    private List<CauldronRecipe> recipeCandidates;
    private CauldronRecipe currentRecipe;

    public boolean isBoiling() {
        return this.ticksHeated == 100;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public int getRedstoneSignalStrength() {
        if (!this.isFilled()) {
            return 0;
        }
        if (!this.isBoiling()) {
            return 3;
        }
        if (this.brewData.getEffectCounter().getCount() == 0) {
            return 6;
        }
        if (!this.isPowered()) {
            return 9;
        }
        if (this.brewData.getEffectCounter().remainingCapacity() > 0) {
            return 12;
        }
        return 15;
    }

    private float getNeededPower(int currentPower, AtomicInteger risk) {
        if (currentPower == 0) {
            return 0.0f;
        }
        if (this.fluid == 3000 && this.brewData.isRitualTriggered()) {
            Block smallCircleGlyph = WitcheryUtils.getCircleGlyph((IBlockAccess)this.field_145850_b, this.func_174877_v(), 1);
            Block mediumCircleGlyph = WitcheryUtils.getCircleGlyph((IBlockAccess)this.field_145850_b, this.func_174877_v(), 3);
            boolean safePowerIncrease = smallCircleGlyph == WitcheryBlocks.GLYPH_RITUAL;
            boolean riskyPowerIncrease = smallCircleGlyph == WitcheryBlocks.GLYPH_INFERNAL;
            boolean safePowerIncrease2 = mediumCircleGlyph == WitcheryBlocks.GLYPH_RITUAL;
            boolean riskyPowerIncrease2 = mediumCircleGlyph == WitcheryBlocks.GLYPH_INFERNAL;
            float powerScale = 1.4f;
            if (safePowerIncrease) {
                powerScale -= 0.2f;
            }
            if (safePowerIncrease2) {
                powerScale -= 0.2f;
            }
            if (!safePowerIncrease && !safePowerIncrease2) {
                risk.incrementAndGet();
            }
            if (riskyPowerIncrease) {
                risk.incrementAndGet();
                powerScale -= 0.37f;
            }
            if (riskyPowerIncrease2) {
                risk.incrementAndGet();
                powerScale -= 0.37f;
            }
            return (float)currentPower * powerScale;
        }
        return currentPower;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean sync = false;
            Block blockBelow = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c();
            if (blockBelow == Blocks.field_150480_ab && this.isFilled()) {
                if (this.ticksHeated < 100 && ++this.ticksHeated == 100) {
                    sync = true;
                }
            } else if (this.ticksHeated > 0) {
                this.ticksHeated = 0;
                sync = true;
            }
            ItemStack craftedStack = ItemStack.field_190927_a;
            if (this.isRitualTriggered() && this.recipeCandidates != null && this.currentRecipe == null) {
                for (CauldronRecipe recipeCandidate : this.recipeCandidates) {
                    craftedStack = recipeCandidate.craft(this);
                    if (craftedStack.func_190926_b()) continue;
                    this.currentRecipe = recipeCandidate;
                    break;
                }
            }
            int power = this.currentRecipe == null ? this.getPower() : this.currentRecipe.getPower();
            AtomicInteger risk = new AtomicInteger();
            float powerNeeded = -1.0f;
            if (this.isBoiling() && this.ticks % 20L == 7L) {
                boolean wasPowered = this.powered;
                powerNeeded = this.getNeededPower(power, risk);
                if (powerNeeded <= 0.0f) {
                    this.powered = true;
                } else {
                    IPowerSource source = PowerSources.findClosestPowerSource(this);
                    boolean bl = this.powered = source != null && powerNeeded <= source.getCurrentPower();
                }
                if (wasPowered != this.powered) {
                    sync = true;
                }
            }
            if (this.ticks % 10L == 8L) {
                int oldRitualTicks = this.ritualTicks++;
                int x = this.func_174877_v().func_177958_n();
                int y = this.func_174877_v().func_177956_o();
                int z = this.func_174877_v().func_177952_p();
                if (this.isBoiling() && this.isPowered() && this.fluid == 3000) {
                    if (this.isRitualTriggered()) {
                        int witchCount = 0;
                        List<EntityCovenWitch> covenWitches = EntityUtil.getEntitiesInRadius(EntityCovenWitch.class, this, 6.0);
                        for (EntityCovenWitch witch : covenWitches) {
                            if (witch.func_70902_q() == null) continue;
                            ++witchCount;
                        }
                        List<EntityPlayer> playerWitches = EntityUtil.getEntitiesInRadius(EntityPlayer.class, this, 6.0);
                        boolean playerCoven = false;
                        for (EntityPlayer player : playerWitches) {
                            if (WitcheryUtils.getExtension((EntityPlayer)player).coven.isEmpty()) continue;
                            if (playerCoven) {
                                ++witchCount;
                                continue;
                            }
                            playerCoven = true;
                        }
                        if (this.ritualTicks > 20) {
                            IPowerSource powerSource = PowerSources.findClosestPowerSource(this);
                            if (powerNeeded < 0.0f) {
                                powerNeeded = this.getNeededPower(power, risk);
                            }
                            if (powerNeeded <= 0.0f || powerSource != null && powerSource.consumePower(powerNeeded)) {
                                RitualStatus status;
                                boolean leonardPresent = false;
                                for (EntityLeonard leonard : this.field_145850_b.func_72872_a(EntityLeonard.class, new AxisAlignedBB(this.func_174877_v().func_177982_a(-16, -16, -16), this.func_174877_v().func_177982_a(16, 16, 16)))) {
                                    if (leonard.field_70128_L || !(leonard.func_110143_aJ() > 1.0f)) continue;
                                    leonardPresent = true;
                                    risk.incrementAndGet();
                                    break;
                                }
                                if (craftedStack.func_190926_b() && this.currentRecipe != null) {
                                    craftedStack = this.currentRecipe.craft(this);
                                }
                                if (!craftedStack.func_190926_b()) {
                                    EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, craftedStack);
                                    item.field_70159_w = 0.0;
                                    item.field_70181_x = 0.2;
                                    item.field_70179_y = 0.0;
                                    this.field_145850_b.func_72838_d((Entity)item);
                                    status = RitualStatus.success(true);
                                } else {
                                    status = this.currentRecipe == null && this.recipeCandidates != null ? RitualStatus.failure(RitualStatus.Failure.OTHER_FAILURE) : WitcheryBrewEffects.updateRitual(this.field_145850_b.func_73046_m(), this, witchCount, this.ritualTicks - 20, leonardPresent);
                                }
                                switch (status.getType()) {
                                    case ONGOING: {
                                        this.checkForMisfortune(risk.get(), power);
                                        break;
                                    }
                                    case COMPLETE: {
                                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
                                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5, 0.5f, 1.0f, EnumParticleTypes.SPELL), this.field_145850_b, this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, this.field_174879_c.func_177952_p(), 8.0);
                                        this.drain(this.getLiquidQuantity(), true);
                                        this.ritualTicks = 0;
                                        this.powered = false;
                                        this.ticksHeated = 0;
                                        sync = true;
                                        this.checkForMisfortune(risk.get(), power);
                                        break;
                                    }
                                    case FAILED: {
                                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
                                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5, 0.5f, 1.0f, status.getFailure().getColor()), this.field_145850_b, this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, this.field_174879_c.func_177952_p(), 8.0);
                                        if (this.recipeCandidates == null) {
                                            this.addedStacks.remove(this.addedStacks.size() - 1);
                                            this.getActions().actions.remove(this.getActions().actions.size() - 1);
                                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)x, (double)y, (double)z, this.getActions().items.remove(this.getActions().items.size() - 1)));
                                        } else {
                                            ItemStack removedStack = this.addedStacks.remove(this.addedStacks.size() - 1);
                                            if (this.getActions().getTopItemStack() == removedStack) {
                                                this.getActions().actions.remove(this.getActions().actions.size() - 1);
                                                this.getActions().items.remove(this.getActions().items.size() - 1);
                                            }
                                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)x, (double)y, (double)z, removedStack));
                                        }
                                        this.brewData.setRitualTriggered(false);
                                        this.ritualTicks = 0;
                                        sync = true;
                                    }
                                }
                            } else if (this.ritualTicks > 21) {
                                this.drain(this.getLiquidQuantity(), true);
                                this.ritualTicks = 0;
                                this.powered = false;
                                this.ticksHeated = 0;
                                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
                                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5, 0.5f, 1.0f, -7829504), this.field_145850_b, this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, this.field_174879_c.func_177952_p(), 8.0);
                                sync = true;
                            }
                        }
                    }
                } else {
                    if (this.ritualTicks > 20) {
                        this.drain(this.getLiquidQuantity(), true);
                        this.ritualTicks = 0;
                        this.powered = false;
                        this.ticksHeated = 0;
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5, 0.5f, 1.0f, -7829504), this.field_145850_b, this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, this.field_174879_c.func_177952_p(), 8.0);
                        sync = true;
                    }
                    this.ritualTicks = 0;
                }
                if (this.ritualTicks != oldRitualTicks) {
                    sync = true;
                }
            }
            if (sync) {
                this.notifyBlockUpdate(true);
            }
        }
    }

    private void checkForMisfortune(int risk, int power) {
        if (risk > 0 && power > 0) {
            double roll = this.field_145850_b.field_73012_v.nextDouble() * (1.0 + (double)(risk - 1) * 0.2);
            if (roll < 0.5) {
                return;
            }
            if (roll < 0.75) {
                this.applyToAllNear(new PotionEffect(MobEffects.field_76421_d, 1200, 1));
            } else if (roll < 0.9) {
                this.applyToAllNear(new PotionEffect(WitcheryPotionEffects.PARALYSED, 400, 2));
            } else if (roll < 0.98) {
                this.applyToAllNear(new PotionEffect(WitcheryPotionEffects.INSANITY, 3600, 2));
            } else {
                this.applyToAllNear(new PotionEffect(WitcheryPotionEffects.PARALYSED, 200, 2));
                for (int i = 0; i < this.field_145850_b.field_73012_v.nextInt(3) + 2; ++i) {
                    this.spawnBolt(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
                }
            }
        }
    }

    private void applyToAllNear(PotionEffect effect) {
        double R = 16.0;
        double RSq = 256.0;
        AxisAlignedBB bounds = new AxisAlignedBB(this.func_174877_v().func_177963_a(-R, -R, -R), this.func_174877_v().func_177963_a(R, R, R));
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, bounds);
        for (EntityLivingBase entity : entities) {
            if (!(entity.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, entity.field_70163_u, (double)this.func_174877_v().func_177952_p() + 0.5) < RSq) || entity instanceof IMob || !entity.func_184222_aU()) continue;
            ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
            Collection effects2 = entity.func_70651_bq();
            for (PotionEffect buff : effects2) {
                Potion potion = buff.func_188419_a();
                if (WitcheryPotion.isDebuff(potion)) continue;
                effectsToRemove.add(potion);
            }
            for (Potion potion2 : effectsToRemove) {
                entity.func_184589_d(potion2);
            }
            entity.func_70690_d(new PotionEffect(effect));
        }
    }

    private void spawnBolt(World world, int posX, int posY, int posZ) {
        int activeRadius = 3;
        int ax = world.field_73012_v.nextInt(activeRadius * 2 + 1);
        if (ax > activeRadius) {
            ax += 2;
        }
        int x = posX - 4 + ax;
        int az = world.field_73012_v.nextInt(activeRadius * 2 + 1);
        if (az > activeRadius) {
            az += 2;
        }
        int z = posZ - 4 + az;
        EntityLightningBolt bolt = new EntityLightningBolt(world, (double)x, (double)posY, (double)z, false);
        world.func_72942_c((Entity)bolt);
    }

    public boolean isRitualInProgress() {
        return this.ritualTicks > 0;
    }

    public boolean addItem(BrewAction brewAction, ItemStack entityItem) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (WitcheryBrewEffects.canNotAdd(this, brewAction, this.fluid == 3000)) {
            return false;
        }
        if (brewAction != null) {
            this.brewData.getActions().nullifyItems(brewAction);
            this.brewData.getActions().items.add(entityItem);
            this.brewData.getActions().actions.add(brewAction);
            if (brewAction.triggersRitual()) {
                this.brewData.setRitualTriggered(true);
                this.ritualTicks = 0;
            }
        }
        this.addedStacks.add(entityItem);
        List<CauldronRecipe> recipes = WitcheryUtils.getRecipeManager(this.field_145850_b).getRecipes(WitcheryRecipeTypes.CAULDRON, this, this.field_145850_b);
        if (!recipes.isEmpty()) {
            this.recipeCandidates = recipes;
            this.brewData.setRitualTriggered(true);
            this.ritualTicks = 0;
        }
        this.notifyBlockUpdate(true);
        return true;
    }

    public boolean explodeBrew(EntityPlayer nearestPlayer) {
        if (this.field_145850_b.field_72995_K || nearestPlayer == null) {
            return false;
        }
        if (!this.isFilled()) {
            return false;
        }
        if (this.brewData.getActions().items.isEmpty()) {
            return false;
        }
        this.field_145850_b.func_72876_a((Entity)nearestPlayer, 0.5 + (double)this.func_174877_v().func_177958_n(), 1.5 + (double)this.func_174877_v().func_177956_o(), 0.5 + (double)this.func_174877_v().func_177952_p(), Math.min(1.0f + (float)this.brewData.getActions().size() * 0.5f, 10.0f), false);
        return true;
    }

    public int getColor() {
        return WitcheryUtils.getBrewColor(this.getActions().items);
    }

    public int getPower() {
        int power = 0;
        for (BrewAction action : this.getActions().actions) {
            power += action.getPowerCost();
        }
        return power;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(this.brewData.getActions().size() > 0 ? WitcheryFluids.BREW : FluidRegistry.WATER, 3000), 3000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isFluidEqual(resource)) {
            int filled = Math.min(resource.amount, 3000);
            if (filled > 3000 - this.fluid) {
                filled = 3000 - this.fluid;
            }
            if (doFill) {
                this.fluid += filled;
                this.notifyBlockUpdate(false);
            }
            return filled;
        }
        return 0;
    }

    private boolean isFluidEqual(FluidStack stack) {
        if (this.canFill(stack.getFluid())) {
            if (stack.tag == null) {
                return this.brewData.getActions().size() == 0;
            }
            NBTTagList items = stack.tag.func_150295_c("Items", 10);
            if (items.func_74745_c() != this.brewData.getActions().size()) {
                return false;
            }
            for (int i = 0; i < items.func_74745_c(); ++i) {
                if (this.brewData.getActions().items.get(i).func_77969_a(new ItemStack(items.func_150305_b(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !this.isFluidEqual(resource)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int drained = Math.min(maxDrain, this.fluid);
        if (drained > 0) {
            FluidStack stack = new FluidStack(this.brewData.getActions().size() == 0 ? FluidRegistry.WATER : WitcheryFluids.BREW, drained);
            if (doDrain) {
                this.fluid -= stack.amount;
            }
            if (this.fluid <= 0) {
                this.fluid = 0;
                this.powered = false;
                this.ritualTicks = 0;
                this.brewData = new CauldronBrewData();
                this.recipeCandidates = null;
                this.currentRecipe = null;
            }
            this.notifyBlockUpdate(false);
            return stack;
        }
        return null;
    }

    public boolean canFill(Fluid fluid) {
        return fluid != null && (fluid == FluidRegistry.WATER || fluid == WitcheryFluids.BREW);
    }

    public boolean isFilled() {
        return this.fluid > 0;
    }

    public int getLiquidQuantity() {
        return this.fluid;
    }

    public double getPercentFilled() {
        return (double)this.fluid / 3000.0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.func_145839_a(packet2.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.brewData.read(tag);
        this.fluid = tag.func_74762_e("Fluid");
        this.ticksHeated = tag.func_74762_e("TicksHeated");
        this.powered = tag.func_74767_n("Powered");
        this.ritualTicks = tag.func_74762_e("RitualTicks");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("TicksHeated", this.ticksHeated);
        tag.func_74757_a("Powered", this.powered);
        tag.func_74768_a("RitualTicks", this.ritualTicks);
        tag.func_74768_a("Fluid", this.fluid);
        this.brewData.write(tag);
        return super.func_189515_b(tag);
    }

    public NBTTagCompound writeFluid(NBTTagCompound compound) {
        this.brewData.writeItems(compound);
        return compound;
    }

    public int getRitualSeconds() {
        return this.ritualTicks;
    }

    @Override
    public int getQuantity() {
        return 3000;
    }

    public BrewActionList getActions() {
        return this.brewData.getActions();
    }

    public EffectLevelCounter getEffectCounter() {
        return this.brewData.getEffectCounter();
    }

    public boolean isRitualTriggered() {
        return this.brewData.isRitualTriggered();
    }

    public boolean isSplash() {
        for (BrewAction action : this.getActions().actions) {
            if (!action.createsSplash()) continue;
            return true;
        }
        return false;
    }

    public boolean isLingering() {
        boolean splash = false;
        boolean linger = false;
        for (BrewAction action : this.getActions().actions) {
            if (action.createsSplash()) {
                if (linger) {
                    return true;
                }
                splash = true;
                continue;
            }
            if (!action.lingers()) continue;
            if (splash) {
                return true;
            }
            linger = true;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.addedStacks.size();
    }

    public boolean func_191420_l() {
        return this.addedStacks.stream().allMatch(ItemStack::func_190926_b);
    }

    public ItemStack func_70301_a(int index) {
        return this.addedStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        for (CauldronRecipe recipe : WitcheryUtils.getRecipeManager(this.field_145850_b).getRecipesForType(WitcheryRecipeTypes.CAULDRON)) {
            if (!recipe.isItemValid(stack)) continue;
            return true;
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public String func_70005_c_() {
        return "witchery.cauldron";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack getTopStack() {
        return this.addedStacks.isEmpty() ? ItemStack.field_190927_a : this.addedStacks.get(this.addedStacks.size() - 1);
    }
}

