/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.resources.RiteManager;
import net.msrandom.witchery.rite.Rite;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.RitualCircle;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.SacrificedItemReturn;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class TileEntityCircle
extends WitcheryTileEntity {
    private static final BlockPos[] COVEN_WITCH_POSITIONS = new BlockPos[]{new BlockPos(-2, 0, -2), new BlockPos(2, 0, -2), new BlockPos(-2, 0, 2), new BlockPos(2, 0, 2), new BlockPos(0, 0, 3), new BlockPos(0, 0, -3)};
    private final List<ActivatedRitual> activeRituals = new ArrayList<ActivatedRitual>();
    private final List<ActivatedRitual> upkeepRituals = new ArrayList<ActivatedRitual>();
    public boolean previousRedstoneState;
    private boolean abortNext;
    public boolean active;

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTag) {
        NBTTagList rituals = new NBTTagList();
        for (ActivatedRitual upkeepRitual : this.upkeepRituals) {
            rituals.func_74742_a((NBTBase)upkeepRitual.serialize());
        }
        nbtTag.func_74782_a("Rituals", (NBTBase)rituals);
        nbtTag.func_74757_a("Active", this.active);
        return super.func_189515_b(nbtTag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.upkeepRituals.clear();
        if (tag.func_74764_b("Rituals")) {
            NBTTagList rituals = tag.func_150295_c("Rituals", 10);
            for (int i = 0; i < rituals.func_74745_c(); ++i) {
                ActivatedRitual ritual = ActivatedRitual.deserialize(rituals.func_150305_b(i));
                if (ritual == null) continue;
                this.upkeepRituals.add(ritual);
            }
        }
        this.active = tag.func_74767_n("Active");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            List<RiteEffect> effects2;
            if (!this.upkeepRituals.isEmpty()) {
                Iterator<ActivatedRitual> iterator2 = this.upkeepRituals.iterator();
                while (iterator2.hasNext()) {
                    ActivatedRitual upkeepRitual = iterator2.next();
                    effects2 = RiteManager.INSTANCE.getEffects(upkeepRitual.rite);
                    RiteHandler.Result result2 = upkeepRitual.currentEffectIndex >= effects2.size() ? RiteHandler.Result.COMPLETED : effects2.get(upkeepRitual.currentEffectIndex).run(this.field_145850_b, this.func_174877_v(), (int)this.ticks, upkeepRitual.stage, upkeepRitual);
                    switch (result2) {
                        case COMPLETED: {
                            ++upkeepRitual.currentEffectIndex;
                            if (upkeepRitual.currentEffectIndex < effects2.size()) break;
                            iterator2.remove();
                            break;
                        }
                        case ABORTED: 
                        case ABORTED_REFUND: {
                            iterator2.remove();
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        }
                    }
                }
            }
            if (!this.activeRituals.isEmpty()) {
                RiteHandler.Result result3;
                ActivatedRitual ritual = this.activeRituals.get(0);
                if (ritual.summoningCoven) {
                    RiteHandler.Result result4 = result3 = this.ticks % 20L == 0L ? EntityCovenWitch.processCovenSummon(ritual.getInitiatingPlayer(this.field_145850_b), ritual.currentCovenIndex, this.func_174877_v().func_177971_a((Vec3i)COVEN_WITCH_POSITIONS[ritual.currentCovenIndex++])) : RiteHandler.Result.STARTING;
                    if (result3 == RiteHandler.Result.COMPLETED) {
                        result3 = RiteHandler.Result.STARTING;
                        if (ritual.currentCovenIndex == ritual.covenSize) {
                            ritual.summoningCoven = false;
                        }
                    }
                } else if (ritual.currentSacrificeIndex < ritual.rite.getSacrifices().size()) {
                    if (ritual.sacrificeFail != null && ritual.currentSacrificeIndex == (Integer)ritual.sacrificeFail.getSecond()) {
                        RiteEffect.error((String)ritual.sacrificeFail.getFirst(), ritual.getInitiatingPlayer(this.field_145850_b));
                        result3 = RiteHandler.Result.ABORTED_REFUND;
                    } else {
                        result3 = ritual.rite.getSacrifices().get(ritual.currentSacrificeIndex).run(this.field_145850_b, this.func_174877_v(), (int)this.ticks, ritual.stage, ritual);
                        if (result3 == RiteHandler.Result.COMPLETED) {
                            ++ritual.currentSacrificeIndex;
                            result3 = RiteHandler.Result.STARTING;
                        }
                    }
                } else {
                    effects2 = RiteManager.INSTANCE.getEffects(ritual.rite);
                    if (ritual.currentEffectIndex < effects2.size()) {
                        result3 = effects2.get(ritual.currentEffectIndex).run(this.field_145850_b, this.func_174877_v(), (int)this.ticks, ritual.stage, ritual);
                        if (result3 == RiteHandler.Result.COMPLETED) {
                            ++ritual.currentEffectIndex;
                            if (ritual.currentEffectIndex < effects2.size()) {
                                result3 = RiteHandler.Result.STARTING;
                            }
                        }
                    } else {
                        result3 = RiteHandler.Result.COMPLETED;
                    }
                }
                ritual.postProcess(this.field_145850_b);
                if (this.abortNext) {
                    this.abortNext = false;
                    result3 = RiteHandler.Result.ABORTED_REFUND;
                    this.activeRituals.clear();
                }
                switch (result3) {
                    case UPKEEP: {
                        if (this.activeRituals.size() > 0) {
                            this.activeRituals.remove(0);
                        }
                        this.upkeepRituals.add(ritual);
                        break;
                    }
                    case COMPLETED: {
                        if (this.activeRituals.size() <= 0) break;
                        this.activeRituals.remove(0);
                        break;
                    }
                    case ABORTED: 
                    case ABORTED_REFUND: {
                        EntityPlayer player;
                        EntityPlayer entityPlayer = player = this.activeRituals.isEmpty() ? null : this.activeRituals.get(0).getInitiatingPlayer(this.field_145850_b);
                        if (this.activeRituals.size() > 0) {
                            this.activeRituals.remove(0);
                        }
                        if (this.field_145850_b.field_72995_K) break;
                        if (player != null) {
                            WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                        if (result3 != RiteHandler.Result.ABORTED_REFUND) break;
                        for (Long2ObjectMap.Entry entry2 : ritual.sacrificedItems.long2ObjectEntrySet()) {
                            RiteEffect.SacrificedItem sacrificedItem = (RiteEffect.SacrificedItem)entry2.getValue();
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, 0.5 + (double)sacrificedItem.getLocation().func_177958_n(), 0.5 + (double)sacrificedItem.getLocation().func_177956_o(), 0.5 + (double)sacrificedItem.getLocation().func_177952_p(), sacrificedItem.getStack()));
                        }
                        break;
                    }
                }
            }
            if (this.active && this.activeRituals.isEmpty()) {
                this.active = false;
                BlockUtil.notifyBlockUpdate(this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public void deactivate() {
        if (!this.field_145850_b.field_72995_K) {
            EntityPlayer player;
            EntityPlayer entityPlayer = player = this.activeRituals.isEmpty() ? null : this.activeRituals.get(0).getInitiatingPlayer(this.field_145850_b);
            if (this.activeRituals.size() > 0) {
                this.abortNext = true;
            }
            this.upkeepRituals.clear();
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.field_174879_c);
            if (player != null) {
                WitcheryUtils.playSoundAt(player, SoundEvents.field_187688_dI, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public boolean isRitualActive() {
        return !this.activeRituals.isEmpty() || !this.upkeepRituals.isEmpty();
    }

    public void queueRitual(Rite rite, Pair<String, Integer> failure, AxisAlignedBB bounds, Set<RitualCircle> circles, EntityPlayer player, int covenSize, boolean summonCoven) {
        if (summonCoven) {
            for (EntityCovenWitch witch : this.field_145850_b.func_72872_a(EntityCovenWitch.class, player.func_174813_aQ().func_72314_b(64.0, 16.0, 64.0))) {
                if (!witch.func_70909_n() || witch.func_70902_q() != player) continue;
                witch.func_184185_a(SoundEvents.field_187534_aX, 0.5f, 0.4f / (witch.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                this.field_145850_b.func_72960_a((Entity)witch, (byte)16);
                witch.func_70106_y();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            ActivatedRitual ritual = new ActivatedRitual(rite, covenSize, player == null ? null : player.func_110124_au(), this.field_145850_b.field_73012_v.nextLong(), 0, bounds, circles, failure);
            ritual.starter = player;
            ritual.summoningCoven = summonCoven;
            this.activeRituals.add(ritual);
            this.active = true;
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.field_174879_c);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.func_148857_g());
    }

    public static class ActivatedRitual {
        public final UUID playerId;
        public final Long2ObjectMap<RiteEffect.SacrificedItem> sacrificedItems = new Long2ObjectOpenHashMap();
        public final AxisAlignedBB bounds;
        public final Set<RitualCircle> circles;
        public final int covenSize;
        public final Rite rite;
        public final long id;
        private final AtomicInteger stage;
        @Nullable
        private final Pair<String, Integer> sacrificeFail;
        private BlockPos position;
        private EntityPlayer starter;
        private boolean summoningCoven;
        private int currentCovenIndex;
        private int currentSacrificeIndex;
        private int currentEffectIndex;

        private ActivatedRitual(Rite rite, int covenSize, UUID playerId, long id, int stage, AxisAlignedBB bounds, Set<RitualCircle> circles, @Nullable Pair<String, Integer> sacrificeFail) {
            this.rite = rite;
            this.bounds = bounds;
            this.circles = circles;
            this.playerId = playerId;
            this.covenSize = covenSize;
            this.id = id;
            this.stage = new AtomicInteger(stage);
            this.sacrificeFail = sacrificeFail;
        }

        public static ActivatedRitual deserialize(NBTTagCompound tag) {
            Rite rite = RiteManager.INSTANCE.getRiteMap().get(new ResourceLocation(tag.func_74779_i("Rite")));
            if (rite != null) {
                ActivatedRitual ritual = new ActivatedRitual(rite, tag.func_74771_c("CovenSize"), tag.func_186857_a("Initiator"), tag.func_74763_f("ID"), tag.func_74771_c("Stage"), ActivatedRitual.readBounds(tag), ActivatedRitual.readCircles(tag), ActivatedRitual.readFailure(tag));
                ritual.position = ActivatedRitual.readPosition(tag);
                ActivatedRitual.readIndices(tag, ritual);
                ritual.summoningCoven = tag.func_74767_n("SummoningCoven");
                return ritual;
            }
            return null;
        }

        private static Pair<String, Integer> readFailure(NBTTagCompound tag) {
            if (tag.func_74764_b("Failure")) {
                NBTTagCompound failure = tag.func_74775_l("Failure");
                return TuplesKt.to(failure.func_74779_i("Error"), failure.func_74762_e("SacrificeIndex"));
            }
            return null;
        }

        public UUID getInitiatingPlayerId() {
            return this.playerId;
        }

        public EntityPlayer getInitiatingPlayer(World world) {
            if (this.starter == null) {
                this.starter = WitcheryUtils.getPlayer(world, this.getInitiatingPlayerId());
            }
            return this.starter;
        }

        public void postProcess(World world) {
            ObjectIterator iterator2 = this.sacrificedItems.long2ObjectEntrySet().iterator();
            while (iterator2.hasNext()) {
                SacrificedItemReturn returns;
                RiteEffect.SacrificedItem sacrificedItem = (RiteEffect.SacrificedItem)((Long2ObjectMap.Entry)iterator2.next()).getValue();
                if (sacrificedItem == null || (returns = sacrificedItem.getReturns()) == null) continue;
                ItemStack itemStack = returns.handleItem(sacrificedItem.getStack());
                world.func_72838_d((Entity)new EntityItem(world, 0.5 + (double)sacrificedItem.getLocation().func_177958_n(), 0.5 + (double)sacrificedItem.getLocation().func_177956_o(), 0.5 + (double)sacrificedItem.getLocation().func_177952_p(), itemStack));
                iterator2.remove();
                break;
            }
        }

        public int getCurrentStage() {
            return this.stage.get();
        }

        private static BlockPos readPosition(NBTTagCompound tag) {
            if (tag.func_74764_b("Position")) {
                return NBTUtil.func_186861_c((NBTTagCompound)tag.func_74775_l("Position"));
            }
            return null;
        }

        private static void readIndices(NBTTagCompound tag, ActivatedRitual ritual) {
            NBTTagCompound indices = tag.func_74775_l("Indices");
            ritual.currentCovenIndex = indices.func_74762_e("CovenWitch");
            ritual.currentSacrificeIndex = indices.func_74762_e("Sacrifice");
            ritual.currentEffectIndex = indices.func_74762_e("Effect");
        }

        private static AxisAlignedBB readBounds(NBTTagCompound tag) {
            NBTTagCompound bounds = tag.func_74775_l("Bounds");
            return new AxisAlignedBB(BlockPos.func_177969_a((long)bounds.func_74763_f("From")), BlockPos.func_177969_a((long)bounds.func_74763_f("To")));
        }

        private static Set<RitualCircle> readCircles(NBTTagCompound tag) {
            HashSet<RitualCircle> circles = new HashSet<RitualCircle>();
            WitcheryUtils.forEachCompound(tag.func_150295_c("Circles", 10), circleTag -> {
                circles.add(RitualCircle.deserialize(circleTag));
                return Unit.INSTANCE;
            });
            return circles;
        }

        public BlockPos getLocation() {
            return this.position;
        }

        public void setLocation(BlockPos coord) {
            this.position = coord;
        }

        public NBTTagCompound serialize() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Rite", this.rite.getId().toString());
            tag.func_74774_a("CovenSize", (byte)this.covenSize);
            tag.func_186854_a("Initiator", this.getInitiatingPlayerId());
            tag.func_74772_a("ID", this.id);
            tag.func_74774_a("Stage", (byte)this.getCurrentStage());
            this.writeBounds(tag);
            this.writeCircles(tag);
            this.writeFailure(tag);
            this.writePosition(tag);
            this.writeIndices(tag);
            tag.func_74757_a("SummoningCoven", this.summoningCoven);
            return tag;
        }

        private void writeBounds(NBTTagCompound tag) {
            NBTTagCompound boundsTag = new NBTTagCompound();
            boundsTag.func_74772_a("From", new BlockPos(this.bounds.field_72340_a, this.bounds.field_72338_b, this.bounds.field_72339_c).func_177986_g());
            boundsTag.func_74772_a("To", new BlockPos(this.bounds.field_72336_d, this.bounds.field_72337_e, this.bounds.field_72334_f).func_177986_g());
            tag.func_74782_a("Bounds", (NBTBase)boundsTag);
        }

        private void writeCircles(NBTTagCompound tag) {
            NBTTagList circlesList = new NBTTagList();
            for (RitualCircle circle : this.circles) {
                circlesList.func_74742_a((NBTBase)circle.serialize());
            }
            tag.func_74782_a("Circles", (NBTBase)circlesList);
        }

        private void writeFailure(NBTTagCompound tag) {
            if (this.sacrificeFail != null) {
                NBTTagCompound failure = new NBTTagCompound();
                failure.func_74778_a("Error", this.sacrificeFail.getFirst());
                failure.func_74768_a("SacrificeIndex", this.sacrificeFail.getSecond().intValue());
                tag.func_74782_a("Failure", (NBTBase)tag);
            }
        }

        private void writePosition(NBTTagCompound tag) {
            if (this.position != null) {
                tag.func_74782_a("Position", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.position));
            }
        }

        private void writeIndices(NBTTagCompound tag) {
            NBTTagCompound indices = new NBTTagCompound();
            indices.func_74768_a("CovenWitch", this.currentCovenIndex);
            indices.func_74768_a("Sacrifice", this.currentSacrificeIndex);
            indices.func_74768_a("Effect", this.currentEffectIndex);
            tag.func_74782_a("Indices", (NBTBase)indices);
        }
    }
}

