/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityCursedBlock
extends WitcheryTileEntity {
    public BrewActionList actionList;
    public int duration;
    public int expansion;
    public int count;
    public UUID thrower;

    public void initialize(ModifiersImpact impactModifiers, BrewActionList actionList) {
        this.actionList = actionList;
        this.duration = impactModifiers.lifetime.get() >= 0 ? 5 + impactModifiers.lifetime.get() * impactModifiers.lifetime.get() * 5 : 100;
        this.expansion = Math.min(4 + impactModifiers.extent.get(), 10);
        if (impactModifiers.thrower != null) {
            this.thrower = impactModifiers.thrower.func_110124_au();
        }
        this.count = 1;
        BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
    }

    public void updateCurse(ModifiersImpact impactModifiers, BrewActionList actionList) {
        if (this.actionList.equals(actionList)) {
            ++this.count;
        } else {
            this.actionList = actionList;
            this.count = 1;
            this.duration = impactModifiers.lifetime.get() >= 0 ? 5 + impactModifiers.lifetime.get() * impactModifiers.lifetime.get() * 5 : 100;
            this.expansion = Math.min(4 + impactModifiers.extent.get(), 10);
            if (impactModifiers.thrower != null) {
                this.thrower = impactModifiers.thrower.func_110124_au();
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.func_145839_a(packet2.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtRoot) {
        super.func_189515_b(nbtRoot);
        nbtRoot.func_74782_a("Effect", (NBTBase)this.actionList.write());
        nbtRoot.func_74768_a("Duration", this.duration);
        nbtRoot.func_74768_a("Expansion", this.expansion);
        nbtRoot.func_74768_a("Count", this.count);
        if (this.thrower != null) {
            nbtRoot.func_186854_a("Creator", this.thrower);
        }
        return nbtRoot;
    }

    public void func_145839_a(NBTTagCompound nbtRoot) {
        super.func_145839_a(nbtRoot);
        this.actionList = new BrewActionList(nbtRoot.func_150295_c("Effect", 10));
        this.duration = nbtRoot.func_74762_e("Duration");
        this.expansion = nbtRoot.func_74762_e("Expansion");
        this.count = nbtRoot.func_74762_e("Count");
        if (nbtRoot.func_186855_b("Creator")) {
            this.thrower = nbtRoot.func_186857_a("Creator");
        }
    }

    public boolean applyToEntityAndDestroy(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living2 = (EntityLivingBase)entity;
            EntityPlayer player = WitcheryUtils.getPlayer(this.field_145850_b, this.thrower);
            if (player == null) {
                player = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(this.thrower, null));
            }
            this.actionList.applyToEntity(entity.field_70170_p, living2, new ModifiersEffect(1.0, 1.0, false, living2.func_174791_d(), false, 0, player));
            living2.field_70170_p.func_184133_a(null, living2.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 0.4f / (living2.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(living2.field_70165_t, living2.field_70163_u, living2.field_70161_v, 1.0f, 1.0f, 0xFFFFFF), (Entity)living2);
        }
        return --this.count <= 0;
    }
}

