/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockDistillery;
import net.msrandom.witchery.block.entity.TileEntityAltar;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.recipe.DistilleryRecipe;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityDistillery
extends TileEntity
implements ISidedInventory,
ITickable {
    static final int COOK_TIME = 800;
    static final float POWER_PER_TICK = 0.6f;
    private static final int THROTTLE = 20;
    private static final int[] slots_top = new int[]{0, 1, 2};
    private static final int[] slots_bottom = new int[]{0, 1, 2};
    private static final int[] slots_sides = new int[]{0, 1, 2, 3, 4, 5, 6};
    public int currentItemBurnTime;
    public int furnaceCookTime;
    public int powerLevel;
    BlockPos powerSourceCoord;
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
    private long ticks;
    private long lastUpdate = 0L;
    private boolean needUpdate = false;

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.furnaceItemStacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int par1) {
        return (ItemStack)this.furnaceItemStacks.get(par1);
    }

    public ItemStack func_70298_a(int par1, int par2) {
        return ItemStackHelper.func_188382_a(this.furnaceItemStacks, (int)par1, (int)par2);
    }

    public ItemStack func_70304_b(int par1) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)par1);
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.furnaceItemStacks.set(par1, (Object)par2ItemStack);
        if (!par2ItemStack.func_190926_b() && par2ItemStack.func_190916_E() > this.func_70297_j_()) {
            par2ItemStack.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        return this.func_145838_q().func_149732_F();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Items", 10);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.furnaceItemStacks.size()) continue;
            this.furnaceItemStacks.set((int)b0, (Object)new ItemStack(nbttagcompound1));
        }
        this.furnaceCookTime = par1NBTTagCompound.func_74765_d("CookTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("CookTime", (short)this.furnaceCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.furnaceItemStacks.get(i)).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        return par1NBTTagCompound;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / 800;
    }

    IPowerSource getPowerSource() {
        if (this.powerSourceCoord == null || this.ticks % 100L == 0L) {
            return this.findNewPowerSource();
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.powerSourceCoord);
        if (!(tileEntity instanceof TileEntityAltar)) {
            return this.findNewPowerSource();
        }
        TileEntityAltar altarTileEntity = (TileEntityAltar)tileEntity;
        if (!altarTileEntity.isValid()) {
            return this.findNewPowerSource();
        }
        return altarTileEntity;
    }

    private IPowerSource findNewPowerSource() {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(this.field_145850_b, this.field_174879_c);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            boolean powered;
            boolean cooking = this.furnaceCookTime > 0;
            boolean bl = powered = this.powerLevel > 0;
            if (this.recipeToSmelt() != null) {
                IPowerSource powerSource = this.getPowerSource();
                this.powerSourceCoord = powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord) ? powerSource.getLocation() : null;
                int n = this.powerLevel = powerSource != null ? 1 : 0;
                if (powerSource != null && powerSource.consumePower(0.6f)) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == 800) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.powerLevel = 0;
                }
            } else {
                if (this.ticks % 40L == 0L) {
                    IPowerSource powerSource = this.getPowerSource();
                    if (powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord)) {
                        this.powerSourceCoord = powerSource.getLocation();
                    }
                    this.powerLevel = powerSource != null ? 1 : 0;
                }
                this.furnaceCookTime = 0;
            }
            if (cooking != this.furnaceCookTime > 0) {
                BlockDistillery.updateDistilleryBlockState(this.furnaceCookTime > 0 && this.powerLevel > 0, this.field_145850_b, this.func_174877_v());
                this.lastUpdate = this.ticks;
                this.needUpdate = false;
            } else if (powered != this.powerLevel > 0) {
                if (this.ticks - this.lastUpdate > 20L) {
                    BlockDistillery.updateDistilleryBlockState(this.furnaceCookTime > 0 && this.powerLevel > 0, this.field_145850_b, this.func_174877_v());
                    this.lastUpdate = this.ticks;
                    this.needUpdate = false;
                } else {
                    this.needUpdate = true;
                }
            } else if (this.needUpdate && this.ticks - this.lastUpdate > 20L) {
                BlockDistillery.updateDistilleryBlockState(this.furnaceCookTime > 0 && this.powerLevel > 0, this.field_145850_b, this.func_174877_v());
                this.lastUpdate = this.ticks;
                this.needUpdate = false;
            }
            if (flag1) {
                BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
            }
        }
        ++this.ticks;
    }

    private DistilleryRecipe recipeToSmelt() {
        Optional<DistilleryRecipe> optionalRecipe = this.getActiveRecipe();
        if (!optionalRecipe.isPresent()) {
            return null;
        }
        DistilleryRecipe recipe = optionalRecipe.get();
        NonNullList<ItemStack> itemstacks = recipe.getOutputs();
        for (int i = 0; i < itemstacks.size(); ++i) {
            int newSize;
            ItemStack current = (ItemStack)this.furnaceItemStacks.get(i + 3);
            if (!current.func_77969_a((ItemStack)itemstacks.get(i)) || (newSize = current.func_190916_E() + ((ItemStack)itemstacks.get(i)).func_190916_E()) <= this.func_70297_j_() && newSize <= current.func_77976_d()) continue;
            return null;
        }
        return recipe;
    }

    public Optional<DistilleryRecipe> getActiveRecipe() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b() && ((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
            return Optional.empty();
        }
        return WitcheryUtils.getRecipeManager(this.field_145850_b).getRecipe(WitcheryRecipeTypes.DISTILLERY, this, this.field_145850_b);
    }

    public void smeltItem() {
        DistilleryRecipe recipe = this.recipeToSmelt();
        if (recipe != null) {
            NonNullList<ItemStack> itemstacks = recipe.getOutputs();
            for (int i = 0; i < itemstacks.size(); ++i) {
                int furnaceIndex = i + 3;
                ItemStack stack = (ItemStack)itemstacks.get(i);
                if (stack.func_190926_b()) continue;
                if (((ItemStack)this.furnaceItemStacks.get(furnaceIndex)).func_190926_b()) {
                    this.furnaceItemStacks.set(furnaceIndex, (Object)stack.func_77946_l());
                    continue;
                }
                if (!((ItemStack)this.furnaceItemStacks.get(furnaceIndex)).func_77969_a(stack)) continue;
                ItemStack itemStack = (ItemStack)this.furnaceItemStacks.get(furnaceIndex);
                itemStack.func_190917_f(stack.func_190916_E());
            }
            if (!((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
                ItemStack itemStack2 = (ItemStack)this.furnaceItemStacks.get(0);
                itemStack2.func_190918_g(1);
            }
            if (!((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
                ItemStack itemStack3 = (ItemStack)this.furnaceItemStacks.get(1);
                itemStack3.func_190918_g(1);
            }
            if (!((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b()) {
                ItemStack itemStack4 = (ItemStack)this.furnaceItemStacks.get(2);
                itemStack4.func_190918_g(recipe.getJars());
            }
        }
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (slot > 3) {
            return false;
        }
        if (slot == 2) {
            return itemstack.func_77973_b() == WitcheryFumeItems.CLAY_JAR;
        }
        return itemstack.func_77973_b() != WitcheryFumeItems.CLAY_JAR;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceCookTime;
            }
            case 1: {
                return this.powerLevel;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceCookTime = value;
                break;
            }
            case 1: {
                this.powerLevel = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.furnaceItemStacks.clear();
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slots_bottom : (side == EnumFacing.UP ? slots_top : slots_sides);
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing par3) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP && (slot == 3 || slot == 4 || slot == 5 || slot == 6);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.func_145839_a(packet2.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }
}

