/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockDreamWeaver;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryCreatureTraits;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityDreamWeaver
extends TileEntity
implements ITickable {
    private boolean buffIfDay;
    private boolean buffIfNight;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.buffIfDay || this.buffIfNight) {
                boolean day = this.field_145850_b.func_72935_r();
                if (this.buffIfDay && day || this.buffIfNight && !day) {
                    boolean isDream = true;
                    boolean isEnhanced = false;
                    int r = 5;
                    boolean done = false;
                    for (int y = this.func_174877_v().func_177956_o() - r; y <= this.func_174877_v().func_177956_o() + r && !done; ++y) {
                        for (int x = this.func_174877_v().func_177958_n() - r; x <= this.func_174877_v().func_177958_n() + r && !done; ++x) {
                            for (int z = this.func_174877_v().func_177952_p() - r; z <= this.func_174877_v().func_177952_p() + r && !done; ++z) {
                                Block block;
                                BlockPos pos = new BlockPos(x, y, z);
                                if (y == this.func_174877_v().func_177956_o() && x == this.func_174877_v().func_177958_n() && z == this.func_174877_v().func_177952_p() || !((block = this.field_145850_b.func_180495_p(pos).func_177230_c()) instanceof BlockDreamWeaver)) continue;
                                if (((BlockDreamWeaver)block).getModifier() == BlockDreamWeaver.Modifier.CAUSES_NIGHTMARES) {
                                    isDream = false;
                                    done = isEnhanced;
                                    continue;
                                }
                                if (((BlockDreamWeaver)block).getModifier() != BlockDreamWeaver.Modifier.ENHANCED_DREAMS) continue;
                                isEnhanced = true;
                                done = !isDream;
                            }
                        }
                    }
                    AxisAlignedBB bounds = new AxisAlignedBB(this.func_174877_v().func_177982_a(-5, -5, -5), this.func_174877_v().func_177982_a(5, 5, 5));
                    List list2 = this.field_145850_b.func_72872_a(EntityPlayer.class, bounds);
                    for (EntityPlayer player : list2) {
                        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                        if ((!day || playerEx.isTransformation(WitcheryCreatureTraits.VAMPIRE)) && (day || !playerEx.isTransformation(WitcheryCreatureTraits.VAMPIRE))) continue;
                        ((BlockDreamWeaver)this.func_145838_q()).applyEffect(player, isDream, isEnhanced);
                    }
                }
                this.buffIfNight = false;
                this.buffIfDay = false;
            }
            if (this.areAllPlayersAsleep(this.field_145850_b)) {
                this.buffIfDay = !this.field_145850_b.field_73011_w.isDaytime();
                this.buffIfNight = !this.buffIfDay;
            }
        }
    }

    private boolean areAllPlayersAsleep(World world) {
        Iterator iterator2 = world.field_73010_i.iterator();
        int sleepThreshold = MathHelper.func_76141_d((float)(0.01f * (float)WitcheryConfigOptions.percentageOfPlayersSleepingForBuff * (float)world.field_73010_i.size()));
        while (iterator2.hasNext()) {
            EntityPlayer entityplayer = (EntityPlayer)iterator2.next();
            if (!entityplayer.func_70608_bn() || --sleepThreshold > 0) continue;
            return true;
        }
        return false;
    }
}

