/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntityIllusion;
import net.msrandom.witchery.entity.EntitySleepingBody;
import net.msrandom.witchery.entity.EntitySpirit;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntityFetish
extends WitcheryTileEntity {
    private static Set<Class<?>> groupables;
    final int TRIGGER_WHEN_PLAYER_NOT_IN_WHITELIST = 0;
    final int TRIGGER_WHEN_PLAYER_IN_BLACKLIST = 1;
    final int TRIGGER_WHEN_CREATURE_NOT_IN_WHITELIST = 2;
    final int TRIGGER_WHEN_NOT_ALL_CREATURES_FOUND = 3;
    final int TRIGGER_WHEN_SOME_CREATURES_NOT_FOUND = 4;
    final int TRIGGER_OFF = 5;
    boolean lastRaiseAlarm;
    long lastActivationTime;
    int alarmMode = 5;
    private int color = 0;
    private InfusedSpiritEffect effect;
    private final Set<UUID> knownPlayers = new LinkedHashSet<UUID>();
    private final Set<Class<? extends Entity>> knownCreatureTypes = new LinkedHashSet<Class<? extends Entity>>();
    private final Set<UUID> knownCreatures = new LinkedHashSet<UUID>();

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.ticks % 20L == 0L && this.effect != null && this.effect.getRadius() > 0.0) {
            boolean someFound = false;
            int found = 0;
            int someLeft = 0;
            HashSet<String> foundTypes = new HashSet<String>();
            ArrayList<EntityLivingBase> foundEntities = new ArrayList<EntityLivingBase>();
            if (this.alarmMode != 5) {
                double RADIUS = this.effect.getRadius();
                AxisAlignedBB bb = new AxisAlignedBB(0.5 + (double)this.func_174877_v().func_177958_n() - RADIUS, 0.5 + (double)this.func_174877_v().func_177956_o() - RADIUS, 0.5 + (double)this.func_174877_v().func_177952_p() - RADIUS, 0.5 + (double)this.func_174877_v().func_177958_n() + RADIUS, 0.5 + (double)this.func_174877_v().func_177956_o() + RADIUS, 0.5 + (double)this.func_174877_v().func_177952_p() + RADIUS);
                List entities = this.alarmMode == 0 || this.alarmMode == 1 ? this.field_145850_b.func_72872_a(EntityPlayer.class, bb) : this.field_145850_b.func_72872_a(EntityLivingBase.class, bb);
                someLeft = entities.size();
                for (EntityLivingBase obj : entities) {
                    if (obj instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)obj;
                        if (this.knownPlayers.contains(player.func_110124_au())) {
                            someFound = true;
                            ++found;
                            --someLeft;
                            if (this.alarmMode != 1) {
                                continue;
                            }
                        } else if (this.alarmMode != 2 && this.alarmMode != 0) continue;
                        foundEntities.add((EntityLivingBase)player);
                        continue;
                    }
                    if (!(obj instanceof EntityLiving) || this.isIgnorableEntity((EntityLiving)obj)) continue;
                    EntityLiving creature2 = (EntityLiving)obj;
                    if (this.knownCreatureTypes.contains(creature2.getClass())) {
                        someFound = true;
                        foundTypes.add(creature2.func_70005_c_());
                        --someLeft;
                        continue;
                    }
                    if (this.knownCreatures.contains(creature2.func_110124_au())) {
                        someFound = true;
                        ++found;
                        --someLeft;
                        continue;
                    }
                    if (this.alarmMode != 2) continue;
                    foundEntities.add((EntityLivingBase)creature2);
                }
            }
            boolean raiseAlarm = false;
            switch (this.alarmMode) {
                case 0: 
                case 2: {
                    raiseAlarm = someLeft > 0;
                    break;
                }
                case 1: {
                    raiseAlarm = someFound;
                    break;
                }
                case 3: {
                    raiseAlarm = found != this.knownCreatures.size() + this.knownPlayers.size() || this.knownCreatureTypes.size() != foundTypes.size();
                    break;
                }
                case 4: {
                    raiseAlarm = !someFound;
                }
            }
            int cooldown = this.effect.getCooldownTicks();
            long currentTime = this.field_145850_b.func_82737_E();
            if ((cooldown == -1 || currentTime > this.lastActivationTime + (long)cooldown) && this.effect.doUpdateEffect(this, raiseAlarm, foundEntities)) {
                this.lastActivationTime = currentTime;
            }
            if (this.lastRaiseAlarm != raiseAlarm) {
                this.lastRaiseAlarm = raiseAlarm;
                if (this.effect.isRedstoneSignaller()) {
                    BlockUtil.notifyNeighborsOfBlockChange(this.field_145850_b, this.func_174877_v(), this.func_145838_q());
                }
            }
        }
    }

    private boolean isFamiliar(Entity entity) {
        if (Familiars.canBeFamiliar(entity)) {
            return Familiars.getFamiliarInstance(entity).isFamiliar();
        }
        return false;
    }

    private boolean isIgnorableEntity(EntityLiving entity) {
        return entity instanceof EntitySleepingBody || entity instanceof EntityIllusion || entity instanceof EntitySpirit || this.isFamiliar((Entity)entity);
    }

    public int getPowerLevel() {
        if (this.effect != null && this.effect.isRedstoneSignaller()) {
            return this.lastRaiseAlarm ? 15 : 0;
        }
        return 0;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int dyeColor) {
        this.color = dyeColor;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
            this.syncSpectralEntities();
        }
    }

    public InfusedSpiritEffect getEffect() {
        return this.effect;
    }

    public void setEffect(InfusedSpiritEffect effect) {
        this.effect = effect;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
        }
    }

    public void syncSpectralEntities() {
        TileEntityFetish tile;
        WorldServer overworld;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(this.field_145850_b) && (overworld = this.field_145850_b.func_73046_m().func_71218_a(0)).func_180495_p(this.func_174877_v()).func_177230_c() == this.func_145838_q() && (tile = WitcheryTileEntities.FETISH.getAt((IBlockAccess)overworld, this.func_174877_v())) != null) {
            NBTTagCompound nbtOurData = new NBTTagCompound();
            this.writeSubDataToNBT(nbtOurData);
            tile.readSubDataFromNBT(nbtOurData);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.func_145839_a(packet2.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public void func_145839_a(NBTTagCompound nbtRoot) {
        super.func_145839_a(nbtRoot);
        this.lastActivationTime = nbtRoot.func_74763_f("LastActivation");
        this.readSubDataFromNBT(nbtRoot);
    }

    public void readSubDataFromNBT(NBTTagCompound tag) {
        int i;
        if (tag.func_74764_b("BlockColor")) {
            this.color = tag.func_74771_c("BlockColor");
        }
        if (tag.func_74764_b("EffectType")) {
            this.effect = (InfusedSpiritEffect)InfusedSpiritEffect.REGISTRY.get(new ResourceLocation(tag.func_74779_i("EffectType")));
        }
        this.alarmMode = tag.func_74764_b("AlarmMode") ? tag.func_74762_e("AlarmMode") : 5;
        if (tag.func_74764_b("KnownPlayers")) {
            NBTTagList players = tag.func_150295_c("KnownPlayers", 10);
            this.knownPlayers.clear();
            for (i = 0; i < players.func_74745_c(); ++i) {
                this.knownPlayers.add(UUID.fromString(players.func_150307_f(i)));
            }
        }
        if (tag.func_74764_b("KnownCreatureTypes")) {
            NBTTagList creatureTypes = tag.func_150295_c("KnownCreatureTypes", 10);
            this.knownCreatureTypes.clear();
            for (i = 0; i < creatureTypes.func_74745_c(); ++i) {
                this.knownCreatureTypes.add(EntityList.getClass((ResourceLocation)new ResourceLocation(creatureTypes.func_150307_f(i))));
            }
        }
        if (tag.func_74764_b("KnownCreatures")) {
            NBTTagList creatures = tag.func_150295_c("KnownCreatures", 10);
            this.knownCreatures.clear();
            for (i = 0; i < creatures.func_74745_c(); ++i) {
                this.knownCreatures.add(UUID.fromString(creatures.func_150307_f(i)));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtRoot) {
        super.func_189515_b(nbtRoot);
        nbtRoot.func_74772_a("LastActivation", this.lastActivationTime);
        this.writeSubDataToNBT(nbtRoot);
        return nbtRoot;
    }

    public void writeSubDataToNBT(NBTTagCompound tag) {
        tag.func_74774_a("BlockColor", (byte)this.color);
        if (this.effect != null) {
            tag.func_74778_a("EffectType", ((ResourceLocation)InfusedSpiritEffect.REGISTRY.getKey(this.effect)).toString());
        }
        tag.func_74768_a("AlarmMode", this.alarmMode);
        if (!this.knownPlayers.isEmpty()) {
            NBTTagList players = new NBTTagList();
            for (UUID uUID : this.knownPlayers) {
                players.func_74742_a((NBTBase)new NBTTagString(uUID.toString()));
            }
            tag.func_74782_a("KnownPlayers", (NBTBase)players);
        }
        if (!this.knownCreatureTypes.isEmpty()) {
            NBTTagList creatureTypes = new NBTTagList();
            for (Class clazz : this.knownCreatureTypes) {
                creatureTypes.func_74742_a((NBTBase)new NBTTagString(EntityList.func_191306_a((Class)clazz).toString()));
            }
            tag.func_74782_a("KnownCreatureTypes", (NBTBase)creatureTypes);
        }
        if (!this.knownCreatures.isEmpty()) {
            NBTTagList creatures = new NBTTagList();
            for (UUID uUID : this.knownCreatures) {
                creatures.func_74742_a((NBTBase)new NBTTagString(uUID.toString()));
            }
            tag.func_74782_a("KnownCreatures", (NBTBase)creatures);
        }
    }

    private boolean isGroupableCreature(Class<? extends Entity> creatureName) {
        if (groupables == null) {
            groupables = new HashSet();
            this.addGroupableType(EntityVillager.class);
            this.addGroupableType(EntityGoblin.class);
            this.addGroupableType(EntitySheep.class);
            this.addGroupableType(EntityCow.class);
            this.addGroupableType(EntityMooshroom.class);
            this.addGroupableType(EntityChicken.class);
            this.addGroupableType(EntityPig.class);
            this.addGroupableType(EntityHorse.class);
            this.addGroupableType(EntityBat.class);
            this.addGroupableType(EntitySquid.class);
            this.addGroupableType(EntityCovenWitch.class);
        }
        return groupables.contains(creatureName);
    }

    public void setBoundEntity(ItemStack stack, EntityPlayer player, boolean readonly) {
        if (!this.field_145850_b.field_72995_K && !stack.func_190926_b()) {
            Class<? extends Entity> boundEntityType = ItemTaglockKit.getBoundEntityType(stack, 0);
            UUID id = ItemTaglockKit.getBoundCreatureID(stack, 0);
            if (boundEntityType != null) {
                if (boundEntityType == EntityPlayer.class) {
                    if (!readonly) {
                        if (!player.func_70093_af() && !this.knownPlayers.contains(id)) {
                            this.knownPlayers.add(id);
                        } else {
                            this.knownPlayers.remove(id);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                        this.syncSpectralEntities();
                    }
                } else if (!readonly) {
                    if (this.isGroupableCreature(boundEntityType)) {
                        if (!player.func_70093_af() && !this.knownCreatureTypes.contains(boundEntityType)) {
                            this.knownCreatureTypes.add(boundEntityType);
                        } else {
                            this.knownCreatureTypes.remove(boundEntityType);
                        }
                    } else if (!player.func_70093_af() && !this.knownCreatures.contains(id)) {
                        this.knownCreatures.add(id);
                    } else {
                        this.knownCreatures.remove(id);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    this.syncSpectralEntities();
                }
            }
            this.showCurrentKnownEntities(player);
        }
    }

    public void clearBoundEntities(ItemStack stack, EntityPlayer player) {
        if (player != null && !player.field_70170_p.field_72995_K && !stack.func_190926_b()) {
            this.knownCreatureTypes.clear();
            this.knownCreatures.clear();
            this.knownPlayers.clear();
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
            }
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            }
            this.syncSpectralEntities();
            this.showCurrentKnownEntities(player);
        }
    }

    public void cycleBoundMode(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            if (++this.alarmMode > 5) {
                this.alarmMode = 0;
            }
            this.syncSpectralEntities();
            this.showCurrentKnownEntities(player);
        }
    }

    private void addGroupableType(Class<? extends EntityLiving> type2) {
        groupables.add(type2);
    }

    private void showCurrentKnownEntities(EntityPlayer player) {
        WorldServer serverWorld = (WorldServer)this.field_145850_b;
        PlayerProfileCache playerCache = serverWorld.func_73046_m().func_152358_ax();
        TextComponentString text2 = new TextComponentString("");
        int names = 0;
        for (UUID uUID : this.knownPlayers) {
            String name2;
            ITextComponent displayName;
            Entity otherPlayer = serverWorld.func_175733_a(uUID);
            if (otherPlayer == null) {
                GameProfile profile = playerCache.func_152652_a(uUID);
                String name3 = profile == null ? null : profile.getName();
                displayName = null;
            } else {
                name2 = null;
                displayName = otherPlayer.func_145748_c_();
            }
            if (displayName == null && name2 == null) continue;
            if (names > 0) {
                text2.func_150258_a(", ");
            }
            if (displayName == null) {
                text2.func_150258_a(name2);
            } else {
                text2.func_150257_a(displayName);
            }
            ++names;
        }
        for (Class clazz : this.knownCreatureTypes) {
            EntityEntry entry2 = EntityRegistry.getEntry((Class)clazz);
            if (entry2 == null) continue;
            if (names > 0) {
                text2.func_150258_a(", ");
            }
            text2.func_150258_a("#");
            text2.func_150257_a((ITextComponent)new TextComponentTranslation("entity." + entry2.getName() + ".name", new Object[0]));
            ++names;
        }
        for (UUID uUID : this.knownCreatures) {
            Entity entity = serverWorld.func_175733_a(uUID);
            if (entity == null) continue;
            if (names > 0) {
                text2.func_150258_a(", ");
            }
            text2.func_150257_a(entity.func_145748_c_());
            ++names;
        }
        String key = "";
        switch (this.alarmMode) {
            case 0: {
                key = "tile.witchery.scarecrow.player_whitelist";
                break;
            }
            case 1: {
                key = "tile.witchery.scarecrow.player_blacklist";
                break;
            }
            case 2: {
                key = "tile.witchery.scarecrow.all_whitelist";
                break;
            }
            case 3: {
                key = "tile.witchery.scarecrow.none_from_whitelist";
                break;
            }
            case 4: {
                key = "tile.witchery.scarecrow.one_absent_whitelist";
                break;
            }
            case 5: {
                key = "tile.witchery.scarecrow.disabled";
            }
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation(key, new Object[]{text2}));
    }
}

