/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.msrandom.witchery.block.entity.WaterContainer;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.recipe.KettleRecipe;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityKettle
extends WitcheryTileEntity
implements ISidedInventory,
WaterContainer {
    public static final int RESULT_SLOT = 6;
    public static final int BOTTLE_SLOT = 7;
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private final FluidTank tank = new FluidTank(1000);
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private boolean isRuined;
    public boolean isPowered;
    private int lastExtractionQuantity;
    private boolean consumeBottles;
    private KettleRecipe recipe;

    private static IPowerSource findNewPowerSource(World world, BlockPos pos) {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    public KettleRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!(this.field_145850_b.field_72995_K || this.isRuined || this.ticks % 20L != 0L || !this.isFilled() || !this.someFilled() && ((ItemStack)this.items.get(6)).func_190926_b())) {
            boolean sendPacket = false;
            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_185904_a() != Material.field_151581_o) {
                this.isRuined = true;
                this.items.set(6, (Object)ItemStack.field_190927_a);
            } else if (((ItemStack)this.items.get(6)).func_190926_b()) {
                Optional<KettleRecipe> recipeOptional = WitcheryUtils.getRecipeManager(this.field_145850_b).getRecipe(WitcheryRecipeTypes.KETTLE, this, this.field_145850_b);
                if (this.allFilled()) {
                    Optional<ItemStack> result2 = recipeOptional.map(r -> r.craft(this));
                    if (!result2.isPresent() || result2.get().func_190926_b()) {
                        this.isRuined = true;
                        this.items.set(6, (Object)ItemStack.field_190927_a);
                    } else {
                        KettleRecipe recipe = recipeOptional.get();
                        boolean wasPowered = this.isPowered;
                        float powerNeeded = recipe.getPowerRequired();
                        if (powerNeeded == 0.0f) {
                            this.isPowered = true;
                        } else {
                            IPowerSource powerSource = TileEntityKettle.findNewPowerSource(this.field_145850_b, this.func_174877_v());
                            boolean bl = this.isPowered = powerSource != null && powerSource.consumePower(powerNeeded);
                        }
                        if (this.isPowered) {
                            this.items.set(6, (Object)result2.get());
                            this.recipe = recipe;
                        }
                        sendPacket = this.isPowered || wasPowered;
                    }
                } else {
                    if (!recipeOptional.isPresent()) {
                        this.isRuined = true;
                        this.items.set(6, (Object)ItemStack.field_190927_a);
                    }
                    if (!this.isRuined) {
                        IPowerSource powerSource;
                        KettleRecipe recipe = recipeOptional.get();
                        boolean wasPowered = this.isPowered;
                        float powerNeeded = recipe.getPowerRequired();
                        this.isPowered = powerNeeded == 0.0f ? true : (powerSource = TileEntityKettle.findNewPowerSource(this.field_145850_b, this.func_174877_v())) != null && powerSource.getCurrentPower() >= powerNeeded;
                        boolean bl = sendPacket = wasPowered != this.isPowered;
                    }
                }
            }
            if (this.isRuined || sendPacket) {
                BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    public void empty() {
        for (int i = 0; i < this.items.size() - 2; ++i) {
            this.items.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public void reset(boolean flushWater) {
        if (!this.field_145850_b.field_72995_K) {
            if (flushWater) {
                this.tank.drain(this.tank.getFluidAmount(), true);
            }
            this.isRuined = false;
            this.isPowered = false;
            this.recipe = null;
            for (int i = 0; i < this.items.size() - 1; ++i) {
                this.items.set(i, (Object)ItemStack.field_190927_a);
            }
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
            this.func_70296_d();
        }
    }

    public boolean allFilled() {
        for (int i = 0; i < this.items.size() - 2; ++i) {
            if (!((ItemStack)this.items.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean someFilled() {
        for (int i = 0; i < this.items.size() - 2; ++i) {
            if (((ItemStack)this.items.get(i)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        ItemStack stackInSlot = this.func_70301_a(slot);
        if (slot == 6) {
            return true;
        }
        if (slot == 7) {
            return itemstack.func_77973_b() == Items.field_151069_bo && stackInSlot.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_();
        }
        return this.func_70301_a(6).func_190926_b() && stackInSlot.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public int[] func_180463_a(EnumFacing var1) {
        return SLOTS;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        ItemStack stackInSlot = this.func_70301_a(slot);
        if (slot == 6) {
            return false;
        }
        if (slot == 7) {
            return stack.func_77973_b() == Items.field_151069_bo && stackInSlot.func_190916_E() + stack.func_190916_E() <= this.func_70297_j_();
        }
        return stack.func_77973_b() != Items.field_151069_bo && this.func_70301_a(6).func_190926_b() && this.isFilled();
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        boolean canExtract;
        ItemStack bottles = this.func_70301_a(7);
        boolean bl = canExtract = slot == 6 && this.isFilled() && this.isReady() && !bottles.func_190926_b() && bottles.func_190916_E() >= stack.func_190916_E();
        if (canExtract) {
            Optional<KettleRecipe> recipe = WitcheryUtils.getRecipeManager(this.field_145850_b).getRecipe(WitcheryRecipeTypes.KETTLE, this, this.field_145850_b);
            if (recipe.isPresent() && recipe.get().getFamiliarPower() == null) {
                return false;
            }
            this.lastExtractionQuantity = stack.func_190916_E();
        }
        return canExtract;
    }

    public int getColor() {
        return WitcheryUtils.getColor(this.items);
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 6 && this.consumeBottles) {
            ItemStack resultStack = this.func_70301_a(6);
            ItemStack bottleStack = this.func_70301_a(7);
            if (stack.func_190926_b() && !resultStack.func_190926_b() && !bottleStack.func_190926_b()) {
                bottleStack.func_190918_g(resultStack.func_190916_E());
            } else if (!(stack.func_190926_b() || resultStack.func_190926_b() || bottleStack.func_190926_b())) {
                int reduction = resultStack.func_190916_E() - stack.func_190916_E();
                if (reduction == 0) {
                    reduction = this.lastExtractionQuantity;
                }
                this.lastExtractionQuantity = 0;
                bottleStack.func_190918_g(reduction);
            }
        }
        BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
        this.items.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        } else if (stack.func_190926_b() && slot == 6) {
            this.reset(true);
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
    }

    @Deprecated
    public void setConsumeBottle(boolean consume) {
        this.consumeBottles = consume;
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        if (((ItemStack)this.items.get(slot)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack bottles = this.func_70301_a(7);
        if (this.consumeBottles && !bottles.func_190926_b()) {
            bottles.func_190918_g(quantity);
        }
        if (((ItemStack)this.items.get(slot)).func_190916_E() <= quantity) {
            ItemStack itemstack = (ItemStack)this.items.get(slot);
            this.items.set(slot, (Object)ItemStack.field_190927_a);
            if (slot == 6) {
                this.reset(true);
            } else if (!this.field_145850_b.field_72995_K) {
                BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
            }
            return itemstack;
        }
        ItemStack itemstack = ((ItemStack)this.items.get(slot)).func_77979_a(quantity);
        if (((ItemStack)this.items.get(slot)).func_190926_b()) {
            if (slot == 6) {
                this.reset(true);
            } else if (!this.field_145850_b.field_72995_K) {
                BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
            }
        } else if (!this.field_145850_b.field_72995_K) {
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int par1) {
        BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
        return ItemStackHelper.func_188383_a(this.items, (int)par1);
    }

    public String func_70005_c_() {
        return this.func_145838_q().func_149732_F();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (this.tank.getFluidAmount() > 0) {
            this.tank.drain(this.tank.getFluidAmount(), true);
        }
        this.tank.readFromNBT(tag);
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.items.size()) continue;
            this.items.set((int)b0, (Object)new ItemStack(nbttagcompound1));
        }
        this.isRuined = tag.func_74767_n("Ruined");
        this.isPowered = tag.func_74767_n("Powered");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("Ruined", this.isRuined);
        tag.func_74757_a("Powered", this.isPowered);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.items.get(i)).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        this.tank.writeToNBT(tag);
        return tag;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean isFilled() {
        return this.tank.getFluidAmount() == this.tank.getCapacity();
    }

    public boolean isBrewing() {
        return this.isFilled() && this.someFilled() && !this.isRuined();
    }

    public boolean isReady() {
        return !this.isRuined() && this.recipe != null;
    }

    public boolean isRuined() {
        return this.isRuined;
    }

    public void setRuined() {
        this.isRuined = true;
        BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
    }

    public int fill(FluidStack resource, boolean doFill) {
        int result2 = this.tank.fill(resource, doFill);
        if (doFill && result2 > 0) {
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.field_174879_c);
        }
        return result2;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        FluidStack result2 = this.tank.drain(resource.amount, doDrain);
        if (doDrain && result2 != null) {
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.field_174879_c);
        }
        return result2;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack result2 = this.tank.drain(maxDrain, doDrain);
        if (doDrain && result2 != null) {
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.field_174879_c);
        }
        return result2;
    }

    public boolean canFill(Fluid fluid) {
        return fluid != null && fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(Fluid fluid) {
        return fluid != null && fluid == FluidRegistry.WATER;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    @Override
    public int getQuantity() {
        return 1000;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

