/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.block.BlockMirror;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityMirrorFace;
import net.msrandom.witchery.entity.passive.EntityFairest;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemQuartzGrenade;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.transformation.CreatureForm;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityMirror
extends WitcheryTileEntity {
    private final Set<String> playersSeen = new HashSet<String>();
    private long cooldown;
    private long lastFairestSpawn;
    public BlockPos dimCoords;
    public int dim;
    public boolean isConnected;
    public boolean demonKilled;
    private UUID favorite;
    private UUID fairest;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.ticks % (long)(this.field_145850_b.field_72995_K ? 10 : 40) == 1L) {
            EnumFacing side = BlockMirror.getDirection(this.field_145850_b.func_180495_p(this.func_174877_v()));
            int xMin = -1;
            int xMax = 1;
            int zMin = -1;
            int zMax = 1;
            int scale = 4;
            switch (side) {
                case NORTH: {
                    zMin = -scale;
                    zMax = 0;
                    break;
                }
                case SOUTH: {
                    zMin = 0;
                    zMax = scale;
                    break;
                }
                case WEST: {
                    xMin = -scale;
                    xMax = 0;
                    break;
                }
                case EAST: {
                    xMin = 0;
                    xMax = scale;
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                for (EntityLivingBase entity : this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(xMin, 0, zMin), this.field_174879_c.func_177982_a(xMax + 1, 1, zMax + 1)))) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    this.playersSeen.add(entity.func_70005_c_());
                }
            }
        }
    }

    public void addCooldown(int i) {
        this.cooldown = this.ticks + (long)i;
    }

    public boolean onCooldown() {
        return this.ticks < this.cooldown;
    }

    public boolean isTargetedBy(ItemStack stack) {
        NBTTagCompound nbtRoot;
        if (!stack.func_190926_b() && stack.func_77973_b() == Item.func_150898_a((Block)WitcheryBlocks.MIRROR) && stack.func_77978_p() != null && (nbtRoot = stack.func_77978_p()).func_74764_b("DimCoords") && nbtRoot.func_74764_b("Dimension") && this.field_145850_b.field_73011_w.getDimension() == nbtRoot.func_74762_e("Dimension")) {
            BlockPos coords = null;
            if (nbtRoot.func_74764_b("posX") && nbtRoot.func_74764_b("posY") && nbtRoot.func_74764_b("posZ")) {
                coords = new BlockPos(nbtRoot.func_74762_e("posX"), nbtRoot.func_74762_e("posY"), nbtRoot.func_74762_e("posZ"));
            }
            if (coords != null) {
                return coords.equals((Object)this.func_174877_v());
            }
        }
        return false;
    }

    public void depolyDemon(EntityPlayer player, EnumHand hand) {
        if (!this.demonKilled && !WitcheryDimensions.MIRROR.isCurrentDimension(this.field_145850_b)) {
            if (player.func_184586_b(hand).func_77973_b() == WitcheryGeneralItems.BOUND_TAGLOCK_KIT) {
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                CreatureForm currentTransform = playerEx.getCurrentForm();
                if (currentTransform == null || currentTransform == WitcheryAlternateForms.PLAYER) {
                    GameProfile profile = ItemTaglockKit.getBoundPlayer(player.func_184586_b(hand), 0);
                    if (profile != null && player.func_110124_au().equals(EntityPlayer.func_146094_a((GameProfile)profile))) {
                        if (currentTransform == WitcheryAlternateForms.PLAYER) {
                            player.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                            playerEx.setCurrentForm(null);
                        } else {
                            player.func_184185_a(SoundEvents.field_187688_dI, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                        }
                    } else {
                        IPowerSource power = PowerSources.findClosestPowerSource(this);
                        if (power != null && power.consumePower(4000.0f)) {
                            player.func_184185_a(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                            playerEx.setOtherPlayer(profile);
                            playerEx.setCurrentForm(WitcheryAlternateForms.PLAYER);
                        } else {
                            player.func_184185_a(SoundEvents.field_187688_dI, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                        }
                    }
                }
            } else if (player.func_184586_b(hand).func_77973_b() == WitcheryIngredientItems.QUARTZ_SPHERE) {
                IPowerSource power2 = PowerSources.findClosestPowerSource(this);
                if (power2 != null && power2.consumePower(2000.0f)) {
                    player.func_184185_a(SoundEvents.field_187604_bf, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                    ItemStack itemstack = player.func_184586_b(hand);
                    if (itemstack.func_190916_E() > 1) {
                        ItemStack newStack = new ItemStack((Item)WitcheryGeneralItems.DUP_GRENADE);
                        ItemQuartzGrenade.setOwnerName(newStack, player.func_110124_au());
                        itemstack.func_190918_g(1);
                        if (!player.field_71071_by.func_70441_a(newStack)) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, player.field_70165_t + 0.5, player.field_70163_u + 1.5, player.field_70161_v + 0.5, newStack));
                        } else if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                        }
                    } else {
                        ItemStack newStack = new ItemStack((Item)WitcheryGeneralItems.DUP_GRENADE);
                        ItemQuartzGrenade.setOwnerName(newStack, player.func_110124_au());
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, newStack);
                        if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                        }
                    }
                } else {
                    player.func_184185_a(SoundEvents.field_187688_dI, 0.5f, 0.4f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
                }
            } else {
                List faces = this.field_145850_b.func_72872_a(EntityMirrorFace.class, this.field_145850_b.func_180495_p(this.func_174877_v()).func_185918_c(this.field_145850_b, this.func_174877_v()));
                if (faces.isEmpty()) {
                    this.showMirrorHead(this.field_145850_b, this.func_174877_v());
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, WitcherySounds.ENTITY_REFLECTION_AMBIENT, SoundCategory.PLAYERS, 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, 0.5f, 0.5f, 0x7777FF), this.field_145850_b, this.field_174879_c);
                    double RANGE = 64.0;
                    List players = this.field_145850_b.field_73010_i;
                    for (EntityPlayer otherPlayer : players) {
                        if (!(player.func_174818_b(this.func_174877_v()) <= RANGE * RANGE)) continue;
                        otherPlayer.func_145747_a((ITextComponent)new TextComponentTranslation(WitcheryBlocks.MIRROR.func_149739_a() + ".fairest", new Object[]{player.func_70005_c_()}));
                    }
                    boolean fairestFound = false;
                    int nx = this.func_174877_v().func_177958_n();
                    int ny = this.func_174877_v().func_177956_o();
                    int nz = this.func_174877_v().func_177952_p();
                    if (this.fairest != null) {
                        double R = 100.0;
                        double RY = 32.0;
                        AxisAlignedBB bounds = new AxisAlignedBB((double)nx - R, (double)ny - RY, (double)nz - R, (double)nx + R, (double)ny + RY, (double)nz + R);
                        List followers = this.field_145850_b.func_72872_a(EntityFairest.class, bounds);
                        for (EntityFairest follower : followers) {
                            if (!follower.getPersistentID().equals(this.fairest) || !follower.func_70089_S()) continue;
                            this.sayNotFairest(player, follower);
                            fairestFound = true;
                            break;
                        }
                    }
                    if (!fairestFound) {
                        boolean isFairestAllowed = this.field_145850_b.func_82737_E() > this.lastFairestSpawn + 2400L;
                        this.fairest = null;
                        if (this.favorite == null || this.isFavorite(player)) {
                            EntityFairest fairestEntity;
                            this.favorite = player.func_110124_au();
                            if (isFairestAllowed && this.field_145850_b.field_73012_v.nextDouble() < WitcheryConfigOptions.fairestSpawnChance / 100.0 && (fairestEntity = WitcheryEntities.FAIREST.create(this.field_145850_b)) != null) {
                                int type2 = this.field_145850_b.field_73012_v.nextInt(3);
                                fairestEntity.func_110163_bv();
                                fairestEntity.setType(type2);
                                BlockPos coord = null;
                                int minRange = 50;
                                block2: for (int i = 0; i < 25 && coord == null; ++i) {
                                    int x = nx + (this.field_145850_b.field_73012_v.nextBoolean() ? 1 : -1) * (minRange + this.field_145850_b.field_73012_v.nextInt(minRange));
                                    int z = nz + (this.field_145850_b.field_73012_v.nextBoolean() ? 1 : -1) * (minRange + this.field_145850_b.field_73012_v.nextInt(minRange));
                                    int yMin = Math.max(ny - 20, 2);
                                    for (int y = Math.min(ny + 20, 250); y >= yMin; --y) {
                                        BlockPos p = new BlockPos(x, y, z);
                                        if (!this.field_145850_b.func_180495_p(p).func_185915_l() || !this.field_145850_b.func_180495_p(p.func_177984_a()).func_185904_a().func_76222_j() || !this.field_145850_b.func_175623_d(p.func_177981_b(2))) continue;
                                        coord = p;
                                        continue block2;
                                    }
                                }
                                if (coord != null) {
                                    fairestEntity.func_70080_a((double)coord.func_177958_n() + 0.5, (double)coord.func_177956_o() + 1.01, (double)coord.func_177952_p() + 0.5, 0.0f, 0.0f);
                                    this.field_145850_b.func_72838_d((Entity)fairestEntity);
                                    this.fairest = fairestEntity.getPersistentID();
                                    fairestFound = true;
                                    this.lastFairestSpawn = this.field_145850_b.func_82737_E();
                                    this.sayNotFairest(player, fairestEntity);
                                }
                            }
                            if (!fairestFound) {
                                player.func_145747_a(new TextComponentTranslation(WitcheryBlocks.MIRROR.func_149739_a() + ".you", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
                            }
                        } else {
                            player.func_145747_a(new TextComponentTranslation(WitcheryBlocks.MIRROR.func_149739_a() + ".fairer", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
                            EntityPlayer otherPlayer2 = WitcheryUtils.getPlayer(this.field_145850_b, this.favorite);
                            if (otherPlayer2 != null) {
                                this.sayBearing(player, (EntityLivingBase)otherPlayer2);
                            }
                        }
                    }
                    if (this.playersSeen.size() > 1) {
                        ArrayList<String> seen = new ArrayList<String>(this.playersSeen);
                        Collections.sort(seen);
                        StringBuilder sb = new StringBuilder();
                        for (String s : seen) {
                            if (s.equals(player.func_70005_c_())) continue;
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(s);
                        }
                        if (sb.length() > 0) {
                            player.func_145747_a(new TextComponentTranslation(WitcheryBlocks.MIRROR.func_149739_a() + ".players_before_current", new Object[]{sb.toString()}).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
                        } else {
                            player.func_145747_a(new TextComponentTranslation(WitcheryBlocks.MIRROR.func_149739_a() + ".no_players_before", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
                        }
                    } else {
                        player.func_145747_a(new TextComponentTranslation(WitcheryBlocks.MIRROR.func_149739_a() + ".no_players_before", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
                    }
                    if (this.isFavorite(player)) {
                        this.playersSeen.clear();
                    }
                }
            }
        }
    }

    public void sayNotFairest(EntityPlayer player, EntityFairest follower) {
        player.func_145747_a(new TextComponentTranslation(WitcheryBlocks.MIRROR.func_149739_a() + ".fairer", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
        this.sayBearing(player, (EntityLivingBase)follower);
    }

    public void sayBearing(EntityPlayer player, EntityLivingBase otherEntity) {
        int bearingIndex;
        double bearingRadians = Math.atan2((double)this.func_174877_v().func_177952_p() - otherEntity.field_70161_v + 0.5, (double)this.func_174877_v().func_177958_n() - otherEntity.field_70165_t + 0.5);
        double bearing = (bearingRadians + 4.71238898038469) % Math.PI * 2.0;
        if (bearing < 0.0) {
            bearing += Math.PI * 2;
        }
        if ((bearingIndex = (int)(bearing / 0.7853981633974483)) > 7 || bearingIndex < 0) {
            bearingIndex = 0;
        }
        player.func_145747_a(new TextComponentTranslation(WitcheryBlocks.MIRROR.func_149739_a() + ".bearing" + bearingIndex, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
    }

    private void showMirrorHead(World world, BlockPos pos) {
        EnumFacing side = BlockMirror.getDirection(world.func_180495_p(pos));
        float dx = 0.0f;
        float dz = 0.0f;
        float scale = 0.4f;
        switch (side) {
            case NORTH: {
                dz = scale;
                break;
            }
            case SOUTH: {
                dz = -scale;
                break;
            }
            case WEST: {
                dx = scale;
                break;
            }
            case EAST: {
                dx = -scale;
            }
        }
        EntityMirrorFace face = new EntityMirrorFace(world);
        face.func_70107_b((double)pos.func_177958_n() + 0.5 + (double)dx, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (double)dz);
        world.func_72838_d((Entity)face);
    }

    public boolean isDimLinked() {
        return this.dimCoords != null;
    }

    public BlockPos getDimCoords() {
        if (this.dimCoords == null && !WitcheryDimensions.MIRROR.isCurrentDimension(this.field_145850_b)) {
            WorldServer mirrorWorld = this.field_145850_b.func_73046_m().func_71218_a(WitcheryDimensions.MIRROR.getType().func_186068_a());
            EnumFacing[] map2 = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.EAST};
            int cellX = 0;
            int cellZ = 0;
            int sign = 1;
            for (int i = 0; i < 256; ++i) {
                for (int spin = 0; spin <= i; ++spin) {
                    for (EnumFacing facing : map2) {
                        if (i > 0) {
                            cellX += facing.func_82601_c() * sign;
                            cellZ += facing.func_82599_e() * sign;
                        }
                        int Y_LEVELS = WitcheryConfigOptions.shrinkMirrorWorld ? 8 : 15;
                        for (int cellY = 0; cellY < Y_LEVELS; ++cellY) {
                            int dimX = (cellX << 4) + 4;
                            int dimY = (cellY << 4) + 8;
                            int dimZ = (cellZ << 4) + 8;
                            BlockPos pos = new BlockPos(dimX, dimY, dimZ);
                            if (!mirrorWorld.func_175623_d(pos) || !mirrorWorld.func_175623_d(pos.func_177977_b())) continue;
                            boolean stop = false;
                            for (int y = dimY - 1; y <= dimY + 6 && !stop; ++y) {
                                block5: for (int x = dimX; x <= dimX + 8 && !stop; ++x) {
                                    for (int z = dimZ - 4; z <= dimZ + 4; ++z) {
                                        if (mirrorWorld.func_175623_d(new BlockPos(x, y, z))) continue;
                                        stop = true;
                                        continue block5;
                                    }
                                }
                            }
                            if (stop) continue;
                            IBlockState meta = WitcheryBlocks.UNBREAKABLE_MIRROR.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.EAST);
                            mirrorWorld.func_180501_a(pos, meta.func_177226_a((IProperty)BlockMirror.TOP, (Comparable)Boolean.valueOf(true)), 3);
                            TileEntityMirror tile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)mirrorWorld, pos);
                            if (tile != null) {
                                tile.dimCoords = this.func_174877_v();
                                tile.dim = this.field_145850_b.field_73011_w.getDimension();
                            }
                            if (mirrorWorld.func_180495_p(pos).func_177230_c() == meta.func_177230_c()) {
                                mirrorWorld.func_180501_a(pos.func_177977_b(), meta.func_177226_a((IProperty)BlockMirror.TOP, (Comparable)Boolean.valueOf(false)), 3);
                            }
                            this.dimCoords = new BlockPos(dimX, dimY, dimZ);
                            return this.dimCoords;
                        }
                    }
                }
                sign *= -1;
            }
        }
        return this.dimCoords;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        NBTTagCompound nbtTag = packet2.func_148857_g();
        this.func_145839_a(nbtTag);
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtRoot) {
        super.func_189515_b(nbtRoot);
        nbtRoot.func_74772_a("LastFairestSpawnTime", this.lastFairestSpawn);
        this.writeItemDataToNBT(nbtRoot);
        return nbtRoot;
    }

    public void func_145839_a(NBTTagCompound nbtRoot) {
        super.func_145839_a(nbtRoot);
        this.lastFairestSpawn = nbtRoot.func_74763_f("LastFairestSpawnTime");
        this.readItemDataFromNBT(nbtRoot);
    }

    public void writeItemDataToNBT(NBTTagCompound nbtRoot) {
        if (this.dimCoords != null) {
            NBTTagCompound nbtDim = new NBTTagCompound();
            nbtDim.func_74768_a("posX", this.dimCoords.func_177958_n());
            nbtDim.func_74768_a("posY", this.dimCoords.func_177956_o());
            nbtDim.func_74768_a("posZ", this.dimCoords.func_177952_p());
            nbtDim.func_74768_a("Dimension", this.dim);
            nbtRoot.func_74782_a("DimCoords", (NBTBase)nbtDim);
        }
        nbtRoot.func_74757_a("DemonSlain", this.demonKilled);
        if (this.favorite != null) {
            nbtRoot.func_186854_a("Favorite", this.favorite);
        }
        if (this.fairest != null) {
            nbtRoot.func_186854_a("Fairest", this.fairest);
        }
        NBTTagList players = new NBTTagList();
        for (String player : this.playersSeen) {
            players.func_74742_a((NBTBase)new NBTTagString(player));
        }
        nbtRoot.func_74782_a("PlayersSeen", (NBTBase)players);
    }

    public void readItemDataFromNBT(NBTTagCompound nbtRoot) {
        if (nbtRoot.func_74764_b("DimCoords")) {
            NBTTagCompound nbtDim = nbtRoot.func_74775_l("DimCoords");
            BlockPos coord = null;
            if (nbtDim.func_74764_b("posX") && nbtDim.func_74764_b("posY") && nbtDim.func_74764_b("posZ")) {
                coord = new BlockPos(nbtDim.func_74762_e("posX"), nbtDim.func_74762_e("posY"), nbtDim.func_74762_e("posZ"));
            }
            this.dimCoords = coord;
            this.dim = nbtDim.func_74762_e("Dimension");
        }
        this.demonKilled = nbtRoot.func_74767_n("DemonSlain");
        if (nbtRoot.func_186855_b("Favorite")) {
            this.favorite = nbtRoot.func_186857_a("Favorite");
        }
        if (nbtRoot.func_186855_b("Fairest")) {
            this.fairest = nbtRoot.func_186857_a("Fairest");
        }
        this.playersSeen.clear();
        if (nbtRoot.func_74764_b("PlayersSeen")) {
            NBTTagList players = nbtRoot.func_150295_c("PlayersSeen", 8);
            for (int i = 0; i < players.func_74745_c(); ++i) {
                this.playersSeen.add(players.func_150307_f(i));
            }
        }
    }

    public boolean isFavorite(EntityPlayer player) {
        return this.favorite != null && player != null && this.favorite.equals(player.func_110124_au());
    }
}

