/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntityMovingBrew
extends TileEntity {
    public BrewActionList actionList;
    public int duration;
    public int expansion;
    public int updateCount;
    public UUID thrower;
    private int runTicks;

    public void initialize(ModifiersImpact impactModifiers, BrewActionList actionList) {
        this.actionList = actionList;
        this.duration = impactModifiers.lifetime.get() >= 0 ? 5 + impactModifiers.lifetime.get() * impactModifiers.lifetime.get() * 5 : 100;
        this.expansion = Math.min(4 + impactModifiers.extent.get(), 10);
        if (impactModifiers.thrower != null) {
            this.thrower = impactModifiers.thrower.func_110124_au();
        }
        BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.func_145839_a(packet2.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtRoot) {
        super.func_189515_b(nbtRoot);
        nbtRoot.func_74782_a("Effect", (NBTBase)this.actionList.write());
        nbtRoot.func_74768_a("Duration", this.duration);
        nbtRoot.func_74768_a("Expansion", this.expansion);
        if (this.thrower != null) {
            nbtRoot.func_186854_a("Thrower", this.thrower);
        }
        return nbtRoot;
    }

    public void func_145839_a(NBTTagCompound nbtRoot) {
        super.func_145839_a(nbtRoot);
        this.actionList = new BrewActionList(nbtRoot.func_150295_c("Effect", 10));
        this.duration = nbtRoot.func_74762_e("Duration");
        this.expansion = nbtRoot.func_74762_e("Expansion");
        if (nbtRoot.func_186855_b("Thrower")) {
            this.thrower = nbtRoot.func_186857_a("Thrower");
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int incRunTicks() {
        return ++this.runTicks;
    }
}

