/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntityPoppetShelf
extends WitcheryTileEntity
implements IInventory {
    protected String customName;
    private NonNullList<ItemStack> contents = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private ForgeChunkManager.Ticket chunkTicket;

    @Override
    protected void initiate() {
        super.initiate();
        if (!this.field_145850_b.field_72995_K && this.chunkTicket == null) {
            this.forceChunk();
        }
    }

    private void forceChunk() {
        this.chunkTicket = ForgeChunkManager.requestTicket((Object)WitcheryResurrected.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        if (this.chunkTicket != null) {
            this.chunkTicket.getModData().func_74768_a("poppetX", x);
            this.chunkTicket.getModData().func_74768_a("poppetY", y);
            this.chunkTicket.getModData().func_74768_a("poppetZ", z);
            this.setTicket(this.chunkTicket);
        }
    }

    public void setTicket(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)new ChunkPos(this.func_174877_v()));
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        }
        super.func_145843_s();
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.contents) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.contents.get(slot);
    }

    public ItemStack func_70298_a(int slot, int size) {
        this.func_70296_d();
        return ItemStackHelper.func_188382_a(this.contents, (int)slot, (int)size);
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.contents, (int)slot);
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.contents.set(slot, (Object)itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
        super.func_70296_d();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.witchery.poppet_shelf";
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.func_148857_g());
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        NBTTagList nbttaglist = nbtTag.func_150295_c("Items", 10);
        this.contents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j >= this.contents.size()) continue;
            this.contents.set(j, (Object)new ItemStack(nbttagcompound1));
        }
        if (nbtTag.func_74764_b("CustomName")) {
            this.customName = nbtTag.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTag) {
        super.func_189515_b(nbtTag);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.contents.size(); ++i) {
            if (((ItemStack)this.contents.get(i)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.contents.get(i)).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbtTag.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            nbtTag.func_74778_a("CustomName", this.customName);
        }
        return nbtTag;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof WitcheryPoppetItems.ItemPoppet;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.contents.clear();
    }
}

