/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityAltar;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.recipe.SpinningWheelRecipe;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntitySpinningWheel
extends TileEntity
implements ISidedInventory,
ITickable {
    static final float POWER_PER_TICK = 0.6f;
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{3, 1, 2};
    private static final int[] SLOTS_SIDES = new int[]{2, 4, 3, 1};
    public int furnaceCookTime;
    public int powerLevel;
    BlockPos powerSourceCoord;
    private NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    public int prevTicks;
    public int ticks;

    public int func_70302_i_() {
        return this.slots.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.slots) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.slots.get(slot);
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        return ItemStackHelper.func_188382_a(this.slots, (int)slot, (int)quantity);
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.slots, (int)slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public String func_70005_c_() {
        return this.func_145838_q().func_149732_F();
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public void func_145839_a(NBTTagCompound nbtRoot) {
        super.func_145839_a(nbtRoot);
        NBTTagList nbtSlotList = nbtRoot.func_150295_c("Items", 10);
        this.slots = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbtSlotList.func_74745_c(); ++i) {
            NBTTagCompound nbtSlot = nbtSlotList.func_150305_b(i);
            byte b0 = nbtSlot.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.slots.size()) continue;
            this.slots.set((int)b0, (Object)new ItemStack(nbtSlot));
        }
        this.furnaceCookTime = nbtRoot.func_74765_d("CookTime");
        this.powerLevel = nbtRoot.func_74765_d("PowerLevel");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtRoot) {
        super.func_189515_b(nbtRoot);
        nbtRoot.func_74777_a("CookTime", (short)this.furnaceCookTime);
        nbtRoot.func_74777_a("PowerLevel", (short)this.powerLevel);
        NBTTagList nbtSlotList = new NBTTagList();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (((ItemStack)this.slots.get(i)).func_190926_b()) continue;
            NBTTagCompound nbtSlot = new NBTTagCompound();
            nbtSlot.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.slots.get(i)).func_77955_b(nbtSlot);
            nbtSlotList.func_74742_a((NBTBase)nbtSlot);
        }
        nbtRoot.func_74782_a("Items", (NBTBase)nbtSlotList);
        return nbtRoot;
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / this.getTotalCookTime();
    }

    public int getTotalCookTime() {
        return 300;
    }

    public int getCookTime() {
        return this.furnaceCookTime;
    }

    IPowerSource getPowerSource() {
        if (this.powerSourceCoord == null || (long)(this.ticks % 100) == 0L) {
            return this.findNewPowerSource();
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.powerSourceCoord);
        if (!(tileEntity instanceof TileEntityAltar)) {
            return this.findNewPowerSource();
        }
        TileEntityAltar altarTileEntity = (TileEntityAltar)tileEntity;
        if (!altarTileEntity.isValid()) {
            return this.findNewPowerSource();
        }
        return altarTileEntity;
    }

    private IPowerSource findNewPowerSource() {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(this.field_145850_b, this.field_174879_c);
        return sources != null && !sources.isEmpty() ? sources.get(0).source() : null;
    }

    public void func_73660_a() {
        boolean update = false;
        if (!this.field_145850_b.field_72995_K) {
            boolean powered;
            boolean bl = powered = this.powerLevel > 0;
            if (this.getRecipe() != null) {
                IPowerSource powerSource = this.getPowerSource();
                this.powerSourceCoord = powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord) ? powerSource.getLocation() : null;
                int n = this.powerLevel = powerSource != null ? 1 : 0;
                if (powerSource != null && powerSource.consumePower(0.6f)) {
                    update = this.furnaceCookTime == 0;
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == this.getTotalCookTime()) {
                        this.furnaceCookTime = 0;
                        this.processItem();
                        update = true;
                    }
                    if (powered != this.powerLevel > 0) {
                        update = true;
                    }
                } else {
                    this.powerLevel = 0;
                    if (powered) {
                        update = true;
                    }
                }
            } else {
                if ((long)(this.ticks % 40) == 0L) {
                    IPowerSource powerSource = this.getPowerSource();
                    if (powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord)) {
                        this.powerSourceCoord = powerSource.getLocation();
                    }
                    int n = this.powerLevel = powerSource != null ? 1 : 0;
                }
                update = this.furnaceCookTime > 0 || powered != this.powerLevel > 0;
                this.furnaceCookTime = 0;
            }
        }
        if (update) {
            this.func_70296_d();
        }
        ++this.ticks;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.func_145839_a(packet2.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    private SpinningWheelRecipe getRecipe() {
        if (((ItemStack)this.slots.get(0)).func_190926_b()) {
            return null;
        }
        Optional<SpinningWheelRecipe> recipe = WitcheryUtils.getRecipeManager(this.field_145850_b).getRecipe(WitcheryRecipeTypes.SPINNING_WHEEL, this, this.field_145850_b);
        if (!recipe.isPresent()) {
            return null;
        }
        if (((ItemStack)this.slots.get(4)).func_190926_b()) {
            return recipe.get();
        }
        ItemStack itemstack = recipe.get().getResult();
        if (!((ItemStack)this.slots.get(4)).func_77969_a(itemstack)) {
            return null;
        }
        int result2 = ((ItemStack)this.slots.get(4)).func_190916_E() + itemstack.func_190916_E();
        return result2 <= this.func_70297_j_() && result2 <= itemstack.func_77976_d() ? recipe.get() : null;
    }

    public void processItem() {
        SpinningWheelRecipe recipe = this.getRecipe();
        if (recipe != null) {
            ItemStack itemstack = recipe.getResult();
            if (((ItemStack)this.slots.get(4)).func_190926_b()) {
                this.slots.set(4, (Object)itemstack.func_77946_l());
            } else if (((ItemStack)this.slots.get(4)).func_77969_a(itemstack)) {
                ItemStack itemStack = (ItemStack)this.slots.get(4);
                itemStack.func_190917_f(itemstack.func_190916_E());
            }
            ItemStack itemStack2 = (ItemStack)this.slots.get(0);
            itemStack2.func_190918_g(recipe.getFibreCount());
            for (int i = 1; i <= 3; ++i) {
                ItemStack stack = (ItemStack)this.slots.get(i);
                Item item = stack.func_77973_b();
                stack.func_190918_g(1);
                if (!itemstack.func_190926_b()) continue;
                this.func_70299_a(i, item.getContainerItem(itemstack));
            }
        }
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot != 4;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceCookTime;
            }
            case 1: {
                return this.powerLevel;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceCookTime = value;
                break;
            }
            case 1: {
                this.powerLevel = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.slots.clear();
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing par3) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return side != EnumFacing.UP && side != EnumFacing.DOWN && slot == 4;
    }
}

