/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockFumeFunnel;
import net.msrandom.witchery.block.BlockWitchesOven;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.integration.IntegrationManager;

public class TileEntityWitchesOven
extends TileEntity
implements ISidedInventory,
ITickable {
    static final int COOK_TIME = 180;
    private static final double FUNNEL_CHANCE = 0.25;
    private static final double FILTERED_FUNNEL_CHANCE = 0.3;
    private static final double DOUBLED_FILTERED_FUNNEL_CHANCE = 0.8;
    public static final int SLOT_TO_COOK = 0;
    public static final int SLOT_JARS = 1;
    public static final int SLOT_FUEL = 2;
    public static final int SLOT_COOKED = 3;
    public static final int SLOT_BY_PRODUCT = 4;
    private static final int[] SLOTS_TOPS = new int[]{0, 1};
    private static final int[] SLOTS_BOTTOM = new int[]{1, 2};
    private static final int[] SLOTS_SIDES = new int[]{4, 3, 1, 2};
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private String name;

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)slot, (int)count);
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.items, (int)slot);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.name : WitcheryBlocks.WITCHES_OVEN.func_149739_a() + ".name";
    }

    public boolean func_145818_k_() {
        return this.name != null;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.items.size()) continue;
            this.items.set((int)b0, (Object)new ItemStack(nbttagcompound1));
        }
        this.furnaceBurnTime = tag.func_74762_e("BurnTime");
        this.cookTime = tag.func_74762_e("CookTime");
        this.totalCookTime = tag.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)this.items.get(1)));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("BurnTime", this.furnaceBurnTime);
        tag.func_74768_a("CookTime", this.cookTime);
        tag.func_74768_a("CookTimeTotal", this.totalCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.items.get(i)).func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        return tag;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentTranslation(this.func_70005_c_(), new Object[0]) : new TextComponentString(this.func_70005_c_());
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.cookTime * par1 / this.getCookTime();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean updated = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack = (ItemStack)this.items.get(2);
            if (this.isBurning() || !stack.func_190926_b() && !((ItemStack)this.items.get(0)).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)stack);
                    if (this.isBurning()) {
                        updated = true;
                        if (!stack.func_190926_b()) {
                            stack.func_190918_g(1);
                            if (stack.func_190926_b()) {
                                this.items.set(2, (Object)stack.func_77973_b().getContainerItem(stack));
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime();
                        this.smeltItem();
                        updated = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                updated = true;
                BlockWitchesOven.updateWitchesOvenBlockState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (updated) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (((ItemStack)this.items.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack result2 = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.items.get(0));
        if (result2.func_190926_b()) {
            return false;
        }
        Item item = result2.func_77973_b();
        if (item != Items.field_151044_h && !(item instanceof ItemFood) && result2.func_77973_b() != WitcheryIngredientItems.WOOD_ASH) {
            return false;
        }
        if (((ItemStack)this.items.get(3)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.items.get(3)).func_77969_a(result2)) {
            return false;
        }
        int count = ((ItemStack)this.items.get(3)).func_190916_E() + result2.func_190916_E();
        return count <= this.func_70297_j_() && count <= result2.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.items.get(0));
            if (((ItemStack)this.items.get(3)).func_190926_b()) {
                this.items.set(3, (Object)itemstack.func_77946_l());
            } else if (((ItemStack)this.items.get(3)).func_77973_b() == itemstack.func_77973_b()) {
                ItemStack itemStack = (ItemStack)this.items.get(3);
                itemStack.func_190917_f(itemstack.func_190916_E());
            }
            this.generateByProduct();
            ItemStack itemStack2 = (ItemStack)this.items.get(0);
            itemStack2.func_190918_g(1);
        }
    }

    private int getFumeFunnels() {
        int funnels = 0;
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockWitchesOven.FACING);
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                funnels += this.isFumeFunnel(this.func_174877_v().func_177976_e(), facing) ? 1 : 0;
                funnels += this.isFumeFunnel(this.func_174877_v().func_177974_f(), facing) ? 1 : 0;
                break;
            }
            case WEST: 
            case EAST: {
                funnels += this.isFumeFunnel(this.func_174877_v().func_177978_c(), facing) ? 1 : 0;
                funnels += this.isFumeFunnel(this.func_174877_v().func_177968_d(), facing) ? 1 : 0;
            }
        }
        return funnels += this.isFumeFunnel(this.func_174877_v().func_177984_a(), facing) ? 1 : 0;
    }

    private boolean isFumeFunnel(BlockPos pos, EnumFacing facing) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        Block block = state.func_177230_c();
        return (block == WitcheryBlocks.FUME_FUNNEL || block == WitcheryBlocks.FILTERED_FUME_FUNNEL) && state.func_177229_b((IProperty)BlockWitchesOven.FACING) == facing;
    }

    private double getFumeFunnelsChance() {
        double funnels = 0.0;
        switch ((EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockWitchesOven.FACING)) {
            case NORTH: {
                funnels += this.getFumeFunnelChance(this.func_174877_v().func_177974_f(), EnumFacing.NORTH);
                funnels += this.getFumeFunnelChance(this.func_174877_v().func_177976_e(), EnumFacing.NORTH);
                break;
            }
            case SOUTH: {
                funnels += this.getFumeFunnelChance(this.func_174877_v().func_177974_f(), EnumFacing.SOUTH);
                funnels += this.getFumeFunnelChance(this.func_174877_v().func_177976_e(), EnumFacing.SOUTH);
                break;
            }
            case WEST: {
                funnels += this.getFumeFunnelChance(this.func_174877_v().func_177968_d(), EnumFacing.WEST);
                funnels += this.getFumeFunnelChance(this.func_174877_v().func_177978_c(), EnumFacing.WEST);
                break;
            }
            case EAST: {
                funnels += this.getFumeFunnelChance(this.func_174877_v().func_177968_d(), EnumFacing.EAST);
                funnels += this.getFumeFunnelChance(this.func_174877_v().func_177978_c(), EnumFacing.EAST);
            }
        }
        return funnels;
    }

    private double getFumeFunnelChance(BlockPos pos, EnumFacing facing) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockFumeFunnel && state.func_177229_b((IProperty)BlockWitchesOven.FACING) == facing) {
            if (((BlockFumeFunnel)block).isFiltered()) {
                return WitcheryConfigOptions.doubleFumeFilterChance ? 0.8 : 0.3;
            }
            return 0.25;
        }
        return 0.0;
    }

    private int getCookTime() {
        return 180 - 20 * this.getFumeFunnels();
    }

    private void generateByProduct() {
        double funnels = this.getFumeFunnelsChance();
        if (this.field_145850_b.field_73012_v.nextDouble() <= Math.min(0.3 + funnels, 1.0) && !((ItemStack)this.items.get(1)).func_190926_b()) {
            ItemStack slot = (ItemStack)this.items.get(0);
            Item byProduct = WitcheryWoodTypes.getSaplingFumes().get(ItemKey.fromStack(slot));
            if (byProduct == null) {
                Item moddedByProduct = IntegrationManager.getByProduct(slot);
                this.createByProduct(new ItemStack(moddedByProduct == null ? WitcheryFumeItems.FOUL_FUME : moddedByProduct));
            } else {
                this.createByProduct(new ItemStack(byProduct));
            }
        }
    }

    private void createByProduct(ItemStack byProduct) {
        int BY_PRODUCT_INDEX = 4;
        if (((ItemStack)this.items.get(BY_PRODUCT_INDEX)).func_190926_b()) {
            this.items.set(BY_PRODUCT_INDEX, (Object)byProduct);
            ItemStack itemStack = (ItemStack)this.items.get(1);
            itemStack.func_190918_g(1);
        } else if (((ItemStack)this.items.get(BY_PRODUCT_INDEX)).func_77969_a(byProduct) && ((ItemStack)this.items.get(BY_PRODUCT_INDEX)).func_190916_E() + byProduct.func_190916_E() < ((ItemStack)this.items.get(BY_PRODUCT_INDEX)).func_77976_d()) {
            ItemStack itemStack2 = (ItemStack)this.items.get(BY_PRODUCT_INDEX);
            itemStack2.func_190917_f(byProduct.func_190916_E());
            ItemStack itemStack3 = (ItemStack)this.items.get(1);
            itemStack3.func_190918_g(1);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 3 || slot == 4) {
            return false;
        }
        if (slot == 2) {
            return TileEntityFurnace.func_145954_b((ItemStack)stack);
        }
        if (slot == 1) {
            return stack.func_77973_b() == WitcheryFumeItems.CLAY_JAR;
        }
        return slot != 0 || stack.func_77973_b() != WitcheryFumeItems.CLAY_JAR;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.cookTime;
            }
            case 1: {
                return this.furnaceBurnTime;
            }
            case 2: {
                return this.currentItemBurnTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.cookTime = value;
                break;
            }
            case 1: {
                this.furnaceBurnTime = value;
                break;
            }
            case 2: {
                this.currentItemBurnTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOPS : SLOTS_SIDES);
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return false;
        }
        if (side == EnumFacing.DOWN) {
            return slot == 1 && stack.func_77973_b() == Items.field_151133_ar;
        }
        return slot == 3 || slot == 2;
    }
}

