/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntityGoblinGulg;
import net.msrandom.witchery.entity.EntityGoblinMog;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityWorshipStatue
extends WitcheryTileEntity {
    private UUID owner;
    private EntityPlayer player;

    public void setOwner(EntityPlayer player) {
        this.owner = player.func_110124_au();
        this.player = player;
        if (!this.field_145850_b.field_72995_K) {
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
        }
    }

    public void setOwnerId(UUID player) {
        this.owner = player;
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            BlockUtil.notifyBlockUpdate(this.field_145850_b, this.func_174877_v());
        }
    }

    public UUID getOwnerId() {
        return this.owner;
    }

    public EntityPlayer getOwner() {
        return this.getOwner(this.field_145850_b);
    }

    public EntityPlayer getOwner(World world) {
        World world2 = world = world == null ? this.field_145850_b : world;
        if (world != null && this.player == null) {
            this.player = WitcheryUtils.getPlayer(world, this.owner);
            return this.player;
        }
        return this.player;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtRoot) {
        super.func_189515_b(nbtRoot);
        if (this.owner != null) {
            nbtRoot.func_186854_a("Owner", this.owner);
        }
        return nbtRoot;
    }

    public void func_145839_a(NBTTagCompound nbtRoot) {
        super.func_145839_a(nbtRoot);
        if (nbtRoot.func_186855_b("Owner")) {
            this.owner = nbtRoot.func_186857_a("Owner");
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public int updateWorshippersAndGetLevel() {
        double R = 8.0;
        AxisAlignedBB bb = new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + 0.5 - R, (double)this.func_174877_v().func_177956_o() + 0.5 - R, (double)this.func_174877_v().func_177952_p() + 0.5 - R, (double)this.func_174877_v().func_177958_n() + 0.5 + R, (double)this.func_174877_v().func_177956_o() + 0.5 + R, (double)this.func_174877_v().func_177952_p() + 0.5 + R);
        List entities = this.field_145850_b.func_72872_a(EntityGoblin.class, bb);
        int worshipCount = 0;
        for (EntityGoblin goblin : entities) {
            if (goblin.isWorshipping()) {
                ++worshipCount;
                continue;
            }
            goblin.beginWorship(this);
        }
        return worshipCount;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.hasOwner() && this.ticks % 100L == 0L) {
            int worshipCount = this.updateWorshippersAndGetLevel();
            EntityPlayer player = this.getOwner();
            if (player != null) {
                int maxEnergy;
                int currentEnergy;
                player.getEntityData();
                if (worshipCount >= 5 && player.func_174818_b(this.func_174877_v()) <= 4096.0 && (currentEnergy = Infusion.getCurrentEnergy(player)) < (maxEnergy = Infusion.getMaxEnergy(player))) {
                    Infusion.setCurrentEnergy(player, Math.min(currentEnergy + 30, maxEnergy));
                    player.func_184185_a(SoundEvents.field_189107_dL, 0.5f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 2.0f, EnumParticleTypes.SPELL_INSTANT), (Entity)player);
                }
                if (worshipCount >= 10) {
                    PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                    playerEx.addWorship(worshipCount >= 15 ? 1 : 0);
                }
                if (worshipCount >= 15 && WitcheryConfigOptions.hobgoblinGodSpawnChance > 0 && this.field_145850_b.field_73012_v.nextDouble() < (double)WitcheryConfigOptions.hobgoblinGodSpawnChance * 1.0E-4) {
                    this.summonGoblinGods(player, 64.0, 16);
                }
            }
        }
    }

    public boolean summonGoblinGods(EntityPlayer player, double detectDistance, int spawnDistance) {
        EntityGoblinMog mog;
        BlockPos pos = this.func_174877_v();
        AxisAlignedBB bb2 = new AxisAlignedBB(pos.func_177963_a(-detectDistance, -detectDistance, -detectDistance), pos.func_177963_a(detectDistance, detectDistance, detectDistance));
        if (this.field_145850_b.func_72872_a(EntityGoblinMog.class, bb2).size() == 0 && this.field_145850_b.func_72872_a(EntityGoblinGulg.class, bb2).size() == 0 && (mog = Infusion.spawnCreature(this.field_145850_b, EntityGoblinMog.class, pos, (EntityLivingBase)player, 0, spawnDistance, EnumParticleTypes.FLAME, SoundEvents.field_187855_gD)) != null) {
            mog.func_180482_a(this.field_145850_b.func_175649_E(mog.func_180425_c()), null);
            mog.func_70624_b((EntityLivingBase)player);
            EntityGoblinGulg gulg = new EntityGoblinGulg(this.field_145850_b);
            gulg.func_70012_b(((EntityCreature)mog).field_70165_t, ((EntityCreature)mog).field_70163_u, ((EntityCreature)mog).field_70161_v, 0.0f, 0.0f);
            this.field_145850_b.func_72838_d((Entity)gulg);
            gulg.func_180482_a(this.field_145850_b.func_175649_E(mog.func_180425_c()), null);
            gulg.func_70624_b((EntityLivingBase)player);
            return true;
        }
        return false;
    }
}

