/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing;

import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.msrandom.witchery.WitcheryResurrected;

public class BrewNameBuilder {
    final ArrayList<Part> parts = new ArrayList();
    final ArrayList<String> prefixes = new ArrayList();
    final ArrayList<String> postfixes = new ArrayList();
    private final boolean displayName;
    int dispersalExtent;
    int dispersalDuration;
    int strength;
    int durationModifier;
    int totalStrength;
    int totalDuration;
    boolean inverted;
    boolean removePowerCeiling;

    public BrewNameBuilder(boolean displayName) {
        this.displayName = displayName;
    }

    private static String ticksToElapsedTime(int p_76337_0_) {
        int j = p_76337_0_ / 20;
        int k = j / 60;
        return (j %= 60) < 10 ? k + ":0" + j : k + ":" + j;
    }

    public void append(String text2, String invertedText, long duration) {
        StringBuilder builder = new StringBuilder();
        if (this.inverted) {
            builder.append(invertedText);
        } else {
            builder.append(text2);
        }
        this.inverted = false;
        if (!this.displayName && this.strength > 0) {
            builder.append(" ");
            builder.append(I18n.func_135052_a((String)("enchantment.level." + (this.strength + 1)), (Object[])new Object[0]));
        }
        this.strength = 0;
        this.parts.add(new Part(builder.toString(), duration * (long)(this.durationModifier + 1)));
        this.durationModifier = 0;
    }

    public void appendPrefix(String text2) {
        this.prefixes.add(text2);
        if (!this.displayName && this.dispersalExtent > 0) {
            this.prefixes.add(I18n.func_135052_a((String)("enchantment.level." + (this.dispersalExtent + 1)), (Object[])new Object[0]));
        }
        this.dispersalExtent = 0;
        if (!this.displayName && this.dispersalDuration > 0) {
            this.prefixes.add(String.format("[%s %s]", WitcheryResurrected.translateSplit("brew.witchery.lifetime", new Object[0]), I18n.func_135052_a((String)("enchantment.level." + (this.dispersalDuration + 1)), (Object[])new Object[0])));
        }
        this.dispersalDuration = 0;
    }

    public void appendPostfix(String text2) {
        this.postfixes.add(text2);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String text2 : this.prefixes) {
            builder.append(text2);
            builder.append(" ");
        }
        if (this.displayName) {
            builder.append(WitcheryResurrected.translateSplit("brew.witchery.potion", new Object[0]));
            builder.append(" ");
        } else {
            builder.append("\n");
        }
        if (this.parts.size() > 0) {
            for (int i = 0; i < this.parts.size(); ++i) {
                builder.append(this.parts.get(i).toString(this.prefixes.size() > 0, this.displayName));
                builder.append(this.displayName ? (i < this.parts.size() - 2 ? ", " : (i < this.parts.size() - 1 ? " & " : " ")) : "\n");
            }
        } else {
            builder.append(WitcheryResurrected.translateSplit("brew.witchery.potionwater", new Object[0]));
            if (!this.displayName) {
                builder.append("\n");
            }
        }
        for (String text2 : this.postfixes) {
            builder.append(text2);
            builder.append(" ");
        }
        builder.trimToSize();
        return builder.toString();
    }

    public void addStrength(int strength2) {
        if (this.totalStrength < 7 || this.removePowerCeiling) {
            this.strength += strength2;
            this.totalStrength += strength2;
        }
    }

    public void addDuration(int duration) {
        if (this.totalDuration < 7 || this.removePowerCeiling) {
            this.durationModifier += duration;
            this.totalDuration += duration;
        }
    }

    private static class Part {
        final String base;
        final long duration;

        private Part(String base, long duration) {
            this.base = base;
            this.duration = duration;
        }

        public String toString(boolean splash, boolean terse) {
            long modDuration;
            long l = modDuration = splash && this.duration > 0L ? this.duration / 2L : this.duration;
            if (!terse && modDuration > 0L) {
                return this.base + " [" + BrewNameBuilder.ticksToElapsedTime((int)modDuration) + "]";
            }
            return this.base;
        }
    }
}

